/*
 * Decompiled with CFR 0.152.
 */
package com.github.RSQLServer;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class MSSQLResultPull {
    public static final boolean RP_DEBUG = false;
    public static final int CT_STRING = 0;
    public static final int CT_NUMERIC = 1;
    public static final int CT_INT = 2;
    public static final int CT_DATE = 3;
    public static final int CT_TIME = 4;
    public static final int CT_BOOLEAN = 5;
    public static final double NA_double = Double.longBitsToDouble(9218868437227407266L);
    public static final int NA_int = Integer.MIN_VALUE;
    ResultSet rs;
    int[] cTypes;
    Object[] data;
    int capacity;
    int count;
    int cols;

    public MSSQLResultPull(ResultSet resultSet) throws SQLException {
        this.rs = resultSet;
        this.cTypes = this.mapColumns();
        this.cols = this.cTypes == null ? 0 : this.cTypes.length;
        this.data = new Object[this.cols];
        this.capacity = -1;
        this.count = 0;
    }

    public int columns() {
        return this.cols;
    }

    public int count() {
        return this.count;
    }

    public void setCapacity(int n) {
        if (this.capacity != n) {
            block7: for (int i = 0; i < this.cols; ++i) {
                switch (this.cTypes[i]) {
                    case 1: {
                        this.data[i] = new double[n];
                        continue block7;
                    }
                    case 2: {
                        this.data[i] = new int[n];
                        continue block7;
                    }
                    case 3: {
                        this.data[i] = new String[n];
                        continue block7;
                    }
                    case 4: {
                        this.data[i] = new String[n];
                        continue block7;
                    }
                    case 5: {
                        this.data[i] = new String[n];
                        continue block7;
                    }
                    default: {
                        this.data[i] = new String[n];
                    }
                }
            }
            this.capacity = n;
        }
    }

    public int fetch(int n, int n2) throws SQLException {
        this.setCapacity(n);
        if (n2 > 0) {
            try {
                this.rs.setFetchSize(n2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.count = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        while (this.rs.next()) {
            block10: for (int i = 0; i < this.cols; ++i) {
                switch (this.cTypes[i]) {
                    case 1: {
                        double d = this.rs.getDouble(i + 1);
                        if (this.rs.wasNull()) {
                            d = NA_double;
                        }
                        ((double[])this.data[i])[this.count] = d;
                        continue block10;
                    }
                    case 2: {
                        int n3 = this.rs.getInt(i + 1);
                        if (this.rs.wasNull()) {
                            n3 = Integer.MIN_VALUE;
                        }
                        ((int[])this.data[i])[this.count] = n3;
                        continue block10;
                    }
                    case 4: {
                        Timestamp timestamp = this.rs.getTimestamp(i + 1);
                        ((String[])this.data[i])[this.count] = this.rs.wasNull() ? null : simpleDateFormat.format(timestamp);
                        continue block10;
                    }
                    case 3: {
                        Date date = this.rs.getDate(i + 1);
                        ((String[])this.data[i])[this.count] = this.rs.wasNull() ? null : simpleDateFormat2.format(date);
                        continue block10;
                    }
                    case 5: {
                        String string = String.valueOf(this.rs.getBoolean(i + 1));
                        if (this.rs.wasNull()) {
                            string = null;
                        }
                        ((String[])this.data[i])[this.count] = string;
                        continue block10;
                    }
                    default: {
                        String string;
                        ((String[])this.data[i])[this.count] = string = this.rs.getString(i + 1);
                    }
                }
            }
            ++this.count;
            if (this.count < this.capacity) continue;
            return this.count;
        }
        return this.count;
    }

    public Object getColumnData(int n) {
        return n > 0 && n <= this.cols ? this.data[n - 1] : null;
    }

    public String[] getStrings(int n) {
        String[] stringArray = (String[])this.data[n - 1];
        if (this.count == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[this.count];
        if (this.count > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, this.count);
        }
        return stringArray2;
    }

    public double[] getDoubles(int n) {
        double[] dArray = (double[])this.data[n - 1];
        if (this.count == dArray.length) {
            return dArray;
        }
        double[] dArray2 = new double[this.count];
        if (this.count > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, this.count);
        }
        return dArray2;
    }

    public int[] getInts(int n) {
        int[] nArray = (int[])this.data[n - 1];
        if (this.count == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[this.count];
        if (this.count > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, this.count);
        }
        return nArray2;
    }

    public int[] mapColumns() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = resultSetMetaData.getColumnType(i + 1);
            nArray[i] = n2 == -5 || n2 == 2 || n2 == 3 || n2 == 6 || n2 == 7 || n2 == 8 ? 1 : (n2 == -6 || n2 == 5 || n2 == 4 ? 2 : (n2 == 91 ? 3 : (n2 == 93 ? 4 : (n2 == -7 || n2 == 16 ? 5 : 0))));
        }
        return nArray;
    }

    public int[] columnTypes() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = resultSetMetaData.getColumnType(i + 1);
        }
        return nArray;
    }

    public String[] columnTypeNames() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnTypeName(i + 1);
        }
        return stringArray;
    }

    public String[] columnNames() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnName(i + 1);
        }
        return stringArray;
    }
}

