% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scelestial.R
\name{as.mutation.matrix}
\alias{as.mutation.matrix}
\title{Conversion of ten-state sequencing matrix to 0/1-mutation matrix.}
\usage{
as.mutation.matrix(seq)
}
\arguments{
\item{seq}{A dataframe representing the ten-state sequencing matrix. Elements of the matrix
are the from "X/Y" for X and Y being nucleotides or "./." for missing value.
Rows represent loci and columns represent samples.}
}
\value{
A data frame with exactly the same size as the input \code{seq} matrix.
  The most abundant state in each loci (row) translated to 0, and 
  the others are translated to 1. Missing values are translated to 3.
}
\description{
Conversion of ten-state sequencing matrix to 0/1-mutation matrix.
}
\examples{
## A small 10-state matrix
seq = data.frame("C1" = c("C/C", "C/C"), "C2" = c("A/A", NA), 
        "C3" = c("C/C", "A/A"), stringsAsFactors = TRUE)
## Convert it to mutation matrix
as.mutation.matrix(seq)
#   C1 C2 C3
# 1  0  1  0
# 2  1  3  0

}
