% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateMap.R
\name{validateMap}
\alias{validateMap}
\title{Map accuracy assessment}
\usage{
validateMap(
  map,
  valData,
  responseCol,
  nSamplesV = 500,
  mode = "classification",
  classMapping = NULL
)
}
\arguments{
\item{map}{SpatRaster. The classified map.}

\item{valData}{sf object with validation data (POLYGONs or POINTs).}

\item{responseCol}{Character. Column containing the validation data in attribute table of \code{valData}.}

\item{nSamplesV}{Integer. Number of pixels to sample for validation (only applies to polygons).}

\item{mode}{Character. Either 'classification' or 'regression'.}

\item{classMapping}{optional data.frame with columns \code{'class'} and \code{'classID'} defining the mapping from raster integers to class names.}
}
\value{
Returns a structured list includng the preformance and confusion-matrix of your then validated input data
}
\description{
validate a map from a classification or regression model. This can be useful to update the accuracy assessment after filtering, e.g. for a minimum mapping unit.
}
\examples{
library(caret)
library(terra)

## Training data
poly     <- readRDS(system.file("external/trainingPolygons_lsat.rds", package="RStoolbox"))

## Split training data in training and validation set (50\%-50\%)
splitIn   <- createDataPartition(poly$class, p = .5)[[1]]
train <- poly[splitIn,]
val   <- poly[-splitIn,]

## Classify (deliberately poorly)
sc <- superClass(lsat, trainData = train, responseCol = "class", nSamples = 50, model = "mlc")

## Polish map with majority filter

polishedMap <- focal(sc$map, matrix(1,3,3), fun = modal) 

## Validation
## Before filtering
val0 <- validateMap(sc$map, valData = val, responseCol = "class",
                            classMapping = sc$classMapping)
## After filtering
val1 <- validateMap(polishedMap, valData = val, responseCol = "class",
                             classMapping = sc$classMapping)
}
