% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RestoreSession.R
\name{RestoreSession}
\alias{RestoreSession}
\title{Restore R Session from Source Files}
\usage{
RestoreSession(path, save.objs, fun.call)
}
\arguments{
\item{path}{character.
Directory pathname; if missing a folder browser pop up dialog box is implemented.}

\item{save.objs}{character.
Vector of local object names.
These objects will be preserved during the recompiling process.}

\item{fun.call}{character.
Name of the function to call after restoring the session (optional).}
}
\value{
Used for the side-effect of an updated \R session compiled from source code files (\file{.R})
  located in \code{path} and its recursive directories.
}
\description{
This function restores local objects within the current \R session.
}
\examples{
\dontrun{
  RestoreSession()
}

}
\seealso{
\code{\link{list.files}}, \code{\link{source}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
