% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormatDateTime.R
\name{FormatDateTime}
\alias{FormatDateTime}
\title{GUI: Build Date-Time String Formats}
\usage{
FormatDateTime(sample = as.POSIXct("1991-08-25 20:57:08"), fmt = "",
  parent = NULL)
}
\arguments{
\item{sample}{POSIXt or Date.
Sample date-time}

\item{fmt}{character.
Conversion specification format}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns a character string representing the formatted date-time value.
}
\description{
A graphical user interface (\acronym{GUI}) for converting between character representations
and objects of class \code{POSIXt} or \code{Date}.
}
\examples{
\dontrun{
  new.fmt <- FormatDateTime(fmt = "\%A \%B \%d \%I:\%M \%p")
  FormatDateTime(Sys.Date())
}

}
\seealso{
\code{\link{strptime}}, \code{\link{format}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
