% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscape.R
\name{getGenscapePipeOil}
\alias{getGenscapePipeOil}
\title{\code{getGenscapePipeOil}}
\usage{
getGenscapePipeOil(
  frequency = "daily",
  regions = "Canada",
  pipelineIDs = c(97),
  revision = "revised",
  limit = 5000,
  offset = 0,
  startDate = "2015-01-01",
  endDate = as.character(Sys.Date()),
  apikey = "yourapikey"
)
}
\arguments{
\item{frequency}{"daily" DEFAULT.}

\item{regions}{See API webpage. Multiple values separated by commas e.g. "Canada", "GulfCoast").}

\item{pipelineIDs}{See API webpage. c(98,54...) for specific pipes.}

\item{revision}{See API webpage.}

\item{limit}{See API webpage. Max 5000}

\item{offset}{See API webpage.}

\item{startDate}{"yyyy-mm-dd" as character string}

\item{endDate}{"yyyy-mm-dd" as character string}

\item{apikey}{Your API key as a character string.}
}
\value{
wide data frame
}
\description{
Returns oil pipeline flows in barrels per day data from Genscape API.You need your own credentials.
Refer to API documentation for argument values. It is assumed if you use this function that
you know the pipelines you need to extract to build supply demand balances.
Use the online API to identify the pipeline IDs.
https://developer.genscape.com/docs/services/oil-transportation/operations/GetPipelineFlowValuesV2/
}
\examples{
\dontrun{
getGenscapePipeOil(frequency = "daily", regions = "Canada",pipelineIDs = c(97),
                  revision = "revised", limit = 5000, offset = 0,
                  startDate = "2015-01-01", endDate = as.character(Sys.Date()),
                  apikey = "yourapikey")
}
}
\author{
Philippe Cote
}
