% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swapFutWeight.R
\name{swapFutWeight}
\alias{swapFutWeight}
\title{Commodity Calendar Month Average Swap futures weights}
\usage{
swapFutWeight(
  Month = "2020-09-01",
  contract = "cmewti",
  exchange = "nymex",
  output = "first.fut.weight"
)
}
\arguments{
\item{Month}{First calendar day of the month. \code{character}}

\item{contract}{Contract code in data(expiry_table). sort(unique(expiry_table$cmdty)) for options. \code{character}}

\item{exchange}{Exchange code in data(holidaysOil). Currently only "nymex" and "ice" supported. \code{character}}

\item{output}{Either "numDaysFut1", "numDaysFut2" or "first.fut.weight". \code{character}}
}
\value{
Depending on output setting. \code{numeric}
If first.fut.weight, to compute swap 1 - first.fut.weight = \% applied to 2nd line contract.
}
\description{
Returns the percentage weight of the future in Calendar Month Average swaps
}
\examples{
swapFutWeight(
  Month = "2020-09-01",
  contract = "cmewti", exchange = "nymex", output = "first.fut.weight"
)
}
\author{
Philippe Cote
}
