\name{classify_model}
\alias{classify_model}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
makes predictions from a train_model() object.
}
\description{
Uses a trained model from the \code{\link{train_model}} function to classify new data.
}
\usage{
classify_model(container, model, s=0.01, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{container}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_container}} function.
}
  \item{model}{
Slot for trained SVM, SLDA, boosting, bagging, RandomForests, glmnet, decision tree, neural network, or maximum entropy model generated by \code{\link{train_model}}.
}
  \item{s}{
Penalty parameter lambda for \pkg{glmnet} classification.
}
  \item{\dots}{
Additional parameters to be passed into the \code{predict} function of any algorithm.
}
}
\details{
Only one model may be passed in at a time for classification. See \code{\link{train_models}} and \code{\link{classify_models}} to train and classify using multiple algorithms.
}
\value{
Returns a \code{data.frame} of predicted codes and probabilities for the specified algorithm.
}
\author{
Loren Collingwood <lorenc2@uw.edu>, Timothy P. Jurka <tpjurka@ucdavis.edu>
}

\examples{
library(RTextTools)
data(NYTimes)
data <- NYTimes[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data["Title"],data["Subject"]), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=tm::weightTfIdf)
container <- create_container(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
maxent_model <- train_model(container,"MAXENT")
maxent_results <- classify_model(container,maxent_model)
}

\keyword{method}
