% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.TTC.R
\name{duration.TTC}
\alias{duration.TTC}
\title{Duration - Data Weighting and "TTC" Calculation}
\usage{
duration.TTC(lstCnt,lstInit,gYear,snapshots,nStates,transtype,TotalDateRange)
}
\arguments{
\item{lstCnt}{annual off-diagonal transition counts (matrix)}

\item{lstInit}{Initial counts for each state (start vector)}

\item{gYear}{count of annual date vector.}

\item{snapshots}{integer indicating the number of credit-rating snapshots per year to be considered for the estimation. Valid values are 1, 4, or 12. The default value is 1, \emph{i.e., one snapshot per year}. This parameter is only used in the 'cohort' algorithm.}

\item{nStates}{number of rating categories.}

\item{transtype}{averaging method. The valid values
\itemize{
\item{\emph{transRaw}}
\item{\emph{genAverage}}
\item{\emph{transAverageGen}}
\item{\emph{transAverage}}
\item{\emph{individualAnnualTrans}}
}}

\item{TotalDateRange}{annual date vector.}
}
\value{
\item{transRaw}{transition matrix created from generator matrix created using the average annual transition counts and average annual.}

\item{genAverage}{average annual generator matrix.}

\item{transAverageGen}{transition matrix from average annual generator matrix.}

\item{transAnnual}{individual annual transition matrices.}
}
\description{
Calculating \emph{Through-the-Cycle} generator matrix and transition counts using \emph{duration method}
}
\details{
Given data representing \emph{x} years of monthly off-diagonal transition counts, this function combines those data to obtain average monthly counts,
in such a way as to preserve the information while implementing a weighting scheme that would allow for the weighting of the historical experiences.

Let \eqn{T(m,y)} and \eqn{F(m,y)} represent the off-diagonal transition matrix and 'firm-years' vector, for month = \eqn{m} and year = \eqn{y},
respectively. Then,
\deqn{T(m,y) = \{T_{ij}(m,y)\}_{i,j\,=\,1,\ldots,K}}
\deqn{F(m,y) =  \{F_{i}(m,y)\}_{i\,=\,1,\ldots,K}}

Many credit risk models require a \emph{long-run average} PD estimate. This has been interpreted as meaning the data from multiple years should be
combined and in a method capable of supporting some form of weighting of samples.
The three methods of weighting considered for data generated via the \emph{duration method} are:
\enumerate{
	\item Scale the number of transitions and firm counts/years using the a single year count to preserve dynamics, then average transitions and firms
	counts/years separately to create a generator matrix.
	\item Estimate the single-year quantities \emph{(annual generator matrices)}, then average across years
	\item Average annual transition matrices
}
The Markov property allows for direct weighting as each year can be regarded as distinct.
}
\examples{

TotalDateRange <- seq(as.Date("2000-01-01"), as.Date("2002-01-01"), "years")

snapshots <- 1    #This uses a 1 year transition matrices
interval <- 1     #This gives a 1 year transition matrix

lstCnt <-rep(list(list()), length(TotalDateRange)-1)
lstInit <-rep(list(list()), length(TotalDateRange)-1)
kk <- 1
k <- 1

#Create transition and inital countsused as inputs to the function
for (l in 1:(length(TotalDateRange)-1)){

  istartDate = POSIXTomatlab(as.POSIXlt(as.Date(TotalDateRange[l],format = "\%Y-\%m-\%d")))
  iendDate = POSIXTomatlab(as.POSIXlt(as.Date(TotalDateRange[l+1],format = "\%Y-\%m-\%d")))
  DateRange        <- as.Date(matlabToPOSIX(cfdates(istartDate,iendDate,snapshots)))

  for(i in 1:(length(DateRange)-1)){

    sDate  <- DateRange[i]       # i.e "3/31/1990"
    eDate    <- DateRange[i+1]     # i.e "6/30/1990"

    t<-TransitionProb(data,sDate, eDate, 'duration', snapshots, interval)

    lstCnt[[k]][[kk]] <- t$sampleTotals$totalsMat
    lstInit[[k]][[kk]]  <- t$sampleTotals$totalsVec

    if(kk>=snapshots){
      kk <- 1
      k <- k+1
    } else {
      kk <- kk+1
    }

  }

}



transtype <- "genAverage"
gYear <- utils::head(TotalDateRange,-1)
nStates <- nrow(as.data.frame(lstInit[[1]][1]))

AverageGeneratorMatrices<-duration.TTC(lstCnt,lstInit,gYear,snapshots,nStates,transtype,
TotalDateRange)

}
\author{
Abdoulaye (Ab) N'Diaye
}
