% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap.expr}
\alias{plot_heatmap.expr}
\title{Plot Heatmap From Raw CPM}
\usage{
plot_heatmap.expr(
  data = ~count,
  annot = ~meta,
  sample.id = "sample_id",
  annot.flags = c("day", "Treatment", "tissue"),
  ct.table.id.type = "ENSEMBL",
  gene.id.type = "SYMBOL",
  gene.names = NULL,
  gene.count = 10,
  title = "RVA Heatmap",
  fill = "CFB",
  baseline.flag = "day",
  baseline.val = "0",
  plot.save.to = NULL,
  input.type = "count"
)
}
\arguments{
\item{data}{A wide-format dataframe with geneid rownames, sample column
names, and fill data matching \code{input.type}.}

\item{annot}{A long-format dataframe with any pertinent treatment data about
the samples. The only required column is one titled the \code{sample.id}
value with values matching the column names of sample IDs in \code{data}.
Additional columns can contain information such as treament
compounds, dates of sample collection, or dosage quantities.}

\item{sample.id}{The column name to specify sample ID.}

\item{annot.flags}{A vector of column names corresponding to column names
in \code{annot} which will be used to define the x-axis for the heatmap.
Default = \code{c("day", "dose")}.}

\item{ct.table.id.type}{The gene id format in \code{data} should be one of:
ACCNUM, ALIAS, ENSEMBL, ENSEMBLPROT, ENSEMBLTRANS,
ENTREZID, ENZYME, EVIDENCE, EVIDENCEALL, GENENAME, GO, GOALL, IPI,
MAP, OMIM, ONTOLOGY, ONTOLOGYALL, PATH, PFAM, PMID, PROSITE, REFSEQ,
SYMBOL, UCSCKG, UNIGENE, UNIPROT.}

\item{gene.id.type}{The gene id format of \code{gene.names}, should be one of:
ACCNUM, ALIAS, ENSEMBL, ENSEMBLPROT, ENSEMBLTRANS,
ENTREZID, ENZYME, EVIDENCE, EVIDENCEALL, GENENAME, GO, GOALL, IPI,
MAP, OMIM, ONTOLOGY, ONTOLOGYALL, PATH, PFAM, PMID, PROSITE, REFSEQ,
SYMBOL, UCSCKG, UNIGENE, UNIPROT.}

\item{gene.names}{A character vector or list of ensembl IDs for which to
display gene information. If \code{NULL}, all genes will be included.
Default = \code{NULL}.}

\item{gene.count}{The number of genes to include, where genes are selected
based on ranking by values in \code{fill}. Default = 10.}

\item{title}{A title for the heatmap. Default = "RVA Heatmap".}

\item{fill}{One of \code{c("CPM", "CFB")} to fill the heatmap cells with.
Default = "CFB".}

\item{baseline.flag}{A character vector of column names. If \code{fill = "CFB"},
these columns in \code{annot} contain the values to compare
across. Ignored if \code{fill = "CPM"}. Default = "timepoint".}

\item{baseline.val}{A character vector of values. This vector must be the
same length as \code{baseline.flag}, and the value at each index must
represent a value from the column given by the corresponding index
in \code{baseline.flag}. The samples corresponding to these values will
be used as a baseline when calculating CFB. Ignored if
\code{fill = "CPM"}. Default = "Week 0".}

\item{plot.save.to}{The address to save the heatmap plot.}

\item{input.type}{One of \code{count} or \code{cpm} indicating what the input data type
is. If \code{count}, the CPM of the input data will be calculated using
\code{\link[edgeR:cpm]{edgeR::cpm()}}. Default = \code{count}.}
}
\value{
The function returns a list with 2 items:
\item{df.sub}{"A data frame of change from baselines values (fill = CFB in this example) for each gene id that is divided by a combination of treatment group and time point}
\item{gp}{A Heatmap object from ComplexHeatmap which can be plotted}
}
\description{
Create a heatmap with either CFB or CPM averaged across
individual samples.
}
\details{
The function takes raw CPM data and returns both a list containing a data frame
with values based on the fill parameter and a heatmap plot.
}
\examples{
plot <- plot_heatmap.expr(data = count_table[,1:20],annot = sample_annotation[1:20,])
}
\references{
Xingpeng Li,Tatiana Gelaf Romer & Aliyah Olaniyan, RVA - RNAseq Visualization Automation tool.
}
