\name{cor.2comp}
\alias{cor.2comp}
\title{
Comparaison de 2 coefficients de correlation lineaire de Pearson
}
\description{
Ralise le test de comparaison de 2 coefficients de corrlation linaire de Pearson.  Si la diffrence n'est pas significative, la fonction renvoie la valeur du coefficient de corrlation commun, son intervalle de confiance et le rsultat du test de conformit avec une valeur thorique choisie.
}
\usage{
cor.2comp(var1, var2, var3, var4, alpha = 0.05, conf.level = 0.95, r.arr = 4, theo = 0, p.arr = 4)
}
\arguments{
  \item{var1}{
1re variable dfinissant la 1re corrlation.
}
  \item{var2}{
2me variable dfinissant la 1re corrlation.
}
  \item{var3}{
1re variable dfinissant la 2me corrlation.
}
  \item{var4}{
2me variable dfinissant la 2me corrlation.
}
  \item{alpha}{
seuil de significativit du test de comparaison des 2 coefficients de corrlation.
}
  \item{conf.level}{
intervalle de confiance du coefficient de corrlation commun.
}
  \item{r.arr}{
nombre de dcimales affiches des coefficients de corrlation.
}
  \item{theo}{
valeur thorique pour le test de conformit du coefficient de corrlation commun.
}
  \item{p.arr}{
nombre de dcimales affiches des \emph{p-values} des tests raliss.
}
}
\author{
Maxime Herv
}
\seealso{
\code{\link{cor.test}}
}
\examples{
# Test par defaut
cor1.var1<-1:30+rnorm(30,0,2)
cor1.var2<-1:30+rnorm(30,0,3)
cor2.var1<--1:-30+rnorm(30,0,2)
cor2.var2<--1:-30+rnorm(30,0,3)
cor.2comp(cor1.var1,cor1.var2,cor2.var1,cor2.var2)

# Seuil de significativite a 3 pc et conformite du coefficient de correlation commun
# avec la valeur 0.5
 cor.2comp(cor1.var1,cor1.var2,cor2.var1,cor2.var2,alpha=0.03,theo=0.5)
}
