% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EP.WM.R
\docType{data}
\name{EP.WM}
\alias{EP.WM}
\title{Expected patterns of white matter}
\format{
A data frame with 24 rows and 14 variables:
\describe{
\item{WM}{white matter fractional anisotropy}
\item{SSD}{the expected pattern of Schizophrenia Spectrum Disorder (\doi{10.1038/mp.2017.170} table 1; \doi{10.1002/hbm.24998} table 2)}
\item{MDD}{the expected pattern of Major Depressive Disorder (\doi{10.1038/s41380-019-0477-2} Table S4; \doi{10.1002/hbm.24998} table 2)}
\item{AD_ADNI}{the expected pattern of Alzheimer's Disease (\doi{10.1016/j.nicl.2021.102574} table S1)}
\item{AD_ADNIOSYRIX}{the expected pattern of Alzheimer's Disease Neuroimaging Initiative + OSIRIX}
\item{BD}{the expected pattern of Bipolar Disorder (\doi{10.1002/hbm.24998} table 2)}
\item{Diabetes}{the expected pattern of Diabetes}
\item{HighBP}{the expected pattern of Hypertension}
\item{HighLipids}{the expected pattern of Hyperlipidemia}
\item{MET}{the expected pattern of Metabolic diseases (diabetes, hypertension and hyperlipidemia)}
\item{DS_22q}{the expected pattern of 22q11.2 deletion syndrome (\doi{10.1002/hbm.24998} table 2; \doi{10.1038/s41380-019-0450-0} table S6)}
\item{PTSD}{the expected pattern of Post-traumatic stress disorder (\doi{10.1002/hbm.24998} table 2)}
\item{TBI}{the expected pattern of Traumatic brain injury (\doi{10.1002/hbm.24998} table 2)}
\item{OCD}{the expected pattern of Obsessive-compulsive disorder (\doi{10.1002/hbm.24998} table 2)}
}
}
\source{
The 'EP.WM' pattern is from Maryland Psychiatric Research Center, Department of Psychiatry, University of Maryland School of Medicine.
}
\usage{
EP.WM
}
\description{
the expected patterns of white matter in schizophrenia derived from large-scale meta-analyses by the ENIGMA.
}
\keyword{datasets}
