% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue.VCC3.R
\name{pvalue.VCC3}
\alias{pvalue.VCC3}
\title{Compute p-values for the VC-C3 method}
\usage{
pvalue.VCC3(P, G, W, Nperm, n, pedigree, haplotypes, generation.id,
  Ncores = 1)
}
\arguments{
\item{P}{a matrix which can be obtained as output of the function
\code{\link{Preparation.VCC}}.}

\item{G}{the genotype matrix}

\item{Nperm}{(integer) The number of permutations to be done to
calculate the empirical p-value if the VCC2 or VCC3 method is
used. For other methods this parameter is ignored (default:
100).}

\item{n}{Integer, the number of samples}

\item{pedigree}{a pedigree as output by
\code{\link{read.pedigree}}. This is a data frame consisting of
four columns (family ID, individual ID, father ID and mother ID)
as use in the traditional linkage format and e.g. Plink files.}

\item{haplotypes}{a matrix of the haplotypes of the individuals}

\item{generation.id}{a vector of length(sample size) which
indicates if the subject is founder (\code{generation.id=0}),
a child from first generation (\code{generation.id=1}), a
child from second generation (\code{generation.id=2}), etc.
This vector can be calculated by the
\code{kinship2::kindepth()} function.}

\item{Ncores}{(integer) Number of processor (CPU) cores to be used
in parallel when doing the permutations to determine the
p-value (default: 1).}
}
\value{
the outcomes of the VC-C3 association test on the given
    region, which is a list with the following elements:
    \itemize{
    \item \code{score}: The score test
    \item \code{p.value.VCC2}: The p-value as output by the VC-C2
    method (\code{\link{pvalue.VCC2}}).
    \item \code{p.value.VCC3}: This is the exact p-vlaue for small
    level size. The approach to obtain this second p-value
    approximates the distribution of the test statistic under the
    null model by a non-central chi-square using matching moments
    of the first, the second and the fourth moments. The
    estimation of the three moments are approximated empirically
    using the permutations that were used to calculate the VC-C2
    p-value.
    }
}
\description{
Compute p-values for the VC-C3 method
}
\author{
Karim Oualkacha

M'Hamed Lajmi Lakhal-Chaieb
}
\seealso{
\code{\link{pvalue.VCC1}}, \code{\link{pvalue.VCC2}}
}
\keyword{internal}

