% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.haplo.bedfile.R
\name{read.haplo.bedfile}
\alias{read.haplo.bedfile}
\title{Read haplotype data, selected by region of interest, from BED files
(regular PLINK binary files)}
\usage{
read.haplo.bedfile(filename = "NULL", map, chr = "NULL",
  startpos = "NULL", endpos = "NULL")
}
\arguments{
\item{filename}{character, path to BED file containing haplotype
data. Attention! filename should contain path to \code{<file>.bed}
with full file name. For example \code{../mydata/inputplink.bed}.}

\item{map}{object, data.frame contains 3 columns: rsID, chromosome,
position in bp as output by e.g. \code{\link{readMapFile}}.}

\item{chr}{character, chromosome number (basically from 1 to 22 as used by
\href{http://pngu.mgh.harvard.edu/~purcell/plink/data.shtml#ped}{Plink}),
on which the region of interest is located}

\item{startpos}{numeric, start position (in bp, base pairs) of the
region of interest (default: 0)}

\item{endpos}{numeric, end position (in bp, base pairs) of the
region of interest (default: 0)}
}
\value{
matrix object containing the haplotypes selected by the
region of interest
}
\description{
Read haplotype data, selected by region of interest, from BED files
(regular PLINK binary files)
}
\seealso{
\code{\link{read.haplo}},
\code{\link{read.haplo.pedfile}},
\code{\link{read.haplo.shapeit_haps}},
\code{\link{readMapFile}}
}
\keyword{internal}

