/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import weka.classifiers.functions.pace.Maths;

public class Matrix
implements Cloneable,
Serializable {
    protected double[][] A;
    protected int m;
    protected int n;

    public Matrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public Matrix(int n, int n2, double d) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.A[i][j] = d;
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        for (int i = 0; i < this.m; ++i) {
            if (dArray[i].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = dArray;
    }

    public Matrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public Matrix(double[] dArray, int n) {
        this.m = n;
        int n2 = this.n = n != 0 ? dArray.length / n : 0;
        if (n * this.n != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[n][this.n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = dArray[i + j * n];
            }
        }
    }

    public static Matrix constructWithCopy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.getArray();
        for (int i = 0; i < n; ++i) {
            if (dArray[i].length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return matrix;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return dArray;
    }

    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i + j * this.m] = this.A[i][j];
            }
        }
        return dArray;
    }

    public double[] getRowPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i * this.n + j] = this.A[i][j];
            }
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n, int n2) {
        return this.A[n][n2];
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    dArray[i - n][j - n3] = this.A[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    dArray[i][j] = this.A[nArray[i]][nArray2[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int n, int n2, int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[i - n][j] = this.A[i][nArray[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    dArray[i][j - n] = this.A[nArray[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public void set(int n, int n2, double d) {
        this.A[n][n2] = d;
    }

    public void setMatrix(int n, int n2, int n3, int n4, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    this.A[i][j] = matrix.get(i - n, j - n3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    this.A[nArray[i]][nArray2[j]] = matrix.get(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n, int n2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    this.A[nArray[i]][j] = matrix.get(i, j - n);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int n, int n2, int[] nArray, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    this.A[i][nArray[j]] = matrix.get(i - n, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[j][i] = this.A[i][j];
            }
        }
        return matrix;
    }

    public double norm1() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.m; ++j) {
                d2 += Math.abs(this.A[j][i]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double normInf() {
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.n; ++j) {
                d2 += Math.abs(this.A[i][j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double normF() {
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                d = Maths.hypot(d, this.A[i][j]);
            }
        }
        return d;
    }

    public Matrix uminus() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = -this.A[i][j];
            }
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] + matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix plusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] + matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix minus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] - matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix minusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] - matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix arrayTimes(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] * matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix arrayTimesEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] * matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix arrayRightDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] / matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix arrayRightDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] / matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix arrayLeftDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = matrix.A[i][j] / this.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix arrayLeftDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = matrix.A[i][j] / this.A[i][j];
            }
        }
        return this;
    }

    public Matrix times(double d) {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = d * this.A[i][j];
            }
        }
        return matrix;
    }

    public Matrix timesEquals(double d) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = d * this.A[i][j];
            }
        }
        return this;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this.m, matrix.n);
        double[][] dArray = matrix2.getArray();
        double[] dArray2 = new double[this.n];
        for (int i = 0; i < matrix.n; ++i) {
            int n;
            for (n = 0; n < this.n; ++n) {
                dArray2[n] = matrix.A[n][i];
            }
            for (n = 0; n < this.m; ++n) {
                double[] dArray3 = this.A[n];
                double d = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    d += dArray3[j] * dArray2[j];
                }
                dArray[n][i] = d;
            }
        }
        return matrix2;
    }

    public double trace() {
        double d = 0.0;
        for (int i = 0; i < Math.min(this.m, this.n); ++i) {
            d += this.A[i][i];
        }
        return d;
    }

    public static Matrix random(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = Math.random();
            }
        }
        return matrix;
    }

    public static Matrix identity(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return matrix;
    }

    public void print(int n, int n2) {
        this.print(new PrintWriter(System.out, true), n, n2);
    }

    public void print(PrintWriter printWriter, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n + 2);
    }

    public void print(NumberFormat numberFormat, int n) {
        this.print(new PrintWriter(System.out, true), numberFormat, n);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n) {
        printWriter.println();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                String string = numberFormat.format(this.A[i][j]);
                int n2 = Math.max(1, n - string.length());
                for (int k = 0; k < n2; ++k) {
                    printWriter.print(' ');
                }
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public static Matrix read(BufferedReader bufferedReader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        Vector<Object> vector = new Vector<Object>();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vector.addElement(Double.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = vector.size();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = (Double)vector.elementAt(n);
        }
        vector.removeAllElements();
        vector.addElement(dArray);
        while (streamTokenizer.nextToken() == -3) {
            dArray = new double[n2];
            vector.addElement(dArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + vector.size() + " is too long.");
                }
                dArray[n++] = Double.valueOf(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + vector.size() + " is too short.");
        }
        n = vector.size();
        double[][] dArrayArray = new double[n][];
        vector.copyInto((Object[])dArrayArray);
        return new Matrix(dArrayArray);
    }

    private void checkMatrixDimensions(Matrix matrix) {
        if (matrix.m != this.m || matrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

