/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;

public class Ranker
extends ASSearch
implements RankedOutputSearch,
StartSetHandler,
OptionHandler {
    static final long serialVersionUID = -9086714848510751934L;
    private int[] m_starting;
    private Range m_startRange;
    private int[] m_attributeList;
    private double[] m_attributeMerit;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private double m_threshold;
    private int m_numToSelect = -1;
    private int m_calculatedNumToSelect = -1;

    public String globalInfo() {
        return "Ranker : \n\nRanks attributes by their individual evaluations. Use in conjunction with attribute evaluators (ReliefF, GainRatio, Entropy etc).\n";
    }

    public Ranker() {
        this.resetOptions();
    }

    public String numToSelectTipText() {
        return "Specify the number of attributes to retain. The default value (-1) indicates that all attributes are to be retained. Use either this option or a threshold to reduce the attribute set.";
    }

    public void setNumToSelect(int n) {
        this.m_numToSelect = n;
    }

    public int getNumToSelect() {
        return this.m_numToSelect;
    }

    public int getCalculatedNumToSelect() {
        if (this.m_numToSelect >= 0) {
            this.m_calculatedNumToSelect = this.m_numToSelect;
        }
        return this.m_calculatedNumToSelect;
    }

    public String thresholdTipText() {
        return "Set threshold by which attributes can be discarded. Default value results in no attributes being discarded. Use either this option or numToSelect to reduce the attribute set.";
    }

    public void setThreshold(double d) {
        this.m_threshold = d;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public String generateRankingTipText() {
        return "A constant option. Ranker is only capable of generating  attribute rankings.";
    }

    public void setGenerateRanking(boolean bl) {
    }

    public boolean getGenerateRanking() {
        return true;
    }

    public String startSetTipText() {
        return "Specify a set of attributes to ignore.  When generating the ranking, Ranker will not evaluate the attributes  in this list. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.\n\tAny starting attributes specified are\n\tignored during the ranking.", "P", 1, "-P <start set>"));
        vector.addElement(new Option("\tSpecify a theshold by which attributes\n\tmay be discarded from the ranking.", "T", 1, "-T <threshold>"));
        vector.addElement(new Option("\tSpecify number of attributes to select", "N", 1, "-N <num to select>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        if ((string = Utils.getOption('T', stringArray)).length() != 0) {
            Double d = Double.valueOf(string);
            this.setThreshold(d);
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            this.setNumToSelect(Integer.parseInt(string));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.getThreshold();
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNumToSelect();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    private String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        if (!(aSEvaluation instanceof AttributeEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a" + "Attribute evaluator!");
        }
        this.m_numAttribs = instances.numAttributes();
        if (aSEvaluation instanceof UnsupervisedAttributeEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_classIndex = instances.classIndex();
            this.m_hasClass = this.m_classIndex >= 0;
        }
        if (aSEvaluation instanceof AttributeTransformer) {
            instances = ((AttributeTransformer)((Object)aSEvaluation)).transformedHeader();
            if (this.m_classIndex >= 0 && instances.classIndex() >= 0) {
                this.m_classIndex = instances.classIndex();
                this.m_hasClass = true;
            }
        }
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        int n2 = 0;
        if (this.m_starting != null) {
            n2 = this.m_starting.length;
        }
        if (this.m_starting != null && this.m_hasClass) {
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                if (this.m_starting[n] != this.m_classIndex) continue;
                bl = true;
                break;
            }
            if (!bl) {
                ++n2;
            }
        } else if (this.m_hasClass) {
            ++n2;
        }
        this.m_attributeList = new int[this.m_numAttribs - n2];
        this.m_attributeMerit = new double[this.m_numAttribs - n2];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (this.inStarting(n)) continue;
            this.m_attributeList[n3++] = n;
        }
        AttributeEvaluator attributeEvaluator = (AttributeEvaluator)aSEvaluation;
        for (n = 0; n < this.m_attributeList.length; ++n) {
            this.m_attributeMerit[n] = attributeEvaluator.evaluateAttribute(this.m_attributeList[n]);
        }
        double[][] dArray = this.rankedAttributes();
        int[] nArray = new int[this.m_attributeList.length];
        for (n = 0; n < this.m_attributeList.length; ++n) {
            nArray[n] = (int)dArray[n][0];
        }
        return nArray;
    }

    public double[][] rankedAttributes() throws Exception {
        int n;
        if (this.m_attributeList == null || this.m_attributeMerit == null) {
            throw new Exception("Search must be performed before a ranked attribute list can be obtained");
        }
        int[] nArray = Utils.sort(this.m_attributeMerit);
        double[][] dArray = new double[nArray.length][2];
        int n2 = 0;
        for (n = nArray.length - 1; n >= 0; --n) {
            dArray[n2++][0] = nArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            int n3 = (int)dArray[n][0];
            dArray[n][0] = this.m_attributeList[n3];
            dArray[n][1] = this.m_attributeMerit[n3];
        }
        if (this.m_numToSelect > dArray.length) {
            throw new Exception("More attributes requested than exist in the data");
        }
        if (this.m_numToSelect <= 0) {
            if (this.m_threshold == -1.7976931348623157E308) {
                this.m_calculatedNumToSelect = dArray.length;
            } else {
                this.determineNumToSelectFromThreshold(dArray);
            }
        }
        return dArray;
    }

    private void determineNumToSelectFromThreshold(double[][] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i][1] > this.m_threshold)) continue;
            ++n;
        }
        this.m_calculatedNumToSelect = n;
    }

    private void determineThreshFromNumToSelect(double[][] dArray) throws Exception {
        if (this.m_numToSelect > dArray.length) {
            throw new Exception("More attributes requested than exist in the data");
        }
        if (this.m_numToSelect == dArray.length) {
            return;
        }
        this.m_threshold = (dArray[this.m_numToSelect - 1][1] + dArray[this.m_numToSelect][1]) / 2.0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tAttribute ranking.\n");
        if (this.m_starting != null) {
            stringBuffer.append("\tIgnored attributes: ");
            stringBuffer.append(this.startSetToString());
            stringBuffer.append("\n");
        }
        if (this.m_threshold != -1.7976931348623157E308) {
            stringBuffer.append("\tThreshold for discarding attributes: " + Utils.doubleToString(this.m_threshold, 8, 4) + "\n");
        }
        return stringBuffer.toString();
    }

    protected void resetOptions() {
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_attributeList = null;
        this.m_attributeMerit = null;
        this.m_threshold = -1.7976931348623157E308;
    }

    private boolean inStarting(int n) {
        if (this.m_hasClass && n == this.m_classIndex) {
            return true;
        }
        if (this.m_starting == null) {
            return false;
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            if (this.m_starting[i] != n) continue;
            return true;
        }
        return false;
    }
}

