/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public class CSVSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter,
FileSourcedConverter {
    static final long serialVersionUID = 476636654410701807L;

    public CSVSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in csv format";
    }

    public String getFileDescription() {
        return "CSV file: comma separated files";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".csv");
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.STRING_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void writeIncremental(Instance instance) throws IOException {
        int n = this.getWriteMode();
        Instances instances = this.getInstances();
        PrintWriter printWriter = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            printWriter = new PrintWriter(this.getWriter());
        }
        if (n == 1) {
            if (instances == null) {
                this.setWriteMode(2);
                if (instance != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            n = this.getWriteMode();
        }
        if (n == 2) {
            if (printWriter != null) {
                printWriter.close();
            }
            this.cancel();
        }
        if (n == 3) {
            this.setWriteMode(0);
            if (this.retrieveFile() == null || printWriter == null) {
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    System.out.print(instances.attribute(i).name());
                    if (i < instances.numAttributes() - 1) {
                        System.out.print(",");
                        continue;
                    }
                    System.out.println();
                }
            } else {
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    printWriter.print(instances.attribute(i).name());
                    if (i < instances.numAttributes() - 1) {
                        printWriter.print(",");
                        continue;
                    }
                    printWriter.println();
                }
                printWriter.flush();
            }
            n = this.getWriteMode();
        }
        if (n == 0) {
            if (instances == null) {
                throw new IOException("No instances information available.");
            }
            if (instance != null) {
                if (this.retrieveFile() == null || printWriter == null) {
                    System.out.println(instance);
                } else {
                    printWriter.println(this.instanceToString(instance));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        printWriter.flush();
                    }
                }
            } else {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                printWriter = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        int n;
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            int n2;
            for (n2 = 0; n2 < this.getInstances().numAttributes(); ++n2) {
                System.out.print(this.getInstances().attribute(n2).name());
                if (n2 < this.getInstances().numAttributes() - 1) {
                    System.out.print(",");
                    continue;
                }
                System.out.println();
            }
            for (n2 = 0; n2 < this.getInstances().numInstances(); ++n2) {
                System.out.println(this.getInstances().instance(n2));
            }
            this.setWriteMode(1);
            return;
        }
        PrintWriter printWriter = new PrintWriter(this.getWriter());
        for (n = 0; n < this.getInstances().numAttributes(); ++n) {
            printWriter.print(this.getInstances().attribute(n).name());
            if (n < this.getInstances().numAttributes() - 1) {
                printWriter.print(",");
                continue;
            }
            printWriter.println();
        }
        for (n = 0; n < this.getInstances().numInstances(); ++n) {
            printWriter.println(this.instanceToString(this.getInstances().instance(n)));
        }
        printWriter.flush();
        printWriter.close();
        this.setWriteMode(1);
        printWriter = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    protected String instanceToString(Instance instance) {
        Instance instance2;
        if (instance instanceof SparseInstance) {
            instance2 = new Instance(instance.weight(), instance.toDoubleArray());
            instance2.setDataset(instance.dataset());
        } else {
            instance2 = instance;
        }
        return instance2.toString();
    }

    public static void main(String[] stringArray) {
        CSVSaver.runFileSaver(new CSVSaver(), stringArray);
    }
}

