/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;
import weka.estimators.NormalEstimator;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class NaiveBayes
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 5995231201785697655L;
    protected Estimator[][] m_Distributions;
    protected Estimator m_ClassDistribution;
    protected boolean m_UseKernelEstimator = false;
    protected boolean m_UseDiscretization = false;
    protected int m_NumClasses;
    protected Instances m_Instances;
    protected static final double DEFAULT_NUM_PRECISION = 0.01;
    protected Discretize m_Disc = null;
    protected boolean m_displayModelInOldFormat = false;

    public String globalInfo() {
        return "Class for a Naive Bayes classifier using estimator classes. Numeric estimator precision values are chosen based on analysis of the  training data. For this reason, the classifier is not an UpdateableClassifier (which in typical usage are initialized with zero training instances) -- if you need the UpdateableClassifier functionality, use the NaiveBayesUpdateable classifier. The NaiveBayesUpdateable classifier will  use a default precision of 0.1 for numeric attributes when buildClassifier is called with zero training instances.\n\nFor more information on Naive Bayes classifiers, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "George H. John and Pat Langley");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Estimating Continuous Distributions in Bayesian Classifiers");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Eleventh Conference on Uncertainty in Artificial Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1995");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "338-345");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "San Mateo");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_NumClasses = instances.numClasses();
        this.m_Instances = new Instances(instances);
        if (this.m_UseDiscretization) {
            this.m_Disc = new Discretize();
            this.m_Disc.setInputFormat(this.m_Instances);
            this.m_Instances = Filter.useFilter(this.m_Instances, this.m_Disc);
        } else {
            this.m_Disc = null;
        }
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes() - 1][this.m_Instances.numClasses()];
        this.m_ClassDistribution = new DiscreteEstimator(this.m_Instances.numClasses(), true);
        int n = 0;
        Enumeration enumeration = this.m_Instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            object = (Attribute)enumeration.nextElement();
            double d = 0.01;
            if (((Attribute)object).type() == 0) {
                this.m_Instances.sort((Attribute)object);
                if (this.m_Instances.numInstances() > 0 && !this.m_Instances.instance(0).isMissing((Attribute)object)) {
                    Instance instance;
                    double d2 = this.m_Instances.instance(0).value((Attribute)object);
                    double d3 = 0.0;
                    int n2 = 0;
                    for (int i = 1; i < this.m_Instances.numInstances() && !(instance = this.m_Instances.instance(i)).isMissing((Attribute)object); ++i) {
                        double d4 = instance.value((Attribute)object);
                        if (d4 == d2) continue;
                        d3 += d4 - d2;
                        d2 = d4;
                        ++n2;
                    }
                    if (n2 > 0) {
                        d = d3 / (double)n2;
                    }
                }
            }
            block6: for (int i = 0; i < this.m_Instances.numClasses(); ++i) {
                switch (((Attribute)object).type()) {
                    case 0: {
                        if (this.m_UseKernelEstimator) {
                            this.m_Distributions[n][i] = new KernelEstimator(d);
                            continue block6;
                        }
                        this.m_Distributions[n][i] = new NormalEstimator(d);
                        continue block6;
                    }
                    case 1: {
                        this.m_Distributions[n][i] = new DiscreteEstimator(((Attribute)object).numValues(), true);
                        continue block6;
                    }
                    default: {
                        throw new Exception("Attribute type unknown to NaiveBayes");
                    }
                }
            }
            ++n;
        }
        object = this.m_Instances.enumerateInstances();
        while (object.hasMoreElements()) {
            Instance instance = (Instance)object.nextElement();
            this.updateClassifier(instance);
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            Enumeration enumeration = this.m_Instances.enumerateAttributes();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (!instance.isMissing(attribute)) {
                    this.m_Distributions[n][(int)instance.classValue()].addValue(instance.value(attribute), instance.weight());
                }
                ++n;
            }
            this.m_ClassDistribution.addValue(instance.classValue(), instance.weight());
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_UseDiscretization) {
            this.m_Disc.input(instance);
            instance = this.m_Disc.output();
        }
        double[] dArray = new double[this.m_NumClasses];
        for (int i = 0; i < this.m_NumClasses; ++i) {
            dArray[i] = this.m_ClassDistribution.getProbability(i);
        }
        Enumeration enumeration = instance.enumerateAttributes();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!instance.isMissing(attribute)) {
                int n2;
                double d = 0.0;
                for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
                    double d2 = Math.max(1.0E-75, Math.pow(this.m_Distributions[n][n2].getProbability(instance.value(attribute)), this.m_Instances.attribute(n).weight()));
                    int n3 = n2;
                    dArray[n3] = dArray[n3] * d2;
                    if (dArray[n2] > d) {
                        d = dArray[n2];
                    }
                    if (!Double.isNaN(dArray[n2])) continue;
                    throw new Exception("NaN returned from estimator for attribute " + attribute.name() + ":\n" + this.m_Distributions[n][n2].toString());
                }
                if (d > 0.0 && d < 1.0E-75) {
                    n2 = 0;
                    while (n2 < this.m_NumClasses) {
                        int n4 = n2++;
                        dArray[n4] = dArray[n4] * 1.0E75;
                    }
                }
            }
            ++n;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tUse kernel density estimator rather than normal\n\tdistribution for numeric attributes", "K", 0, "-K"));
        vector.addElement(new Option("\tUse supervised discretization to process numeric attributes\n", "D", 0, "-D"));
        vector.addElement(new Option("\tDisplay model in old format (good when there are many classes)\n", "O", 0, "-O"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        boolean bl = Utils.getFlag('K', stringArray);
        boolean bl2 = Utils.getFlag('D', stringArray);
        if (bl && bl2) {
            throw new IllegalArgumentException("Can't use both kernel density estimation and discretization!");
        }
        this.setUseSupervisedDiscretization(bl2);
        this.setUseKernelEstimator(bl);
        this.setDisplayModelInOldFormat(Utils.getFlag('O', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (this.m_UseKernelEstimator) {
            stringArray[n++] = "-K";
        }
        if (this.m_UseDiscretization) {
            stringArray[n++] = "-D";
        }
        if (this.m_displayModelInOldFormat) {
            stringArray[n++] = "-O";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        if (this.m_displayModelInOldFormat) {
            return this.toStringOriginal();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Naive Bayes Classifier");
        if (this.m_Instances == null) {
            stringBuffer.append(": No model built yet.");
        } else {
            Object object;
            String string;
            int n;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            for (n = 0; n < this.m_Instances.numClasses(); ++n) {
                if (this.m_Instances.classAttribute().value(n).length() <= n2) continue;
                n2 = this.m_Instances.classAttribute().value(n).length();
            }
            for (n = 0; n < this.m_Instances.numAttributes(); ++n) {
                if (n == this.m_Instances.classIndex()) continue;
                Attribute attribute = this.m_Instances.attribute(n);
                if (attribute.name().length() > n3) {
                    n3 = this.m_Instances.attribute(n).name().length();
                }
                if (!attribute.isNominal()) continue;
                for (int i = 0; i < attribute.numValues(); ++i) {
                    String string2 = attribute.value(i) + "  ";
                    if (string2.length() <= n3) continue;
                    n3 = string2.length();
                }
            }
            for (n = 0; n < this.m_Distributions.length; ++n) {
                for (int i = 0; i < this.m_Instances.numClasses(); ++i) {
                    int n4;
                    Estimator estimator;
                    if (this.m_Distributions[n][0] instanceof NormalEstimator) {
                        double d;
                        double d2;
                        estimator = (NormalEstimator)this.m_Distributions[n][i];
                        double d3 = Math.log(Math.abs(((NormalEstimator)estimator).getMean())) / Math.log(10.0);
                        double d4 = d2 = d3 > (d = Math.log(Math.abs(((NormalEstimator)estimator).getPrecision())) / Math.log(10.0)) ? d3 : d;
                        if (d2 < 0.0) {
                            d2 = 1.0;
                        }
                        if ((int)(d2 += 6.0) <= n2) continue;
                        n2 = (int)d2;
                        continue;
                    }
                    if (this.m_Distributions[n][0] instanceof KernelEstimator) {
                        bl = true;
                        estimator = (KernelEstimator)this.m_Distributions[n][i];
                        int n5 = ((KernelEstimator)estimator).getNumKernels();
                        string = "K" + n5 + ": mean (weight)";
                        if (n3 < string.length()) {
                            n3 = string.length();
                        }
                        if (((KernelEstimator)estimator).getNumKernels() <= 0) continue;
                        double[] dArray = ((KernelEstimator)estimator).getMeans();
                        double[] dArray2 = ((KernelEstimator)estimator).getWeights();
                        for (int j = 0; j < ((KernelEstimator)estimator).getNumKernels(); ++j) {
                            object = Utils.doubleToString(dArray[j], n2, 4).trim();
                            if (n2 >= ((String)(object = (String)object + " (" + Utils.doubleToString(dArray2[j], n2, 1).trim() + ")")).length()) continue;
                            n2 = ((String)object).length();
                        }
                        continue;
                    }
                    if (!(this.m_Distributions[n][0] instanceof DiscreteEstimator)) continue;
                    estimator = (DiscreteEstimator)this.m_Distributions[n][i];
                    for (n4 = 0; n4 < ((DiscreteEstimator)estimator).getNumSymbols(); ++n4) {
                        string = "" + ((DiscreteEstimator)estimator).getCount(n4);
                        if (string.length() <= n2) continue;
                        n2 = string.length();
                    }
                    n4 = ("" + ((DiscreteEstimator)estimator).getSumOfCounts()).length();
                    if (n4 <= n2) continue;
                    n2 = n4;
                }
            }
            for (n = 0; n < this.m_Instances.numClasses(); ++n) {
                String string3 = this.m_Instances.classAttribute().value(n);
                if (string3.length() <= n2) continue;
                n2 = string3.length();
            }
            for (n = 0; n < this.m_Instances.numClasses(); ++n) {
                String string4 = Utils.doubleToString(((DiscreteEstimator)this.m_ClassDistribution).getProbability(n), n2, 2).trim();
                string4 = "(" + string4 + ")";
                if (string4.length() <= n2) continue;
                n2 = string4.length();
            }
            if (n3 < "Attribute".length()) {
                n3 = "Attribute".length();
            }
            if (n3 < "  weight sum".length()) {
                n3 = "  weight sum".length();
            }
            if (bl && n3 < "  [precision]".length()) {
                n3 = "  [precision]".length();
            }
            stringBuffer.append("\n\n");
            stringBuffer.append(this.pad("Class", " ", (n3 += 2) + n2 + 1 - "Class".length(), true));
            stringBuffer.append("\n");
            stringBuffer.append(this.pad("Attribute", " ", n3 - "Attribute".length(), false));
            for (n = 0; n < this.m_Instances.numClasses(); ++n) {
                String string5 = this.m_Instances.classAttribute().value(n);
                stringBuffer.append(this.pad(string5, " ", n2 + 1 - string5.length(), true));
            }
            stringBuffer.append("\n");
            stringBuffer.append(this.pad("", " ", n3, true));
            for (n = 0; n < this.m_Instances.numClasses(); ++n) {
                String string6 = Utils.doubleToString(((DiscreteEstimator)this.m_ClassDistribution).getProbability(n), n2, 2).trim();
                string6 = "(" + string6 + ")";
                stringBuffer.append(this.pad(string6, " ", n2 + 1 - string6.length(), true));
            }
            stringBuffer.append("\n");
            stringBuffer.append(this.pad("", "=", n3 + n2 * this.m_Instances.numClasses() + this.m_Instances.numClasses() + 1, true));
            stringBuffer.append("\n");
            n = 0;
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                Object object2;
                if (i == this.m_Instances.classIndex()) continue;
                String string7 = this.m_Instances.attribute(i).name();
                stringBuffer.append(string7 + "\n");
                if (this.m_Distributions[n][0] instanceof NormalEstimator) {
                    object2 = "  mean";
                    stringBuffer.append(this.pad((String)object2, " ", n3 + 1 - ((String)object2).length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        NormalEstimator normalEstimator = (NormalEstimator)this.m_Distributions[n][j];
                        String string8 = Utils.doubleToString(normalEstimator.getMean(), n2, 4).trim();
                        stringBuffer.append(this.pad(string8, " ", n2 + 1 - string8.length(), true));
                    }
                    stringBuffer.append("\n");
                    string = "  std. dev.";
                    stringBuffer.append(this.pad(string, " ", n3 + 1 - string.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        NormalEstimator normalEstimator = (NormalEstimator)this.m_Distributions[n][j];
                        String string9 = Utils.doubleToString(normalEstimator.getStdDev(), n2, 4).trim();
                        stringBuffer.append(this.pad(string9, " ", n2 + 1 - string9.length(), true));
                    }
                    stringBuffer.append("\n");
                    String string10 = "  weight sum";
                    stringBuffer.append(this.pad(string10, " ", n3 + 1 - string10.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        NormalEstimator normalEstimator = (NormalEstimator)this.m_Distributions[n][j];
                        object = Utils.doubleToString(normalEstimator.getSumOfWeights(), n2, 4).trim();
                        stringBuffer.append(this.pad((String)object, " ", n2 + 1 - ((String)object).length(), true));
                    }
                    stringBuffer.append("\n");
                    String string11 = "  precision";
                    stringBuffer.append(this.pad(string11, " ", n3 + 1 - string11.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        object = (NormalEstimator)this.m_Distributions[n][j];
                        String string12 = Utils.doubleToString(((NormalEstimator)object).getPrecision(), n2, 4).trim();
                        stringBuffer.append(this.pad(string12, " ", n2 + 1 - string12.length(), true));
                    }
                    stringBuffer.append("\n\n");
                } else if (this.m_Distributions[n][0] instanceof DiscreteEstimator) {
                    object2 = this.m_Instances.attribute(i);
                    for (int j = 0; j < ((Attribute)object2).numValues(); ++j) {
                        String string13 = "  " + ((Attribute)object2).value(j);
                        stringBuffer.append(this.pad(string13, " ", n3 + 1 - string13.length(), false));
                        for (int k = 0; k < this.m_Instances.numClasses(); ++k) {
                            DiscreteEstimator discreteEstimator = (DiscreteEstimator)this.m_Distributions[n][k];
                            object = "" + discreteEstimator.getCount(j);
                            stringBuffer.append(this.pad((String)object, " ", n2 + 1 - ((String)object).length(), true));
                        }
                        stringBuffer.append("\n");
                    }
                    string = "  [total]";
                    stringBuffer.append(this.pad(string, " ", n3 + 1 - string.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        DiscreteEstimator discreteEstimator = (DiscreteEstimator)this.m_Distributions[n][j];
                        String string14 = "" + discreteEstimator.getSumOfCounts();
                        stringBuffer.append(this.pad(string14, " ", n2 + 1 - string14.length(), true));
                    }
                    stringBuffer.append("\n\n");
                } else if (this.m_Distributions[n][0] instanceof KernelEstimator) {
                    int n6;
                    int n7;
                    object2 = "  [# kernels]";
                    stringBuffer.append(this.pad((String)object2, " ", n3 + 1 - ((String)object2).length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        KernelEstimator kernelEstimator = (KernelEstimator)this.m_Distributions[n][j];
                        String string15 = "" + kernelEstimator.getNumKernels();
                        stringBuffer.append(this.pad(string15, " ", n2 + 1 - string15.length(), true));
                    }
                    stringBuffer.append("\n");
                    string = "  [std. dev]";
                    stringBuffer.append(this.pad(string, " ", n3 + 1 - string.length(), false));
                    for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                        KernelEstimator kernelEstimator = (KernelEstimator)this.m_Distributions[n][j];
                        String string16 = Utils.doubleToString(kernelEstimator.getStdDev(), n2, 4).trim();
                        stringBuffer.append(this.pad(string16, " ", n2 + 1 - string16.length(), true));
                    }
                    stringBuffer.append("\n");
                    String string17 = "  [precision]";
                    stringBuffer.append(this.pad(string17, " ", n3 + 1 - string17.length(), false));
                    for (n7 = 0; n7 < this.m_Instances.numClasses(); ++n7) {
                        KernelEstimator kernelEstimator = (KernelEstimator)this.m_Distributions[n][n7];
                        object = Utils.doubleToString(kernelEstimator.getPrecision(), n2, 4).trim();
                        stringBuffer.append(this.pad((String)object, " ", n2 + 1 - ((String)object).length(), true));
                    }
                    stringBuffer.append("\n");
                    n7 = 0;
                    for (n6 = 0; n6 < this.m_Instances.numClasses(); ++n6) {
                        object = (KernelEstimator)this.m_Distributions[n][n6];
                        if (((KernelEstimator)object).getNumKernels() <= n7) continue;
                        n7 = ((KernelEstimator)object).getNumKernels();
                    }
                    for (n6 = 0; n6 < n7; ++n6) {
                        object = "  K" + (n6 + 1) + ": mean (weight)";
                        stringBuffer.append(this.pad((String)object, " ", n3 + 1 - ((String)object).length(), false));
                        for (int j = 0; j < this.m_Instances.numClasses(); ++j) {
                            KernelEstimator kernelEstimator = (KernelEstimator)this.m_Distributions[n][j];
                            double[] dArray = kernelEstimator.getMeans();
                            double[] dArray3 = kernelEstimator.getWeights();
                            String string18 = "--";
                            if (kernelEstimator.getNumKernels() == 0) {
                                string18 = "0";
                            } else if (n6 < kernelEstimator.getNumKernels()) {
                                string18 = Utils.doubleToString(dArray[n6], n2, 4).trim();
                                string18 = string18 + " (" + Utils.doubleToString(dArray3[n6], n2, 1).trim() + ")";
                            }
                            stringBuffer.append(this.pad(string18, " ", n2 + 1 - string18.length(), true));
                        }
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("\n");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    protected String toStringOriginal() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Naive Bayes Classifier");
        if (this.m_Instances == null) {
            stringBuffer.append(": No model built yet.");
        } else {
            try {
                for (int i = 0; i < this.m_Distributions[0].length; ++i) {
                    stringBuffer.append("\n\nClass " + this.m_Instances.classAttribute().value(i) + ": Prior probability = " + Utils.doubleToString(this.m_ClassDistribution.getProbability(i), 4, 2) + "\n\n");
                    Enumeration enumeration = this.m_Instances.enumerateAttributes();
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        Attribute attribute = (Attribute)enumeration.nextElement();
                        if (attribute.weight() > 0.0) {
                            stringBuffer.append(attribute.name() + ":  " + this.m_Distributions[n][i]);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    private String pad(String string, String string2, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public String useKernelEstimatorTipText() {
        return "Use a kernel estimator for numeric attributes rather than a normal distribution.";
    }

    public boolean getUseKernelEstimator() {
        return this.m_UseKernelEstimator;
    }

    public void setUseKernelEstimator(boolean bl) {
        this.m_UseKernelEstimator = bl;
        if (bl) {
            this.setUseSupervisedDiscretization(false);
        }
    }

    public String useSupervisedDiscretizationTipText() {
        return "Use supervised discretization to convert numeric attributes to nominal ones.";
    }

    public boolean getUseSupervisedDiscretization() {
        return this.m_UseDiscretization;
    }

    public void setUseSupervisedDiscretization(boolean bl) {
        this.m_UseDiscretization = bl;
        if (bl) {
            this.setUseKernelEstimator(false);
        }
    }

    public String displayModelInOldFormatTipText() {
        return "Use old format for model output. The old format is better when there are many class values. The new format is better when there are fewer classes and many attributes.";
    }

    public void setDisplayModelInOldFormat(boolean bl) {
        this.m_displayModelInOldFormat = bl;
    }

    public boolean getDisplayModelInOldFormat() {
        return this.m_displayModelInOldFormat;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.27 $");
    }

    public static void main(String[] stringArray) {
        NaiveBayes.runClassifier(new NaiveBayes(), stringArray);
    }
}

