/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.pmml.DerivedFieldMetaInfo;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.PMMLUtils;
import weka.gui.Logger;

public class MappingInfo
implements Serializable {
    public static final int UNKNOWN_NOMINAL_VALUE = -1;
    private int[] m_fieldsMap = null;
    private int[][] m_nominalValueMaps = null;
    private String m_fieldsMappingText = null;
    private Logger m_log = null;

    public MappingInfo(Instances instances, MiningSchema miningSchema, Logger logger) throws Exception {
        Object object;
        this.m_log = logger;
        Instances instances2 = miningSchema.getMiningSchemaAsInstances();
        this.m_fieldsMap = new int[instances2.numAttributes()];
        this.m_nominalValueMaps = new int[instances2.numAttributes()][];
        for (int i = 0; i < instances2.numAttributes(); ++i) {
            object = instances2.attribute(i).name();
            boolean bl = false;
            for (int j = 0; j < instances.numAttributes(); ++j) {
                Object object2;
                if (!instances.attribute(j).name().equals(object)) continue;
                Attribute attribute = instances2.attribute(i);
                Attribute attribute2 = instances.attribute(j);
                if (attribute.type() != attribute2.type()) {
                    throw new Exception("[MappingInfo] type mismatch for field " + (String)object + ". Mining schema type " + attribute.toString() + ". Incoming type " + attribute2.toString() + ".");
                }
                if (attribute.numValues() != attribute2.numValues()) {
                    object2 = "[MappingInfo] WARNING: incoming nominal attribute " + attribute2.name() + " does not have the same " + "number of values as the corresponding mining " + "schema attribute.";
                    if (this.m_log != null) {
                        this.m_log.logMessage((String)object2);
                    } else {
                        System.err.println((String)object2);
                    }
                }
                if (attribute.isNominal() || attribute.isString()) {
                    object2 = new int[attribute2.numValues()];
                    for (int k = 0; k < attribute2.numValues(); ++k) {
                        String string = attribute2.value(k);
                        int n = attribute.indexOfValue(string);
                        if (n < 0) {
                            String string2 = "[MappingInfo] WARNING: incoming nominal attribute " + attribute2.name() + " has value " + string + " that doesn't occur in the mining schema.";
                            if (this.m_log != null) {
                                this.m_log.logMessage(string2);
                            } else {
                                System.err.println(string2);
                            }
                            object2[k] = -1;
                            continue;
                        }
                        object2[k] = n;
                    }
                    this.m_nominalValueMaps[i] = object2;
                }
                bl = true;
                this.m_fieldsMap[i] = j;
            }
            if (bl) continue;
            throw new Exception("[MappingInfo] Unable to find a match for mining schema attribute " + (String)object + " in the " + "incoming instances!");
        }
        if (instances2.classIndex() >= 0) {
            if (instances.classIndex() < 0) {
                String string = instances2.classAttribute().name();
                object = instances.attribute(string);
                if (object == null) {
                    throw new Exception("[MappingInfo] Can't find match for target field " + string + "in incoming instances!");
                }
                instances.setClass((Attribute)object);
            } else if (!instances2.classAttribute().name().equals(instances.classAttribute().name())) {
                throw new Exception("[MappingInfo] class attribute in mining schema does not match class attribute in incoming instances!");
            }
        }
        this.fieldsMappingString(instances2, instances);
    }

    private void fieldsMappingString(Instances instances, Instances instances2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (instances.attribute(n).name().length() <= n2) continue;
            n2 = instances.attribute(n).name().length();
        }
        n = 13;
        String string = "Mining schema";
        String string2 = "-------------";
        if ((n2 += 12) < n) {
            n2 = n;
        }
        string = PMMLUtils.pad(string, " ", n2, false);
        string2 = PMMLUtils.pad(string2, "-", n2, false);
        string2 = string2 + "\t    ----------------\n";
        string = string + "\t    Incoming fields\n";
        stringBuffer.append(string);
        stringBuffer.append(string2);
        for (int i = 0; i < instances.numAttributes(); ++i) {
            Attribute attribute = instances.attribute(i);
            String string3 = "(" + (attribute.isNumeric() ? "numeric)" : "nominal)") + " " + attribute.name();
            string3 = PMMLUtils.pad(string3, " ", n2, false);
            string3 = string3 + "\t--> ";
            stringBuffer.append(string3);
            Attribute attribute2 = instances2.attribute(this.m_fieldsMap[i]);
            String string4 = "" + (this.m_fieldsMap[i] + 1) + " (" + (attribute2.isNumeric() ? "numeric)" : "nominal)");
            string4 = string4 + " " + attribute2.name();
            stringBuffer.append(string4 + "\n");
        }
        this.m_fieldsMappingText = stringBuffer.toString();
    }

    public double[] instanceToSchema(Instance instance, MiningSchema miningSchema) throws Exception {
        Instances instances = miningSchema.getMiningSchemaAsInstances();
        double[] dArray = new double[miningSchema.getFieldsAsInstances().numAttributes()];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            dArray[i] = instance.value(this.m_fieldsMap[i]);
            if (!instances.attribute(i).isNominal() && !instances.attribute(i).isString() || Instance.isMissingValue(instance.value(this.m_fieldsMap[i]))) continue;
            int[] nArray = this.m_nominalValueMaps[i];
            int n = nArray[(int)instance.value(this.m_fieldsMap[i])];
            String string = instance.attribute(this.m_fieldsMap[i]).value((int)instance.value(this.m_fieldsMap[i]));
            if (n >= 0) {
                dArray[i] = n;
                continue;
            }
            dArray[i] = -1.0;
            String string2 = "[MappingInfo] WARNING: Can't match nominal value " + string;
            if (this.m_log != null) {
                this.m_log.logMessage(string2);
                continue;
            }
            System.err.println(string2);
        }
        miningSchema.applyMissingAndOutlierTreatments(dArray);
        ArrayList<DerivedFieldMetaInfo> arrayList = miningSchema.getDerivedFields();
        for (int i = 0; i < arrayList.size(); ++i) {
            double d;
            DerivedFieldMetaInfo derivedFieldMetaInfo = arrayList.get(i);
            dArray[i + instances.numAttributes()] = d = derivedFieldMetaInfo.getDerivedValue(dArray);
        }
        return dArray;
    }

    public String getFieldsMappingString() {
        if (this.m_fieldsMappingText == null) {
            return "No fields mapping constructed!";
        }
        return this.m_fieldsMappingText;
    }
}

