/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;
import weka.estimators.NormalEstimator;

public class CheckEstimator
implements OptionHandler,
RevisionHandler {
    protected Estimator m_Estimator = new NormalEstimator(1.0E-6);
    protected String[] m_EstimatorOptions;
    protected String m_AnalysisResults;
    protected boolean m_Debug = false;
    protected boolean m_Silent = false;
    protected int m_NumInstances = 100;
    protected PostProcessor m_PostProcessor = null;
    protected boolean m_ClasspathProblems = false;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        vector.addElement(new Option("\tSilent mode - prints nothing to stdout.", "S", 0, "-S"));
        vector.addElement(new Option("\tThe number of instances in the datasets (default 100).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tFull name of the estimator analysed.\n\teg: weka.estimators.NormalEstimator", "W", 1, "-W"));
        if (this.m_Estimator != null && this.m_Estimator instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to estimator " + this.m_Estimator.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Estimator.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setSilent(Utils.getFlag('S', stringArray));
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumInstances(Integer.parseInt(string));
        } else {
            this.setNumInstances(100);
        }
        string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A estimator must be specified with the -W option.");
        }
        this.setEstimator(Estimator.forName(string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getSilent()) {
            vector.add("-S");
        }
        vector.add("-N");
        vector.add("" + this.getNumInstances());
        if (this.getEstimator() != null) {
            vector.add("-W");
            vector.add(this.getEstimator().getClass().getName());
        }
        if ((stringArray = this.m_Estimator != null && this.m_Estimator instanceof OptionHandler ? this.m_Estimator.getOptions() : new String[]{}).length > 0) {
            vector.add("--");
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.m_PostProcessor = postProcessor;
    }

    public PostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public boolean hasClasspathProblems() {
        return this.m_ClasspathProblems;
    }

    public void doTests() {
        if (this.getEstimator() == null) {
            this.println("\n=== No estimator set ===");
            return;
        }
        this.println("\n=== Check on Estimator: " + this.getEstimator().getClass().getName() + " ===\n");
        this.m_ClasspathProblems = false;
        this.canTakeOptions();
        EstTypes estTypes = new EstTypes();
        estTypes.incremental = this.incrementalEstimator()[0];
        estTypes.weighted = this.weightedInstancesHandler()[0];
        estTypes.supervised = this.supervisedEstimator()[0];
        int n = 1;
        AttrTypes attrTypes = this.testsPerClassType(n, estTypes);
        this.canSplitUpClass(attrTypes, n);
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
        if (this.getDebug()) {
            this.setSilent(false);
        }
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSilent(boolean bl) {
        this.m_Silent = bl;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    public void setNumInstances(int n) {
        this.m_NumInstances = n;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setEstimator(Estimator estimator) {
        this.m_Estimator = estimator;
    }

    public Estimator getEstimator() {
        return this.m_Estimator;
    }

    protected void print(Object object) {
        if (!this.getSilent()) {
            System.out.print(object);
        }
    }

    protected void println(Object object) {
        this.print(object + "\n");
    }

    protected void println() {
        this.print("\n");
    }

    protected AttrTypes testsPerClassType(int n, EstTypes estTypes) {
        AttrTypes attrTypes = new AttrTypes();
        AttrTypes attrTypes2 = new AttrTypes(1);
        attrTypes.nominal = this.canEstimate(attrTypes2, estTypes.supervised, n)[0];
        attrTypes2 = new AttrTypes(0);
        attrTypes.numeric = this.canEstimate(attrTypes2, estTypes.supervised, n)[0];
        attrTypes.string = false;
        attrTypes.date = false;
        attrTypes.relational = false;
        if (attrTypes.oneIsSet()) {
            Vector vector = attrTypes.getVectorOfAttrTypes();
            for (int i = 0; i < vector.size(); ++i) {
                boolean bl;
                int n2;
                AttrTypes attrTypes3 = new AttrTypes((Integer)vector.elementAt(i));
                if (estTypes.weighted) {
                    this.instanceWeights(attrTypes3, n);
                }
                if (n == 1) {
                    n2 = 4;
                    this.canHandleNClasses(attrTypes3, n2);
                }
                n2 = 4;
                this.canHandleClassAsNthAttribute(attrTypes3, n2, 0, n, 1);
                this.canHandleZeroTraining(attrTypes3, n);
                boolean bl2 = this.canHandleMissing(attrTypes3, n, true, false, 20)[0];
                if (bl2) {
                    this.canHandleMissing(attrTypes3, n, true, false, 100);
                }
                if (bl = this.canHandleMissing(attrTypes3, n, false, true, 20)[0]) {
                    this.canHandleMissing(attrTypes3, n, false, true, 100);
                }
                this.correctBuildInitialisation(attrTypes3, n);
                this.datasetIntegrity(attrTypes3, n, bl2, bl);
                if (!estTypes.incremental) continue;
                this.incrementingEquality(attrTypes3, n);
            }
        }
        return attrTypes;
    }

    protected boolean[] canTakeOptions() {
        boolean[] blArray = new boolean[2];
        this.print("options...");
        if (this.m_Estimator instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enumeration = this.m_Estimator.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] incrementalEstimator() {
        boolean[] blArray = new boolean[2];
        this.print("incremental estimator...");
        if (this.m_Estimator instanceof IncrementalEstimator) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] blArray = new boolean[2];
        this.print("weighted instances estimator...");
        if (this.m_Estimator instanceof WeightedInstancesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] supervisedEstimator() {
        boolean[] blArray = new boolean[2];
        blArray[0] = false;
        return blArray;
    }

    protected boolean[] canEstimate(AttrTypes attrTypes, boolean bl, int n) {
        this.print("basic estimation");
        this.printAttributeSummary(attrTypes, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("nominal");
        fastVector.addElement("numeric");
        fastVector.addElement("string");
        fastVector.addElement("date");
        fastVector.addElement("relational");
        fastVector.addElement("not in classpath");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 2;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 1;
        int n7 = 0;
        return this.runBasicTest(attrTypes, n6, n7, n, n5, bl2, bl3, n2, n3, n4, fastVector);
    }

    protected void canSplitUpClass(AttrTypes attrTypes, int n) {
        if (attrTypes.nominal) {
            this.canSplitUpClass(1, n);
        }
        if (attrTypes.numeric) {
            this.canSplitUpClass(0, n);
        }
    }

    protected boolean[] canSplitUpClass(int n, int n2) {
        boolean[] blArray;
        block11: {
            Vector vector;
            blArray = new boolean[2];
            FastVector fastVector = new FastVector();
            fastVector.addElement("not in classpath");
            this.print("split per class type ");
            this.printAttributeSummary(n, 1);
            this.print("...");
            int n3 = this.getNumInstances();
            int n4 = this.getNumInstances();
            int n5 = 2;
            boolean bl = false;
            boolean bl2 = false;
            int n6 = 3;
            int n7 = 0;
            int n8 = 1;
            Instances instances = null;
            Estimator estimator = null;
            boolean bl3 = false;
            try {
                AttrTypes attrTypes = new AttrTypes(n);
                instances = this.makeTestDataset(42, n3, n6, attrTypes, n5, n2, n8);
                vector = this.makeTestValueList(24, n4, instances, n7, n);
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                estimator.addValues(instances, n7, n2, n8);
                bl3 = true;
                this.testWithTestValues(estimator, vector);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                int n9;
                boolean bl4 = false;
                String string = exception.getMessage() == null ? "" : exception.getMessage().toLowerCase();
                if (string.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                for (n9 = 0; n9 < fastVector.size(); ++n9) {
                    if (string.indexOf((String)fastVector.elementAt(n9)) < 0) continue;
                    bl4 = true;
                }
                this.println("no" + (bl4 ? " (OK error message)" : ""));
                blArray[1] = bl4;
                if (!this.m_Debug) break block11;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl3) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                if (bl4) break block11;
                if (fastVector.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (n9 = 0; n9 < fastVector.size(); ++n9) {
                        if (n9 != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)fastVector.elementAt(n9) + '\"');
                    }
                }
                this.println("here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + vector.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] canHandleNClasses(AttrTypes attrTypes, int n) {
        this.print("more than two class problems");
        this.printAttributeSummary(attrTypes, 1);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("number");
        fastVector.addElement("class");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 1;
        int n6 = 0;
        return this.runBasicTest(attrTypes, n5, n6, 1, n4, bl, bl2, n2, n3, n, fastVector);
    }

    protected boolean[] canHandleClassAsNthAttribute(AttrTypes attrTypes, int n, int n2, int n3, int n4) {
        if (n4 == -1) {
            this.print("class attribute as last attribute");
        } else {
            this.print("class attribute as " + (n4 + 1) + ". attribute");
        }
        this.printAttributeSummary(attrTypes, n3);
        this.print("...");
        FastVector fastVector = new FastVector();
        int n5 = this.getNumInstances();
        int n6 = this.getNumInstances();
        int n7 = 2;
        int n8 = 0;
        boolean bl = false;
        boolean bl2 = false;
        return this.runBasicTest(attrTypes, n, n2, n3, n4, n8, bl, bl2, n5, n6, n7, fastVector);
    }

    protected boolean[] canHandleZeroTraining(AttrTypes attrTypes, int n) {
        this.print("handle zero training instances");
        this.printAttributeSummary(attrTypes, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("train");
        fastVector.addElement("value");
        int n2 = 0;
        int n3 = this.getNumInstances();
        int n4 = 2;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 1;
        int n7 = 0;
        return this.runBasicTest(attrTypes, n6, n7, n, n5, bl, bl2, n2, n3, n4, fastVector);
    }

    protected boolean[] correctBuildInitialisation(AttrTypes attrTypes, int n) {
        boolean[] blArray;
        block17: {
            blArray = new boolean[2];
            this.print("correct initialisation during buildEstimator");
            this.printAttributeSummary(attrTypes, n);
            this.print("...");
            int n2 = this.getNumInstances();
            int n3 = this.getNumInstances();
            int n4 = 2;
            int n5 = 0;
            boolean bl = false;
            boolean bl2 = false;
            Instances instances = null;
            Instances instances2 = null;
            Instances instances3 = null;
            Instances instances4 = null;
            Estimator estimator = null;
            Estimator estimator2 = null;
            boolean bl3 = false;
            int n6 = 0;
            int n7 = 1;
            int n8 = 2;
            try {
                instances = this.makeTestDataset(42, n2, 2, attrTypes, n4, n);
                instances3 = this.makeTestDataset(84, n2, 3, attrTypes, n4, n);
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl, bl2, n7);
                    this.addMissing(instances3, n5, bl, bl2, n8);
                }
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                n6 = 0;
                estimator.addValues(instances, n7);
                bl3 = true;
                estimator2 = Estimator.makeCopies(this.getEstimator(), 1)[0];
                n6 = 1;
                bl3 = false;
                estimator.addValues(instances3, n8);
                bl3 = true;
                n6 = 2;
                bl3 = false;
                estimator.addValues(instances, n7);
                bl3 = true;
                n6 = 3;
                if (!estimator.equals(estimator2)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n\nFirst build estimator\n" + estimator.toString() + "\n\n");
                        this.println("\nSecond build estimator\n" + estimator.toString() + "\n\n");
                    }
                    throw new Exception("Results differ between buildEstimator calls");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                String string = exception.getMessage().toLowerCase();
                if (string.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    blArray[0] = true;
                    blArray[1] = true;
                } else {
                    this.println("no");
                    blArray[0] = false;
                }
                if (!this.m_Debug) break block17;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl3) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (n6) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test1 Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("=== Train2 Dataset ===\n" + instances3.toString() + "\n");
                this.println("=== Test2 Dataset ===\n" + instances4.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] canHandleMissing(AttrTypes attrTypes, int n, boolean bl, boolean bl2, int n2) {
        if (n2 == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (bl) {
            this.print(" attribute");
            if (bl2) {
                this.print(" and");
            }
        }
        if (bl2) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(attrTypes, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("missing");
        fastVector.addElement("value");
        fastVector.addElement("train");
        int n3 = this.getNumInstances();
        int n4 = this.getNumInstances();
        int n5 = 2;
        int n6 = 1;
        int n7 = 0;
        return this.runBasicTest(attrTypes, n6, n7, n, n2, bl, bl2, n3, n4, n5, fastVector);
    }

    protected boolean[] incrementingEquality(AttrTypes attrTypes, int n) {
        Vector vector;
        this.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(attrTypes, n);
        this.print("...");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 2;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean[] blArray = new boolean[2];
        Instances instances = null;
        Estimator[] estimatorArray = null;
        boolean bl3 = false;
        int n6 = 0;
        try {
            instances = this.makeTestDataset(42, n2, 1, attrTypes, n4, n);
            vector = this.makeTestValueList(24, n3, instances, n6, attrTypes.getSetType());
            if (n5 > 0) {
                this.addMissing(instances, n5, bl, bl2, n6);
            }
            estimatorArray = Estimator.makeCopies(this.getEstimator(), 2);
            estimatorArray[0].addValues(instances, n6);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            for (int i = 0; i < instances.numInstances(); ++i) {
                ((IncrementalEstimator)((Object)estimatorArray[1])).addValue(instances.instance(i).value(n6), 1.0);
            }
            bl3 = true;
            if (!estimatorArray[0].equals(estimatorArray[1])) {
                this.println("no");
                blArray[0] = false;
                if (this.m_Debug) {
                    this.println("\n=== Full Report ===");
                    this.println("Results differ between batch and incrementally built models.\nDepending on the estimator, this may be OK");
                    this.println("Here are the results:\n");
                    this.println("batch built results\n" + estimatorArray[0].toString());
                    this.println("incrementally built results\n" + estimatorArray[1].toString());
                    this.println("Here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                    this.println("=== Test Dataset ===\n" + vector.toString() + "\n\n");
                }
            } else {
                this.println("yes");
                blArray[0] = true;
            }
        }
        catch (Exception exception) {
            blArray[0] = false;
            this.print("Problem during");
            if (bl3) {
                this.print(" testing");
            } else {
                this.print(" training");
            }
            this.println(": " + exception.getMessage() + "\n");
        }
        return blArray;
    }

    protected boolean[] instanceWeights(AttrTypes attrTypes, int n) {
        boolean[] blArray;
        block13: {
            this.print("estimator uses instance weights");
            this.printAttributeSummary(attrTypes, n);
            this.print("...");
            int n2 = 2 * this.getNumInstances();
            int n3 = this.getNumInstances();
            int n4 = 2;
            int n5 = 0;
            boolean bl = false;
            boolean bl2 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Vector vector = null;
            Estimator[] estimatorArray = null;
            Vector vector2 = null;
            Vector vector3 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            int n6 = 0;
            try {
                instances = this.makeTestDataset(42, n2, 1, attrTypes, n4, n);
                vector = this.makeTestValueList(24, n3, instances, n6, attrTypes.getSetType());
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl, bl2, n6);
                }
                estimatorArray = Estimator.makeCopies(this.getEstimator(), 2);
                estimatorArray[0].addValues(instances, n6);
                vector2 = this.testWithTestValues(estimatorArray[0], vector);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    instances.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < instances.numInstances() / 2; ++i) {
                    int n7 = Math.abs(random.nextInt()) % instances.numInstances();
                    int n8 = Math.abs(random.nextInt()) % 10 + 1;
                    instances.instance(n7).setWeight(n8);
                }
                estimatorArray[1].addValues(instances, n6);
                vector3 = this.testWithTestValues(estimatorArray[1], vector);
                bl3 = true;
                if (vector2.equals(vector3)) {
                    bl4 = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block13;
                this.println("\n=== Full Report ===");
                if (bl4) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println(this.probsToString(vector2));
                } else {
                    this.print("Problem during");
                    if (bl3) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + vector.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return blArray;
    }

    protected boolean[] datasetIntegrity(AttrTypes attrTypes, int n, boolean bl, boolean bl2) {
        boolean[] blArray;
        block7: {
            Estimator estimator = null;
            this.print("estimator doesn't alter original datasets");
            this.printAttributeSummary(attrTypes, n);
            this.print("...");
            int n2 = this.getNumInstances();
            int n3 = this.getNumInstances();
            int n4 = 2;
            int n5 = 100;
            blArray = new boolean[2];
            Instances instances = null;
            boolean bl3 = false;
            try {
                instances = this.makeTestDataset(42, n2, 1, attrTypes, n4, n);
                int n6 = 0;
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl, bl2, n6);
                }
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                Instances instances2 = new Instances(instances);
                int n7 = 0;
                estimator.addValues(instances2, n7);
                this.compareDatasets(instances, instances2);
                bl3 = true;
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block7;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl3) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
            }
        }
        return blArray;
    }

    protected boolean[] runBasicTest(AttrTypes attrTypes, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, int n6, int n7, FastVector fastVector) {
        return this.runBasicTest(attrTypes, n, n2, n3, -1, n4, bl, bl2, n5, n6, n7, fastVector);
    }

    protected boolean[] runBasicTest(AttrTypes attrTypes, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, int n7, int n8, FastVector fastVector) {
        boolean[] blArray;
        block14: {
            blArray = new boolean[2];
            Instances instances = null;
            Vector vector = null;
            Estimator estimator = null;
            boolean bl3 = false;
            try {
                instances = this.makeTestDataset(42, n6, n, attrTypes, n8, n3, n4);
                if (n6 > 0) {
                    vector = this.makeTestValueList(24, n7, instances, n2, attrTypes.getSetType());
                } else {
                    double d = -10.0;
                    double d2 = 8.0;
                    vector = this.makeTestValueList(24, n7, d, d2, attrTypes.getSetType());
                }
                if (n5 > 0) {
                    this.addMissing(instances, n5, bl, bl2, n2);
                }
                estimator = Estimator.makeCopies(this.getEstimator(), 1)[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                estimator.addValues(instances, n2);
                bl3 = true;
                this.testWithTestValues(estimator, vector);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                int n9;
                boolean bl4 = false;
                String string = exception.getMessage() == null ? "" : exception.getMessage().toLowerCase();
                if (string.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                for (n9 = 0; n9 < fastVector.size(); ++n9) {
                    if (string.indexOf((String)fastVector.elementAt(n9)) < 0) continue;
                    bl4 = true;
                }
                this.println("no" + (bl4 ? " (OK error message)" : ""));
                blArray[1] = bl4;
                if (!this.m_Debug) break block14;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl3) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                if (bl4) break block14;
                if (fastVector.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (n9 = 0; n9 < fastVector.size(); ++n9) {
                        if (n9 != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)fastVector.elementAt(n9) + '\"');
                    }
                }
                this.println("here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + vector.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected void compareDatasets(Instances instances, Instances instances2) throws Exception {
        if (!instances2.equalHeaders(instances)) {
            throw new Exception("header has been modified");
        }
        if (instances2.numInstances() != instances.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        for (int i = 0; i < instances2.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            Instance instance2 = instances2.instance(i);
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (instance.isMissing(j) ? !instance2.isMissing(j) : instance.value(j) != instance2.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (instance.weight() == instance2.weight()) continue;
                throw new Exception("instance weights have changed");
            }
        }
    }

    protected void addMissing(Instances instances, int n, boolean bl, boolean bl2, int n2) {
        int n3 = instances.classIndex();
        Random random = new Random(1L);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if ((j != n3 || !bl2) && (j != n2 || !bl) || Math.abs(random.nextInt()) % 100 >= n) continue;
                instance.setMissing(j);
            }
        }
    }

    protected Instances makeTestDataset(int n, int n2, int n3, AttrTypes attrTypes, int n4, int n5) throws Exception {
        return this.makeTestDataset(n, n2, n3, attrTypes, n4, n5, -1);
    }

    protected Instances makeTestDataset(int n, int n2, int n3, AttrTypes attrTypes, int n4, int n5, int n6) throws Exception {
        TestInstances testInstances = new TestInstances();
        testInstances.setSeed(n);
        testInstances.setNumInstances(n2);
        testInstances.setNumNominal(attrTypes.nominal ? n3 : 0);
        testInstances.setNumNumeric(attrTypes.numeric ? n3 : 0);
        testInstances.setNumString(attrTypes.string ? n3 : 0);
        testInstances.setNumDate(attrTypes.date ? n3 : 0);
        testInstances.setNumRelational(attrTypes.relational ? n3 : 0);
        testInstances.setNumClasses(n4);
        testInstances.setClassType(n5);
        testInstances.setClassIndex(n6);
        return this.process(testInstances.generate());
    }

    protected Vector makeTestValueList(int n, int n2, Instances instances, int n3, int n4) throws Exception {
        Double d;
        int n5;
        double[] dArray = this.getMinimumMaximum(instances, n3);
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = d3 - d2;
        Vector<Double> vector = new Vector<Double>(n2);
        Random random = new Random(n);
        if (n4 == 1) {
            for (n5 = 0; n5 < n2; ++n5) {
                d = new Double(Math.abs(random.nextInt()) % (int)d4 + (int)d2);
                vector.add(d);
            }
        }
        if (n4 == 0) {
            for (n5 = 0; n5 < n2; ++n5) {
                d = new Double(random.nextDouble() * d4 + d2);
                vector.add(d);
            }
        }
        return vector;
    }

    protected Vector makeTestValueList(int n, int n2, double d, double d2, int n3) throws Exception {
        Double d3;
        int n4;
        double d4 = d2 - d;
        Vector<Double> vector = new Vector<Double>(n2);
        Random random = new Random(n);
        if (n3 == 1) {
            for (n4 = 0; n4 < n2; ++n4) {
                d3 = new Double(Math.abs(random.nextInt()) % (int)d4 + (int)d);
                vector.add(d3);
            }
        }
        if (n3 == 0) {
            for (n4 = 0; n4 < n2; ++n4) {
                d3 = new Double(random.nextDouble() * d4 + d);
                vector.add(d3);
            }
        }
        return vector;
    }

    protected Vector testWithTestValues(Estimator estimator, Vector vector) {
        Vector<Double> vector2 = new Vector<Double>();
        for (int i = 0; i < vector.size(); ++i) {
            double d = (Double)vector.elementAt(i);
            double d2 = estimator.getProbability(d);
            Double d3 = new Double(d2);
            vector2.add(d3);
        }
        return vector2;
    }

    protected double[] getMinimumMaximum(Instances instances, int n) {
        double[] dArray = new double[2];
        try {
            int n2 = CheckEstimator.getMinMax(instances, n, dArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
        return dArray;
    }

    public static int getMinMax(Instances instances, int n, double[] dArray) throws Exception {
        double d = Double.NaN;
        double d2 = Double.NaN;
        Instance instance = null;
        int n2 = 0;
        if (dArray == null || dArray.length < 2) {
            throw new Exception("Error in Program, privat method getMinMax");
        }
        Enumeration enumeration = instances.enumerateInstances();
        if (enumeration.hasMoreElements()) {
            while ((instance = (Instance)enumeration.nextElement()).isMissing(n) && enumeration.hasMoreElements()) {
            }
            if (!instance.isMissing(n)) {
                ++n2;
                d = instance.value(n);
                d2 = instance.value(n);
            }
            while (enumeration.hasMoreElements()) {
                instance = (Instance)enumeration.nextElement();
                if (instance.isMissing(n)) continue;
                ++n2;
                if (instance.value(n) < d) {
                    d = instance.value(n);
                    continue;
                }
                if (!(instance.value(n) > d2)) continue;
                d2 = instance.value(n);
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
        return n2;
    }

    private String probsToString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append("" + (Double)vector.elementAt(i) + " ");
        }
        return stringBuffer.toString();
    }

    protected Instances process(Instances instances) {
        if (this.getPostProcessor() == null) {
            return instances;
        }
        return this.getPostProcessor().process(instances);
    }

    protected void printAttributeSummary(AttrTypes attrTypes, int n) {
        String string = "";
        if (attrTypes.numeric) {
            string = string + " numeric";
        }
        if (attrTypes.nominal) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " nominal";
        }
        if (attrTypes.string) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " string";
        }
        if (attrTypes.date) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " date";
        }
        if (attrTypes.relational) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " relational";
        }
        string = string + " attributes)";
        switch (n) {
            case 0: {
                string = " (numeric class," + string;
                break;
            }
            case 1: {
                string = " (nominal class," + string;
                break;
            }
            case 2: {
                string = " (string class," + string;
                break;
            }
            case 3: {
                string = " (date class," + string;
                break;
            }
            case 4: {
                string = " (relational class," + string;
            }
        }
        this.print(string);
    }

    protected void printAttributeSummary(int n, int n2) {
        String string = "";
        switch (n) {
            case 0: {
                string = " numeric" + string;
                break;
            }
            case 1: {
                string = " nominal" + string;
                break;
            }
            case 2: {
                string = " string" + string;
                break;
            }
            case 3: {
                string = " date" + string;
                break;
            }
            case 4: {
                string = " relational" + string;
            }
        }
        string = string + " attribute(s))";
        switch (n2) {
            case 0: {
                string = " (numeric class," + string;
                break;
            }
            case 1: {
                string = " (nominal class," + string;
                break;
            }
            case 2: {
                string = " (string class," + string;
                break;
            }
            case 3: {
                string = " (date class," + string;
                break;
            }
            case 4: {
                string = " (relational class," + string;
            }
        }
        this.print(string);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        try {
            CheckEstimator checkEstimator = new CheckEstimator();
            try {
                checkEstimator.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + "\n\n" + checkEstimator.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
                Enumeration enumeration = checkEstimator.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            checkEstimator.doTests();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public static class EstTypes
    implements RevisionHandler {
        boolean incremental = false;
        boolean weighted = false;
        boolean supervised = false;

        public EstTypes() {
        }

        public EstTypes(boolean bl, boolean bl2, boolean bl3) {
            this.incremental = bl;
            this.weighted = bl2;
            this.supervised = bl3;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.5 $");
        }
    }

    public static class AttrTypes
    implements RevisionHandler {
        boolean nominal = false;
        boolean numeric = false;
        boolean string = false;
        boolean date = false;
        boolean relational = false;

        AttrTypes() {
        }

        AttrTypes(AttrTypes attrTypes) {
            this.nominal = attrTypes.nominal;
            this.numeric = attrTypes.numeric;
            this.string = attrTypes.string;
            this.date = attrTypes.date;
            this.relational = attrTypes.relational;
        }

        AttrTypes(int n) {
            if (n == 1) {
                this.nominal = true;
            }
            if (n == 0) {
                this.numeric = true;
            }
            if (n == 2) {
                this.string = true;
            }
            if (n == 3) {
                this.date = true;
            }
            if (n == 4) {
                this.relational = true;
            }
        }

        int getSetType() throws Exception {
            int n = 0;
            int n2 = -1;
            if (this.nominal) {
                ++n;
                n2 = 1;
            }
            if (this.numeric) {
                ++n;
                n2 = 0;
            }
            if (this.string) {
                ++n;
                n2 = 2;
            }
            if (this.date) {
                ++n;
                n2 = 3;
            }
            if (this.relational) {
                ++n;
                n2 = 4;
            }
            if (n > 1) {
                throw new Exception("Expected to have only one type set used wrongly.");
            }
            if (n2 < 0) {
                throw new Exception("No type set.");
            }
            return n2;
        }

        boolean oneIsSet() {
            return this.nominal || this.numeric || this.string || this.date || this.relational;
        }

        public Vector getVectorOfAttrTypes() {
            Vector<Integer> vector = new Vector<Integer>();
            if (this.nominal) {
                vector.add(new Integer(1));
            }
            if (this.numeric) {
                vector.add(new Integer(0));
            }
            if (this.string) {
                vector.add(new Integer(2));
            }
            if (this.date) {
                vector.add(new Integer(3));
            }
            if (this.relational) {
                vector.add(new Integer(4));
            }
            return vector;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.5 $");
        }
    }

    public class PostProcessor
    implements RevisionHandler {
        protected Instances process(Instances instances) {
            return instances;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.5 $");
        }
    }
}

