/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.consumer;

import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.pmml.MappingInfo;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.PMMLModel;
import weka.gui.Logger;

public abstract class PMMLClassifier
extends Classifier
implements Serializable,
PMMLModel {
    private static final long serialVersionUID = -5371600590320702971L;
    protected String m_pmmlVersion = "?";
    protected String m_creatorApplication = "?";
    protected Logger m_log = null;
    protected Instances m_dataDictionary;
    protected MiningSchema m_miningSchema;
    protected transient MappingInfo m_fieldsMap;
    protected transient boolean m_initialized = false;

    PMMLClassifier(Instances instances, MiningSchema miningSchema) {
        this.m_dataDictionary = instances;
        this.m_miningSchema = miningSchema;
    }

    public void setPMMLVersion(Document document) {
        String string;
        NodeList nodeList = document.getElementsByTagName("PMML");
        Node node = nodeList.item(0);
        if (node.getNodeType() == 1 && (string = ((Element)node).getAttribute("version")).length() > 0) {
            this.m_pmmlVersion = string;
        }
    }

    public void setCreatorApplication(Document document) {
        String string;
        Node node;
        NodeList nodeList;
        NodeList nodeList2 = document.getElementsByTagName("Header");
        Node node2 = nodeList2.item(0);
        if (node2.getNodeType() == 1 && (nodeList = ((Element)node2).getElementsByTagName("Application")).getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1 && (string = ((Element)node).getAttribute("name")) != null && string.length() > 0) {
            String string2 = ((Element)node).getAttribute("version");
            if (string2 != null && string2.length() > 0) {
                string = string + " v. " + string2;
            }
            this.m_creatorApplication = string;
        }
    }

    public Instances getDataDictionary() {
        return this.m_dataDictionary;
    }

    public MiningSchema getMiningSchema() {
        return this.m_miningSchema;
    }

    public String getPMMLVersion() {
        return this.m_pmmlVersion;
    }

    public String getCreatorApplication() {
        return this.m_creatorApplication;
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public Logger getLog() {
        return this.m_log;
    }

    public void buildClassifier(Instances instances) throws Exception {
        throw new Exception("[PMMLClassifier] PMML models are pre-built and static!");
    }

    public void done() {
        this.m_initialized = false;
        this.m_fieldsMap = null;
    }

    public void mapToMiningSchema(Instances instances) throws Exception {
        if (this.m_fieldsMap == null) {
            this.m_fieldsMap = new MappingInfo(instances, this.m_miningSchema, this.m_log);
            this.m_initialized = true;
        }
    }

    public String getFieldsMappingString() {
        if (!this.m_initialized) {
            return null;
        }
        return this.m_fieldsMap.getFieldsMappingString();
    }
}

