/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.Serializable;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;

public class HyperPipes
extends Classifier {
    static final long serialVersionUID = -7527596632268975274L;
    protected int m_ClassIndex;
    protected Instances m_Instances;
    protected HyperPipe[] m_HyperPipes;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "Class implementing a HyperPipe classifier. For each category a HyperPipe is constructed that contains all points of that category (essentially records the attribute bounds observed for each category). Test instances are classified according to the category that \"most contains the instance\".\nDoes not handle numeric class, or missing values in test cases. Extremely simple algorithm, but has the advantage of being extremely fast, and works quite well when you have \"smegloads\" of attributes.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_ClassIndex = instances.classIndex();
        this.m_Instances = new Instances(instances, 0);
        this.m_HyperPipes = new HyperPipe[instances.numClasses()];
        for (n = 0; n < this.m_HyperPipes.length; ++n) {
            this.m_HyperPipes[n] = new HyperPipe(new Instances(instances, 0));
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            this.updateClassifier(instances.instance(n));
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (instance.classIsMissing()) {
            return;
        }
        this.m_HyperPipes[(int)instance.classValue()].addInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] dArray = new double[this.m_HyperPipes.length];
        for (int i = 0; i < this.m_HyperPipes.length; ++i) {
            dArray[i] = this.m_HyperPipes[i].partialContains(instance);
        }
        double d = Utils.sum(dArray);
        if (d <= 0.0) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = 1.0 / (double)dArray.length;
            }
            return dArray;
        }
        Utils.normalize(dArray, d);
        return dArray;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        if (this.m_HyperPipes == null) {
            return "HyperPipes classifier";
        }
        StringBuffer stringBuffer = new StringBuffer("HyperPipes classifier\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5528 $");
    }

    public static void main(String[] stringArray) {
        HyperPipes.runClassifier(new HyperPipes(), stringArray);
    }

    class HyperPipe
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 3972254260367902025L;
        protected double[][] m_NumericBounds;
        protected boolean[][] m_NominalBounds;

        public HyperPipe(Instances instances) throws Exception {
            int n;
            this.m_NumericBounds = new double[instances.numAttributes()][];
            this.m_NominalBounds = new boolean[instances.numAttributes()][];
            block4: for (n = 0; n < instances.numAttributes(); ++n) {
                switch (instances.attribute(n).type()) {
                    case 0: {
                        this.m_NumericBounds[n] = new double[2];
                        this.m_NumericBounds[n][0] = Double.POSITIVE_INFINITY;
                        this.m_NumericBounds[n][1] = Double.NEGATIVE_INFINITY;
                        continue block4;
                    }
                    case 1: {
                        this.m_NominalBounds[n] = new boolean[instances.attribute(n).numValues()];
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedAttributeTypeException("Cannot process string attributes!");
                    }
                }
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                this.addInstance(instances.instance(n));
            }
        }

        public void addInstance(Instance instance) throws Exception {
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == HyperPipes.this.m_ClassIndex || instance.isMissing(i)) continue;
                double d = instance.value(i);
                if (this.m_NumericBounds[i] != null) {
                    if (d < this.m_NumericBounds[i][0]) {
                        this.m_NumericBounds[i][0] = d;
                    }
                    if (!(d > this.m_NumericBounds[i][1])) continue;
                    this.m_NumericBounds[i][1] = d;
                    continue;
                }
                this.m_NominalBounds[i][(int)d] = true;
            }
        }

        public double partialContains(Instance instance) throws Exception {
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == HyperPipes.this.m_ClassIndex || instance.isMissing(i)) continue;
                double d = instance.value(i);
                if (this.m_NumericBounds[i] != null) {
                    if (!(d >= this.m_NumericBounds[i][0]) || !(d <= this.m_NumericBounds[i][1])) continue;
                    ++n;
                    continue;
                }
                if (!this.m_NominalBounds[i][(int)d]) continue;
                ++n;
            }
            return (double)n / (double)(instance.numAttributes() - 1);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5528 $");
        }
    }
}

