/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.neighboursearch.balltrees.BallNode;

public abstract class BallSplitter
implements Serializable,
OptionHandler,
RevisionHandler {
    protected Instances m_Instances;
    protected EuclideanDistance m_DistanceFunction;
    protected int[] m_Instlist;

    public BallSplitter() {
    }

    public BallSplitter(int[] nArray, Instances instances, EuclideanDistance euclideanDistance) {
        this.m_Instlist = nArray;
        this.m_Instances = instances;
        this.m_DistanceFunction = euclideanDistance;
    }

    protected void correctlyInitialized() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied.");
        }
        if (this.m_Instlist == null) {
            throw new Exception("No instance list supplied.");
        }
        if (this.m_DistanceFunction == null) {
            throw new Exception("No Euclidean distance function supplied.");
        }
        if (this.m_Instances.numInstances() != this.m_Instlist.length) {
            throw new Exception("The supplied instance list doesn't seem to match the supplied instances");
        }
    }

    public Enumeration listOptions() {
        return new Vector().elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
    }

    public String[] getOptions() {
        return new String[0];
    }

    public abstract void splitNode(BallNode var1, int var2) throws Exception;

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setInstanceList(int[] nArray) {
        this.m_Instlist = nArray;
    }

    public void setEuclideanDistanceFunction(EuclideanDistance euclideanDistance) {
        this.m_DistanceFunction = euclideanDistance;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

