/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class AttributeSelection
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -296211247688169716L;
    private weka.attributeSelection.AttributeSelection m_trainSelector;
    private ASEvaluation m_ASEvaluator;
    private ASSearch m_ASSearch;
    private String[] m_FilterOptions;
    private int[] m_SelectedAttributes;

    public String globalInfo() {
        return "A supervised attribute filter that can be used to select attributes. It is very flexible and allows various search and evaluation methods to be combined.";
    }

    public AttributeSelection() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Enumeration enumeration;
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tSets search method for subset evaluators.\n\teg. -S \"weka.attributeSelection.BestFirst -S 8\"", "S", 1, "-S <\"Name of search class [search options]\">"));
        vector.addElement(new Option("\tSets attribute/subset evaluator.\n\teg. -E \"weka.attributeSelection.CfsSubsetEval -L\"", "E", 1, "-E <\"Name of attribute/subset evaluation class [evaluator options]\">"));
        if (this.m_ASEvaluator != null && this.m_ASEvaluator instanceof OptionHandler) {
            enumeration = ((OptionHandler)((Object)this.m_ASEvaluator)).listOptions();
            vector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_ASEvaluator.getClass().getName() + ":"));
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        if (this.m_ASSearch != null && this.m_ASSearch instanceof OptionHandler) {
            enumeration = ((OptionHandler)((Object)this.m_ASSearch)).listOptions();
            vector.addElement(new Option("", "", 0, "\nOptions specific to search " + this.m_ASSearch.getClass().getName() + ":"));
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string;
        String string2;
        int n;
        this.resetOptions();
        if (Utils.getFlag('X', stringArray)) {
            throw new Exception("Cross validation is not a valid option when using attribute selection as a Filter.");
        }
        String string3 = Utils.getOption('E', stringArray);
        if (string3.length() != 0) {
            string3 = string3.trim();
            n = string3.indexOf(32);
            string2 = string3;
            string = "";
            stringArray2 = null;
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n).trim();
                stringArray2 = Utils.splitOptions(string);
            }
            this.setEvaluator(ASEvaluation.forName(string2, stringArray2));
        }
        if (this.m_ASEvaluator instanceof AttributeEvaluator) {
            this.setSearch(new Ranker());
        }
        if ((string3 = Utils.getOption('S', stringArray)).length() != 0) {
            string3 = string3.trim();
            n = string3.indexOf(32);
            string2 = string3;
            string = "";
            stringArray2 = null;
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n).trim();
                stringArray2 = Utils.splitOptions(string);
            }
            this.setSearch(ASSearch.forName(string2, stringArray2));
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        String[] stringArray2 = new String[]{};
        int n = 0;
        if (this.m_ASEvaluator instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_ASEvaluator)).getOptions();
        }
        if (this.m_ASSearch instanceof OptionHandler) {
            stringArray2 = ((OptionHandler)((Object)this.m_ASSearch)).getOptions();
        }
        String[] stringArray3 = new String[10];
        stringArray3[n++] = "-E";
        stringArray3[n++] = this.getEvaluator().getClass().getName() + " " + Utils.joinOptions(stringArray);
        stringArray3[n++] = "-S";
        stringArray3[n++] = this.getSearch().getClass().getName() + " " + Utils.joinOptions(stringArray2);
        while (n < stringArray3.length) {
            stringArray3[n++] = "";
        }
        return stringArray3;
    }

    public String evaluatorTipText() {
        return "Determines how attributes/attribute subsets are evaluated.";
    }

    public void setEvaluator(ASEvaluation aSEvaluation) {
        this.m_ASEvaluator = aSEvaluation;
    }

    public String searchTipText() {
        return "Determines the search method.";
    }

    public void setSearch(ASSearch aSSearch) {
        this.m_ASSearch = aSSearch;
    }

    public ASEvaluation getEvaluator() {
        return this.m_ASEvaluator;
    }

    public ASSearch getSearch() {
        return this.m_ASSearch;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        if (this.m_ASEvaluator == null) {
            capabilities = super.getCapabilities();
            capabilities.disableAll();
        } else {
            capabilities = this.m_ASEvaluator.getCapabilities();
            capabilities.enable(Capabilities.Capability.NO_CLASS);
        }
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.m_trainSelector.setEvaluator(this.m_ASEvaluator);
            this.m_trainSelector.setSearch(this.m_ASSearch);
            this.m_trainSelector.SelectAttributes(this.getInputFormat());
            this.m_SelectedAttributes = this.m_trainSelector.selectedAttributes();
            if (this.m_SelectedAttributes == null) {
                throw new Exception("No selected attributes\n");
            }
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
            this.flushInput();
        }
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected void setOutputFormat() throws Exception {
        if (this.m_SelectedAttributes == null) {
            this.setOutputFormat(null);
            return;
        }
        FastVector fastVector = new FastVector(this.m_SelectedAttributes.length);
        Instances instances = this.m_ASEvaluator instanceof AttributeTransformer ? ((AttributeTransformer)((Object)this.m_ASEvaluator)).transformedHeader() : this.getInputFormat();
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            fastVector.addElement(instances.attribute(this.m_SelectedAttributes[i]).copy());
        }
        Instances instances2 = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator)) {
            instances2.setClassIndex(this.m_SelectedAttributes.length - 1);
        }
        this.setOutputFormat(instances2);
    }

    protected void convertInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.getOutputFormat().numAttributes()];
        if (this.m_ASEvaluator instanceof AttributeTransformer) {
            Instance instance2 = ((AttributeTransformer)((Object)this.m_ASEvaluator)).convertInstance(instance);
            for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                int n = this.m_SelectedAttributes[i];
                dArray[i] = instance2.value(n);
            }
        } else {
            for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                int n = this.m_SelectedAttributes[i];
                dArray[i] = instance.value(n);
            }
        }
        if (instance instanceof SparseInstance) {
            this.push(new SparseInstance(instance.weight(), dArray));
        } else {
            this.push(new Instance(instance.weight(), dArray));
        }
    }

    protected void resetOptions() {
        this.m_trainSelector = new weka.attributeSelection.AttributeSelection();
        this.setEvaluator(new CfsSubsetEval());
        this.setSearch(new BestFirst());
        this.m_SelectedAttributes = null;
        this.m_FilterOptions = null;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5541 $");
    }

    public static void main(String[] stringArray) {
        AttributeSelection.runFilter(new AttributeSelection(), stringArray);
    }
}

