/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class BestFirst
extends ASSearch
implements OptionHandler,
StartSetHandler {
    static final long serialVersionUID = 7841338689536821867L;
    protected int m_maxStale;
    protected int m_searchDirection;
    protected static final int SELECTION_BACKWARD = 0;
    protected static final int SELECTION_FORWARD = 1;
    protected static final int SELECTION_BIDIRECTIONAL = 2;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Backward"), new Tag(1, "Forward"), new Tag(2, "Bi-directional")};
    protected int[] m_starting;
    protected Range m_startRange;
    protected boolean m_hasClass;
    protected int m_classIndex;
    protected int m_numAttribs;
    protected int m_totalEvals;
    protected boolean m_debug;
    protected double m_bestMerit;
    protected int m_cacheSize;

    public String globalInfo() {
        return "BestFirst:\n\nSearches the space of attribute subsets by greedy hillclimbing augmented with a backtracking facility. Setting the number of consecutive non-improving nodes allowed controls the level of backtracking done. Best first may start with the empty set of attributes and search forward, or start with the full set of attributes and search backward, or start at any point and search in both directions (by considering all possible single attribute additions and deletions at a given point).\n";
    }

    public BestFirst() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.", "P", 1, "-P <start set>"));
        vector.addElement(new Option("\tDirection of search. (default = 1).", "D", 1, "-D <0 = backward | 1 = forward | 2 = bi-directional>"));
        vector.addElement(new Option("\tNumber of non-improving nodes to\n\tconsider before terminating search.", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tSize of lookup cache for evaluated subsets.\n\tExpressed as a multiple of the number of\n\tattributes in the data set. (default = 1)", "S", 1, "-S <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        if ((string = Utils.getOption('D', stringArray)).length() != 0) {
            this.setDirection(new SelectedTag(Integer.parseInt(string), TAGS_SELECTION));
        } else {
            this.setDirection(new SelectedTag(1, TAGS_SELECTION));
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setSearchTermination(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('S', stringArray)).length() != 0) {
            this.setLookupCacheSize(Integer.parseInt(string));
        }
        this.m_debug = Utils.getFlag('Z', stringArray);
    }

    public void setLookupCacheSize(int n) {
        if (n >= 0) {
            this.m_cacheSize = n;
        }
    }

    public int getLookupCacheSize() {
        return this.m_cacheSize;
    }

    public String lookupCacheSizeTipText() {
        return "Set the maximum size of the lookup cache of evaluated subsets. This is expressed as a multiplier of the number of attributes in the data set. (default = 1).";
    }

    public String startSetTipText() {
        return "Set the start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String searchTerminationTipText() {
        return "Set the amount of backtracking. Specify the number of ";
    }

    public void setSearchTermination(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Value of -N must be > 0.");
        }
        this.m_maxStale = n;
    }

    public int getSearchTermination() {
        return this.m_maxStale;
    }

    public String directionTipText() {
        return "Set the direction of the search.";
    }

    public void setDirection(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SELECTION) {
            this.m_searchDirection = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getDirection() {
        return new SelectedTag(this.m_searchDirection, TAGS_SELECTION);
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        stringArray[n++] = "-D";
        stringArray[n++] = "" + this.m_searchDirection;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_maxStale;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    private String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tBest first.\n\tStart set: ");
        if (this.m_starting == null) {
            stringBuffer.append("no attributes\n");
        } else {
            stringBuffer.append(this.startSetToString() + "\n");
        }
        stringBuffer.append("\tSearch direction: ");
        if (this.m_searchDirection == 0) {
            stringBuffer.append("backward\n");
        } else if (this.m_searchDirection == 1) {
            stringBuffer.append("forward\n");
        } else {
            stringBuffer.append("bi-directional\n");
        }
        stringBuffer.append("\tStale search after " + this.m_maxStale + " node expansions\n");
        stringBuffer.append("\tTotal number of subsets evaluated: " + this.m_totalEvals + "\n");
        stringBuffer.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return stringBuffer.toString();
    }

    protected void printGroup(BitSet bitSet, int n) {
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            System.out.print(i + 1 + " ");
        }
        System.out.println();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        this.m_totalEvals = 0;
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = instances.classIndex();
        }
        SubsetEvaluator subsetEvaluator = (SubsetEvaluator)((Object)aSEvaluation);
        this.m_numAttribs = instances.numAttributes();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.m_searchDirection;
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>(this.m_cacheSize * this.m_numAttribs);
        int n5 = 0;
        int n6 = 0;
        LinkedList2 linkedList2 = new LinkedList2(this.m_maxStale);
        double d = -1.7976931348623157E308;
        int n7 = 0;
        BitSet bitSet = new BitSet(this.m_numAttribs);
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_starting != null) {
            for (n = 0; n < this.m_starting.length; ++n) {
                if (this.m_starting[n] == this.m_classIndex) continue;
                bitSet.set(this.m_starting[n]);
            }
            n2 = this.m_starting.length;
            ++this.m_totalEvals;
        } else if (this.m_searchDirection == 0) {
            this.setStartSet("1-last");
            this.m_starting = new int[this.m_numAttribs];
            int n8 = 0;
            for (n = 0; n < this.m_numAttribs; ++n) {
                if (n == this.m_classIndex) continue;
                bitSet.set(n);
                this.m_starting[n8++] = n;
            }
            n2 = this.m_numAttribs - 1;
            ++this.m_totalEvals;
        }
        d = subsetEvaluator.evaluateSubset(bitSet);
        Object[] objectArray = new Object[]{bitSet.clone()};
        linkedList2.addToList(objectArray, d);
        BitSet bitSet2 = (BitSet)bitSet.clone();
        String string = bitSet2.toString();
        hashtable.put(string, new Double(d));
        while (n7 < this.m_maxStale) {
            int n9;
            boolean bl = false;
            if (this.m_searchDirection == 2) {
                n9 = 2;
                n4 = 1;
            } else {
                n9 = 1;
            }
            if (linkedList2.size() == 0) {
                n7 = this.m_maxStale;
                break;
            }
            Link2 link2 = linkedList2.getLinkAt(0);
            BitSet bitSet3 = (BitSet)link2.getData()[0];
            bitSet3 = (BitSet)bitSet3.clone();
            linkedList2.removeLinkAt(0);
            n3 = 0;
            for (int i = 0; i < this.m_numAttribs; ++i) {
                if (!bitSet3.get(i)) continue;
                ++n3;
            }
            do {
                for (n = 0; n < this.m_numAttribs; ++n) {
                    double d2;
                    boolean bl2;
                    if (n4 == 1) {
                        bl2 = n != this.m_classIndex && !bitSet3.get(n);
                    } else {
                        boolean bl3 = bl2 = n != this.m_classIndex && bitSet3.get(n);
                    }
                    if (!bl2) continue;
                    if (n4 == 1) {
                        bitSet3.set(n);
                        ++n3;
                    } else {
                        bitSet3.clear(n);
                        --n3;
                    }
                    bitSet2 = (BitSet)bitSet3.clone();
                    string = bitSet2.toString();
                    if (!hashtable.containsKey(string)) {
                        d2 = subsetEvaluator.evaluateSubset(bitSet3);
                        ++this.m_totalEvals;
                        if (n5 > this.m_cacheSize * this.m_numAttribs) {
                            hashtable = new Hashtable(this.m_cacheSize * this.m_numAttribs);
                            n5 = 0;
                        }
                        string = bitSet2.toString();
                        hashtable.put(string, new Double(d2));
                        ++n5;
                    } else {
                        d2 = (Double)hashtable.get(string);
                        ++n6;
                    }
                    Object[] objectArray2 = new Object[]{bitSet2.clone()};
                    linkedList2.addToList(objectArray2, d2);
                    if (this.m_debug) {
                        System.out.print("Group: ");
                        this.printGroup(bitSet2, this.m_numAttribs);
                        System.out.println("Merit: " + d2);
                    }
                    if (n4 == 1) {
                        bl2 = d2 - d > 1.0E-5;
                    } else if (d2 == d) {
                        bl2 = n3 < n2;
                    } else {
                        boolean bl4 = bl2 = d2 > d;
                    }
                    if (bl2) {
                        bl = true;
                        n7 = 0;
                        d = d2;
                        n2 = n3;
                        bitSet = (BitSet)bitSet3.clone();
                    }
                    if (n4 == 1) {
                        bitSet3.clear(n);
                        --n3;
                        continue;
                    }
                    bitSet3.set(n);
                    ++n3;
                }
                if (n9 != 2) continue;
                n4 = 0;
            } while (--n9 > 0);
            if (bl) continue;
            ++n7;
        }
        this.m_bestMerit = d;
        return this.attributeList(bitSet);
    }

    protected void resetOptions() {
        this.m_maxStale = 5;
        this.m_searchDirection = 1;
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_classIndex = -1;
        this.m_totalEvals = 0;
        this.m_cacheSize = 1;
        this.m_debug = false;
    }

    protected int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.29 $");
    }

    public class LinkedList2
    extends FastVector {
        static final long serialVersionUID = 3250538292330398929L;
        int m_MaxSize;

        public LinkedList2(int n) {
            this.m_MaxSize = n;
        }

        public void removeLinkAt(int n) throws Exception {
            if (n < 0 || n >= this.size()) {
                throw new Exception("index out of range (removeLinkAt)");
            }
            this.removeElementAt(n);
        }

        public Link2 getLinkAt(int n) throws Exception {
            if (this.size() == 0) {
                throw new Exception("List is empty (getLinkAt)");
            }
            if (n >= 0 && n < this.size()) {
                return (Link2)this.elementAt(n);
            }
            throw new Exception("index out of range (getLinkAt)");
        }

        public void addToList(Object[] objectArray, double d) throws Exception {
            Link2 link2 = new Link2(objectArray, d);
            if (this.size() == 0) {
                this.addElement(link2);
            } else if (d > ((Link2)this.firstElement()).m_merit) {
                if (this.size() == this.m_MaxSize) {
                    this.removeLinkAt(this.m_MaxSize - 1);
                }
                this.insertElementAt(link2, 0);
            } else {
                int n = 0;
                int n2 = this.size();
                boolean bl = false;
                if (n2 != this.m_MaxSize || !(d <= ((Link2)this.lastElement()).m_merit)) {
                    while (!bl && n < n2) {
                        if (d > ((Link2)this.elementAt((int)n)).m_merit) {
                            if (n2 == this.m_MaxSize) {
                                this.removeLinkAt(this.m_MaxSize - 1);
                            }
                            this.insertElementAt(link2, n);
                            bl = true;
                            continue;
                        }
                        if (n == n2 - 1) {
                            this.addElement(link2);
                            bl = true;
                            continue;
                        }
                        ++n;
                    }
                }
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.29 $");
        }
    }

    public class Link2
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -8236598311516351420L;
        Object[] m_data;
        double m_merit;

        public Link2(Object[] objectArray, double d) {
            this.m_data = objectArray;
            this.m_merit = d;
        }

        public Object[] getData() {
            return this.m_data;
        }

        public String toString() {
            return "Node: " + this.m_data.toString() + "  " + this.m_merit;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.29 $");
        }
    }
}

