/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.lmt;

import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class ResidualSplit
extends ClassifierSplitModel {
    private static final long serialVersionUID = -5055883734183713525L;
    protected Attribute m_attribute;
    protected int m_attIndex;
    protected int m_numInstances;
    protected int m_numClasses;
    protected Instances m_data;
    protected double[][] m_dataZs;
    protected double[][] m_dataWs;
    protected double m_splitPoint;

    public ResidualSplit(int n) {
        this.m_attIndex = n;
    }

    public void buildClassifier(Instances instances, double[][] dArray, double[][] dArray2) throws Exception {
        this.m_numClasses = instances.numClasses();
        this.m_numInstances = instances.numInstances();
        if (this.m_numInstances == 0) {
            throw new Exception("Can't build split on 0 instances");
        }
        this.m_data = instances;
        this.m_dataZs = dArray;
        this.m_dataWs = dArray2;
        this.m_attribute = instances.attribute(this.m_attIndex);
        if (this.m_attribute.isNominal()) {
            this.m_splitPoint = 0.0;
            this.m_numSubsets = this.m_attribute.numValues();
        } else {
            this.getSplitPoint();
            this.m_numSubsets = 2;
        }
        this.m_distribution = new Distribution(instances, this);
    }

    protected boolean getSplitPoint() throws Exception {
        int n;
        double[] dArray = new double[this.m_numInstances];
        int n2 = 0;
        Instances instances = new Instances(this.m_data);
        instances.sort(instances.attribute(this.m_attIndex));
        double d = instances.instance(0).value(this.m_attIndex);
        for (int i = 0; i < this.m_numInstances - 1; ++i) {
            double d2 = instances.instance(i + 1).value(this.m_attIndex);
            if (!Utils.eq(d2, d)) {
                dArray[n2++] = (d + d2) / 2.0;
            }
            d = d2;
        }
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.m_splitPoint = dArray[n];
            dArray2[n] = this.entropyGain();
        }
        n = -1;
        double d3 = -1.7976931348623157E308;
        for (int i = 0; i < n2; ++i) {
            if (!(dArray2[i] > d3)) continue;
            d3 = dArray2[i];
            n = i;
        }
        if (n < 0) {
            return false;
        }
        this.m_splitPoint = dArray[n];
        return true;
    }

    public double entropyGain() throws Exception {
        int n;
        int n2;
        int n3 = this.m_attribute.isNominal() ? this.m_attribute.numValues() : 2;
        double[][][] dArrayArray = new double[n3][][];
        double[][][] dArrayArray2 = new double[n3][][];
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < this.m_numInstances; ++n2) {
            n = this.whichSubset(this.m_data.instance(n2));
            if (n < 0) {
                throw new Exception("ResidualSplit: no support for splits on missing values");
            }
            int n4 = n;
            nArray[n4] = nArray[n4] + 1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray[n2] = new double[nArray[n2]][];
            dArrayArray2[n2] = new double[nArray[n2]][];
        }
        int[] nArray2 = new int[n3];
        for (n = 0; n < this.m_numInstances; ++n) {
            int n5 = this.whichSubset(this.m_data.instance(n));
            dArrayArray[n5][nArray2[n5]] = this.m_dataZs[n];
            dArrayArray2[n5][nArray2[n5]] = this.m_dataWs[n];
            int n6 = n5;
            nArray2[n6] = nArray2[n6] + 1;
        }
        double d = this.entropy(this.m_dataZs, this.m_dataWs);
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            d2 += this.entropy(dArrayArray[i], dArrayArray2[i]);
        }
        return d - d2;
    }

    protected double entropy(double[][] dArray, double[][] dArray2) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < this.m_numClasses; ++i) {
            int n2;
            double d2 = 0.0;
            double d3 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d2 += dArray[n2][i] * dArray2[n2][i];
                d3 += dArray2[n2][i];
            }
            d2 /= d3;
            for (n2 = 0; n2 < n; ++n2) {
                d += dArray2[n2][i] * Math.pow(dArray[n2][i] - d2, 2.0);
            }
        }
        return d;
    }

    public boolean checkModel(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_distribution.numBags(); ++i) {
            if (!(this.m_distribution.perBag(i) >= (double)n)) continue;
            ++n2;
        }
        return n2 >= 2;
    }

    public final String leftSide(Instances instances) {
        return instances.attribute(this.m_attIndex).name();
    }

    public final String rightSide(int n, Instances instances) {
        StringBuffer stringBuffer = new StringBuffer();
        if (instances.attribute(this.m_attIndex).isNominal()) {
            stringBuffer.append(" = " + instances.attribute(this.m_attIndex).value(n));
        } else if (n == 0) {
            stringBuffer.append(" <= " + Utils.doubleToString(this.m_splitPoint, 6));
        } else {
            stringBuffer.append(" > " + Utils.doubleToString(this.m_splitPoint, 6));
        }
        return stringBuffer.toString();
    }

    public final int whichSubset(Instance instance) throws Exception {
        if (instance.isMissing(this.m_attIndex)) {
            return -1;
        }
        if (instance.attribute(this.m_attIndex).isNominal()) {
            return (int)instance.value(this.m_attIndex);
        }
        if (Utils.smOrEq(instance.value(this.m_attIndex), this.m_splitPoint)) {
            return 0;
        }
        return 1;
    }

    public void buildClassifier(Instances instances) {
    }

    public final double[] weights(Instance instance) {
        return null;
    }

    public final String sourceExpression(int n, Instances instances) {
        return "";
    }
}

