/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.CSVLoader;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.core.neighboursearch.TreePerformanceStats;
import weka.core.neighboursearch.covertrees.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverTree
extends NearestNeighbourSearch
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 7617412821497807586L;
    protected EuclideanDistance m_EuclideanDistance;
    protected CoverTreeNode m_Root;
    protected double[] m_DistanceList;
    protected int m_NumNodes;
    protected int m_NumLeaves;
    protected int m_MaxDepth;
    protected TreePerformanceStats m_TreeStats;
    protected double m_Base;
    protected double il2;

    public CoverTree() {
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_TreeStats = null;
        this.m_Base = 1.3;
        this.il2 = 1.0 / Math.log(this.m_Base);
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    @Override
    public String globalInfo() {
        return "Class implementing the CoverTree datastructure.\nThe class is very much a translation of the c source code made available by the authors.\n\nFor more information and original source code see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Alina Beygelzimer and Sham Kakade and John Langford");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Cover trees for nearest neighbor");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "ICML'06: Proceedings of the 23rd international conference on Machine learning");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "97-104");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY, USA");
        technicalInformation.setValue(TechnicalInformation.Field.LOCATION, "Pittsburgh, Pennsylvania");
        technicalInformation.setValue(TechnicalInformation.Field.HTTP, "http://hunch.net/~jl/projects/cover_tree/cover_tree.html");
        return technicalInformation;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSet base of the expansion constant\n\t(default = 1.3).", "B", 1, "-B <value>"));
        return vector.elements();
    }

    @Override
    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setBase(Double.parseDouble(string));
        } else {
            this.setBase(1.3);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-B");
        vector.add("" + this.getBase());
        return vector.toArray(new String[vector.size()]);
    }

    protected double dist_of_scale(int n) {
        return Math.pow(this.m_Base, n);
    }

    protected int get_scale(double d) {
        return (int)Math.ceil(this.il2 * Math.log(d));
    }

    protected CoverTreeNode new_node(Integer n) {
        CoverTreeNode coverTreeNode = new CoverTreeNode();
        coverTreeNode.idx = n;
        return coverTreeNode;
    }

    protected CoverTreeNode new_leaf(Integer n) {
        CoverTreeNode coverTreeNode = new CoverTreeNode(n, 0.0, 0.0, null, 0, 100);
        return coverTreeNode;
    }

    protected double max_set(Stack<DistanceNode> stack) {
        double d = 0.0;
        for (int i = 0; i < stack.length; ++i) {
            DistanceNode distanceNode = stack.element(i);
            if (!(d < (double)distanceNode.dist.element(distanceNode.dist.length - 1).floatValue())) continue;
            d = distanceNode.dist.element(distanceNode.dist.length - 1).floatValue();
        }
        return d;
    }

    protected void split(Stack<DistanceNode> stack, Stack<DistanceNode> stack2, int n) {
        int n2 = 0;
        double d = this.dist_of_scale(n);
        for (int i = 0; i < stack.length; ++i) {
            DistanceNode distanceNode = stack.element(i);
            if (distanceNode.dist.element(distanceNode.dist.length - 1) <= d) {
                stack.set(n2++, stack.element(i));
                continue;
            }
            stack2.push(stack.element(i));
        }
        LinkedList<DistanceNode> linkedList = new LinkedList<DistanceNode>();
        for (int i = 0; i < n2; ++i) {
            linkedList.add(stack.element(i));
        }
        stack.clear();
        stack.addAll(linkedList);
    }

    protected void dist_split(Stack<DistanceNode> stack, Stack<DistanceNode> stack2, DistanceNode distanceNode, int n) {
        int n2 = 0;
        double d = this.dist_of_scale(n);
        for (int i = 0; i < stack.length; ++i) {
            double d2 = Math.sqrt(this.m_DistanceFunction.distance(distanceNode.q(), stack.element(i).q(), d * d));
            if (d2 <= d) {
                stack.element((int)i).dist.push(d2);
                stack2.push(stack.element(i));
                continue;
            }
            stack.set(n2++, stack.element(i));
        }
        LinkedList<DistanceNode> linkedList = new LinkedList<DistanceNode>();
        for (int i = 0; i < n2; ++i) {
            linkedList.add(stack.element(i));
        }
        stack.clear();
        stack.addAll(linkedList);
    }

    protected CoverTreeNode batch_insert(Integer n, int n2, int n3, Stack<DistanceNode> stack, Stack<DistanceNode> stack2) {
        if (stack.length == 0) {
            CoverTreeNode coverTreeNode = this.new_leaf(n);
            coverTreeNode.nodeid = this.m_NumNodes;
            ++this.m_NumNodes;
            ++this.m_NumLeaves;
            return coverTreeNode;
        }
        double d = this.max_set(stack);
        int n4 = Math.min(n2 - 1, this.get_scale(d));
        if (n4 == Integer.MIN_VALUE) {
            Object object;
            Stack<CoverTreeNode> stack3 = new Stack<CoverTreeNode>();
            CoverTreeNode coverTreeNode = this.new_leaf(n);
            coverTreeNode.nodeid = this.m_NumNodes;
            stack3.push(coverTreeNode);
            ++this.m_NumLeaves;
            ++this.m_NumNodes;
            while (stack.length > 0) {
                object = stack.pop();
                coverTreeNode = this.new_leaf(((DistanceNode)object).idx);
                coverTreeNode.nodeid = this.m_NumNodes;
                stack3.push(coverTreeNode);
                ++this.m_NumLeaves;
                ++this.m_NumNodes;
                stack2.push((DistanceNode)object);
            }
            object = this.new_node(n);
            ((CoverTreeNode)object).nodeid = this.m_NumNodes;
            ++this.m_NumNodes;
            ((CoverTreeNode)object).scale = 100;
            ((CoverTreeNode)object).max_dist = 0.0;
            ((CoverTreeNode)object).num_children = stack3.length;
            ((CoverTreeNode)object).children = stack3;
            return object;
        }
        Stack<DistanceNode> stack4 = new Stack<DistanceNode>();
        this.split(stack, stack4, n2);
        CoverTreeNode coverTreeNode = this.batch_insert(n, n4, n3, stack, stack2);
        if (stack.length == 0) {
            stack.replaceAllBy(stack4);
            return coverTreeNode;
        }
        CoverTreeNode coverTreeNode2 = this.new_node(n);
        coverTreeNode2.nodeid = this.m_NumNodes;
        ++this.m_NumNodes;
        Stack<CoverTreeNode> stack5 = new Stack<CoverTreeNode>();
        stack5.push(coverTreeNode);
        while (stack.length != 0) {
            int n5;
            Stack<DistanceNode> stack6 = new Stack<DistanceNode>();
            Stack<DistanceNode> stack7 = new Stack<DistanceNode>();
            DistanceNode distanceNode = stack.pop();
            double d2 = distanceNode.dist.last();
            stack2.push(distanceNode);
            this.dist_split(stack, stack6, distanceNode, n2);
            this.dist_split(stack4, stack6, distanceNode, n2);
            CoverTreeNode coverTreeNode3 = this.batch_insert(distanceNode.idx, n4, n3, stack6, stack7);
            coverTreeNode3.parent_dist = d2;
            stack5.push(coverTreeNode3);
            double d3 = this.dist_of_scale(n2);
            distanceNode = null;
            for (n5 = 0; n5 < stack6.length; ++n5) {
                distanceNode = stack6.element(n5);
                distanceNode.dist.pop();
                if (distanceNode.dist.last() <= d3) {
                    stack.push(distanceNode);
                    continue;
                }
                stack4.push(distanceNode);
            }
            distanceNode = null;
            for (n5 = 0; n5 < stack7.length; ++n5) {
                distanceNode = stack7.element(n5);
                distanceNode.dist.pop();
                stack2.push(distanceNode);
            }
        }
        stack.replaceAllBy(stack4);
        coverTreeNode2.scale = n3 - n2;
        coverTreeNode2.max_dist = this.max_set(stack2);
        coverTreeNode2.num_children = stack5.length;
        coverTreeNode2.children = stack5;
        return coverTreeNode2;
    }

    protected void buildCoverTree(Instances instances) throws Exception {
        if (instances.numInstances() == 0) {
            throw new Exception("CoverTree: Empty set of instances. Cannot build tree.");
        }
        this.checkMissing(instances);
        if (this.m_EuclideanDistance == null) {
            this.m_EuclideanDistance = new EuclideanDistance(instances);
            this.m_DistanceFunction = this.m_EuclideanDistance;
        } else {
            this.m_EuclideanDistance.setInstances(instances);
        }
        Stack<DistanceNode> stack = new Stack<DistanceNode>();
        Stack<DistanceNode> stack2 = new Stack<DistanceNode>();
        Instance instance = instances.instance(0);
        int n = 0;
        double d = -1.0;
        double d2 = 0.0;
        Instance instance2 = instance;
        for (int i = 1; i < instances.numInstances(); ++i) {
            DistanceNode distanceNode = new DistanceNode();
            distanceNode.dist = new Stack();
            d2 = Math.sqrt(this.m_DistanceFunction.distance(instance, instances.instance(i), Double.POSITIVE_INFINITY));
            if (d2 > d) {
                d = d2;
                instance2 = instances.instance(i);
            }
            distanceNode.dist.push(d2);
            distanceNode.idx = i;
            stack.push(distanceNode);
        }
        d = this.max_set(stack);
        this.m_Root = this.batch_insert(n, this.get_scale(d), this.get_scale(d), stack, stack2);
    }

    protected void setter(MyHeap myHeap, double d, int n) throws Exception {
        if (myHeap.size() > 0) {
            myHeap.m_heap[0].index = 0;
        }
        while (myHeap.size() < n) {
            myHeap.put(d);
        }
    }

    protected void update(MyHeap myHeap, double d) throws Exception {
        myHeap.putBySubstitute(d);
    }

    protected Stack<d_node> getCoverSet(int n, Stack<Stack<d_node>> stack) {
        if (stack.length <= n) {
            for (int i = stack.length - 1; i < n; ++i) {
                Stack stack2 = new Stack();
                stack.push(stack2);
            }
        }
        return stack.element(n);
    }

    protected void copy_zero_set(CoverTreeNode coverTreeNode, MyHeap myHeap, Stack<d_node> stack, Stack<d_node> stack2) throws Exception {
        stack2.clear();
        for (int i = 0; i < stack.length; ++i) {
            d_node d_node2 = stack.element(i);
            double d = myHeap.peek().distance + coverTreeNode.max_dist;
            if (!this.shell(d_node2.dist, coverTreeNode.parent_dist, d)) continue;
            double d2 = Math.sqrt(this.m_DistanceFunction.distance(coverTreeNode.p(), d_node2.n.p(), d * d));
            if (this.m_TreeStats != null) {
                this.m_TreeStats.incrPointCount();
            }
            if (!(d2 <= d)) continue;
            if (d2 < myHeap.peek().distance) {
                this.update(myHeap, d2);
            }
            d_node d_node3 = new d_node(d2, d_node2.n);
            stack2.push(d_node3);
            if (this.m_TreeStats == null) continue;
            this.m_TreeStats.incrLeafCount();
        }
    }

    protected void copy_cover_sets(CoverTreeNode coverTreeNode, MyHeap myHeap, Stack<Stack<d_node>> stack, Stack<Stack<d_node>> stack2, int n, int n2) throws Exception {
        stack2.clear();
        while (n <= n2) {
            Stack<d_node> stack3 = this.getCoverSet(n, stack);
            for (int i = 0; i < stack3.length; ++i) {
                d_node d_node2 = stack3.element(i);
                double d = myHeap.peek().distance + coverTreeNode.max_dist + d_node2.n.max_dist;
                if (!this.shell(d_node2.dist, coverTreeNode.parent_dist, d)) continue;
                double d2 = Math.sqrt(this.m_DistanceFunction.distance(coverTreeNode.p(), d_node2.n.p(), d * d));
                if (this.m_TreeStats != null) {
                    this.m_TreeStats.incrPointCount();
                }
                if (!(d2 <= d)) continue;
                if (d2 < myHeap.peek().distance) {
                    this.update(myHeap, d2);
                }
                d_node d_node3 = new d_node(d2, d_node2.n);
                stack2.element(n).push(d_node3);
                if (this.m_TreeStats == null) continue;
                this.m_TreeStats.incrIntNodeCount();
            }
            ++n;
        }
    }

    void print_cover_sets(Stack<Stack<d_node>> stack, Stack<d_node> stack2, int n, int n2) {
        CoverTreeNode coverTreeNode;
        d_node d_node2;
        int n3;
        CoverTree.println("cover set = ");
        while (n <= n2) {
            CoverTree.println("" + n);
            for (n3 = 0; n3 < stack.element((int)n).length; ++n3) {
                d_node2 = stack.element(n).element(n3);
                coverTreeNode = d_node2.n;
                CoverTree.println(coverTreeNode.p());
            }
            ++n;
        }
        CoverTree.println("infinity");
        for (n3 = 0; n3 < stack2.length; ++n3) {
            d_node2 = stack2.element(n3);
            coverTreeNode = d_node2.n;
            CoverTree.println(coverTreeNode.p());
        }
    }

    protected void SWAP(int n, int n2, Stack<d_node> stack) {
        d_node d_node2 = stack.element(n);
        stack.set(n, stack.element(n2));
        stack.set(n2, d_node2);
    }

    protected double compare(int n, int n2, Stack<d_node> stack) {
        return stack.element((int)n).dist - stack.element((int)n2).dist;
    }

    protected void halfsort(Stack<d_node> stack) {
        int n;
        if (stack.length <= 1) {
            return;
        }
        int n2 = 0;
        int n3 = n = stack.length - 1;
        while (n3 > n2) {
            int n4 = n2 + (n - n2 >> 1);
            boolean bl = false;
            if (this.compare(n4, n2, stack) < 0.0) {
                this.SWAP(n4, n2, stack);
            }
            if (this.compare(n, n4, stack) < 0.0) {
                this.SWAP(n4, n, stack);
            } else {
                bl = true;
            }
            if (!bl && this.compare(n4, n2, stack) < 0.0) {
                this.SWAP(n4, n2, stack);
            }
            int n5 = n2 + 1;
            n3 = n - 1;
            while (true) {
                if (this.compare(n5, n4, stack) < 0.0) {
                    ++n5;
                    continue;
                }
                while (this.compare(n4, n3, stack) < 0.0) {
                    --n3;
                }
                if (n5 < n3) {
                    this.SWAP(n5, n3, stack);
                    if (n4 == n5) {
                        n4 = n3;
                    } else if (n4 == n3) {
                        n4 = n5;
                    }
                    ++n5;
                    --n3;
                } else if (n5 == n3) {
                    ++n5;
                    break;
                }
                if (n5 > n3) break;
            }
            n = --n3;
        }
    }

    protected boolean shell(double d, double d2, double d3) {
        return d - d2 <= d3;
    }

    protected int descend(CoverTreeNode coverTreeNode, MyHeap myHeap, int n, int n2, Stack<Stack<d_node>> stack, Stack<d_node> stack2) throws Exception {
        Stack<d_node> stack3 = this.getCoverSet(n, stack);
        for (int i = 0; i < stack3.length; ++i) {
            d_node d_node2 = stack3.element(i);
            CoverTreeNode coverTreeNode2 = d_node2.n;
            double d = myHeap.peek().distance + coverTreeNode.max_dist + coverTreeNode.max_dist;
            if (!(d_node2.dist <= d + coverTreeNode2.max_dist)) continue;
            CoverTreeNode coverTreeNode3 = coverTreeNode2 == this.m_Root && coverTreeNode2.num_children == 0 ? coverTreeNode2 : (CoverTreeNode)coverTreeNode2.children.element(0);
            if (d_node2.dist <= d + coverTreeNode3.max_dist) {
                if (coverTreeNode3.num_children > 0) {
                    if (n2 < coverTreeNode3.scale) {
                        n2 = coverTreeNode3.scale;
                    }
                    d_node d_node3 = new d_node(d_node2.dist, coverTreeNode3);
                    this.getCoverSet(coverTreeNode3.scale, stack).push(d_node3);
                    if (this.m_TreeStats != null) {
                        this.m_TreeStats.incrIntNodeCount();
                    }
                } else if (d_node2.dist <= d) {
                    d_node d_node4 = new d_node(d_node2.dist, coverTreeNode3);
                    stack2.push(d_node4);
                    if (this.m_TreeStats != null) {
                        this.m_TreeStats.incrLeafCount();
                    }
                }
            }
            for (int j = 1; j < coverTreeNode2.num_children; ++j) {
                d_node d_node5;
                coverTreeNode3 = (CoverTreeNode)coverTreeNode2.children.element(j);
                double d2 = myHeap.peek().distance + coverTreeNode3.max_dist + coverTreeNode.max_dist + coverTreeNode.max_dist;
                if (!this.shell(d_node2.dist, coverTreeNode3.parent_dist, d2)) continue;
                double d3 = Math.sqrt(this.m_DistanceFunction.distance(coverTreeNode.p(), coverTreeNode3.p(), d2 * d2, this.m_TreeStats));
                if (this.m_TreeStats != null) {
                    this.m_TreeStats.incrPointCount();
                }
                if (!(d3 <= d2)) continue;
                if (d3 < myHeap.peek().distance) {
                    this.update(myHeap, d3);
                }
                if (coverTreeNode3.num_children > 0) {
                    if (n2 < coverTreeNode3.scale) {
                        n2 = coverTreeNode3.scale;
                    }
                    d_node5 = new d_node(d3, coverTreeNode3);
                    this.getCoverSet(coverTreeNode3.scale, stack).push(d_node5);
                    if (this.m_TreeStats == null) continue;
                    this.m_TreeStats.incrIntNodeCount();
                    continue;
                }
                if (!(d3 <= d2 - coverTreeNode3.max_dist)) continue;
                d_node5 = new d_node(d3, coverTreeNode3);
                stack2.push(d_node5);
                if (this.m_TreeStats == null) continue;
                this.m_TreeStats.incrLeafCount();
            }
        }
        return n2;
    }

    protected void brute_nearest(int n, CoverTreeNode coverTreeNode, Stack<d_node> stack, MyHeap myHeap, Stack<NearestNeighbourSearch.NeighborList> stack2) throws Exception {
        if (coverTreeNode.num_children > 0) {
            Stack<d_node> stack3 = new Stack<d_node>();
            CoverTreeNode coverTreeNode2 = (CoverTreeNode)coverTreeNode.children.element(0);
            this.brute_nearest(n, coverTreeNode2, stack, myHeap, stack2);
            MyHeap myHeap2 = new MyHeap(n);
            for (int i = 1; i < ((CoverTreeNode)coverTreeNode).children.length; ++i) {
                coverTreeNode2 = (CoverTreeNode)coverTreeNode.children.element(i);
                this.setter(myHeap2, myHeap.peek().distance + coverTreeNode2.parent_dist, n);
                this.copy_zero_set(coverTreeNode2, myHeap2, stack, stack3);
                this.brute_nearest(n, coverTreeNode2, stack3, myHeap2, stack2);
            }
        } else {
            NearestNeighbourSearch.NeighborList neighborList = new NearestNeighbourSearch.NeighborList(this, n);
            for (int i = 0; i < stack.length; ++i) {
                d_node d_node2 = stack.element(i);
                if (!(d_node2.dist <= myHeap.peek().distance)) continue;
                neighborList.insertSorted(d_node2.dist, d_node2.n.p());
            }
            stack2.push(neighborList);
        }
    }

    protected void internal_batch_nearest_neighbor(int n, CoverTreeNode coverTreeNode, Stack<Stack<d_node>> stack, Stack<d_node> stack2, int n2, int n3, MyHeap myHeap, Stack<NearestNeighbourSearch.NeighborList> stack3) throws Exception {
        if (n2 > n3) {
            this.brute_nearest(n, coverTreeNode, stack2, myHeap, stack3);
        } else if (coverTreeNode.scale <= n2 && coverTreeNode.scale != 100) {
            Stack<d_node> stack4 = new Stack<d_node>();
            Stack<Stack<d_node>> stack5 = new Stack<Stack<d_node>>();
            MyHeap myHeap2 = new MyHeap(n);
            for (int i = 1; i < coverTreeNode.num_children; ++i) {
                CoverTreeNode coverTreeNode2 = (CoverTreeNode)coverTreeNode.children.element(i);
                this.setter(myHeap2, myHeap.peek().distance + coverTreeNode2.parent_dist, n);
                this.copy_zero_set(coverTreeNode2, myHeap2, stack2, stack4);
                this.copy_cover_sets(coverTreeNode2, myHeap2, stack, stack5, n2, n3);
                this.internal_batch_nearest_neighbor(n, coverTreeNode2, stack5, stack4, n2, n3, myHeap2, stack3);
            }
            stack5 = null;
            stack4 = null;
            myHeap2 = null;
            this.internal_batch_nearest_neighbor(n, (CoverTreeNode)coverTreeNode.children.element(0), stack, stack2, n2, n3, myHeap, stack3);
        } else {
            Stack<d_node> stack6 = this.getCoverSet(n2, stack);
            this.halfsort(stack6);
            n3 = this.descend(coverTreeNode, myHeap, n2, n3, stack, stack2);
            stack6.clear();
            this.internal_batch_nearest_neighbor(n, coverTreeNode, stack, stack2, ++n2, n3, myHeap, stack3);
        }
    }

    protected void batch_nearest_neighbor(int n, CoverTreeNode coverTreeNode, CoverTreeNode coverTreeNode2, Stack<NearestNeighbourSearch.NeighborList> stack) throws Exception {
        Stack<Stack<d_node>> stack2 = new Stack<Stack<d_node>>(100);
        Stack<d_node> stack3 = new Stack<d_node>();
        MyHeap myHeap = new MyHeap(n);
        this.setter(myHeap, Double.POSITIVE_INFINITY, n);
        double d = Math.sqrt(this.m_DistanceFunction.distance(coverTreeNode2.p(), coverTreeNode.p(), Double.POSITIVE_INFINITY));
        this.update(myHeap, d);
        d_node d_node2 = new d_node(d, coverTreeNode);
        this.getCoverSet(0, stack2).push(d_node2);
        if (this.m_TreeStats != null) {
            this.m_TreeStats.incrPointCount();
            if (coverTreeNode.num_children > 0) {
                this.m_TreeStats.incrIntNodeCount();
            } else {
                this.m_TreeStats.incrLeafCount();
            }
        }
        this.internal_batch_nearest_neighbor(n, coverTreeNode2, stack2, stack3, 0, 0, myHeap, stack);
    }

    protected NearestNeighbourSearch.NeighborList findKNearest(Instance instance, int n) throws Exception {
        double d;
        Stack<d_node> stack = new Stack<d_node>();
        Stack<d_node> stack2 = new Stack<d_node>();
        MyHeap myHeap = new MyHeap(n);
        double d2 = Math.sqrt(this.m_DistanceFunction.distance(this.m_Root.p(), instance, Double.POSITIVE_INFINITY, this.m_TreeStats));
        stack.push(new d_node(d2, this.m_Root));
        this.setter(myHeap, Double.POSITIVE_INFINITY, n);
        this.update(myHeap, d2);
        if (this.m_TreeStats != null) {
            if (this.m_Root.num_children > 0) {
                this.m_TreeStats.incrIntNodeCount();
            } else {
                this.m_TreeStats.incrLeafCount();
            }
            this.m_TreeStats.incrPointCount();
        }
        if (this.m_Root.num_children == 0) {
            NearestNeighbourSearch.NeighborList neighborList = new NearestNeighbourSearch.NeighborList(this, n);
            neighborList.insertSorted(d2, this.m_Root.p());
            return neighborList;
        }
        while (stack.length > 0) {
            Stack<d_node> stack3 = new Stack<d_node>();
            for (int i = 0; i < stack.length; ++i) {
                d_node d_node2 = (d_node)stack.element(i);
                CoverTreeNode coverTreeNode = d_node2.n;
                for (int j = 0; j < coverTreeNode.num_children; ++j) {
                    CoverTreeNode coverTreeNode2 = (CoverTreeNode)coverTreeNode.children.element(j);
                    d = myHeap.peek().distance;
                    if (j == 0) {
                        d2 = d_node2.dist;
                    } else {
                        d2 = d + coverTreeNode2.max_dist;
                        d2 = Math.sqrt(this.m_DistanceFunction.distance(coverTreeNode2.p(), instance, d2 * d2, this.m_TreeStats));
                        if (this.m_TreeStats != null) {
                            this.m_TreeStats.incrPointCount();
                        }
                    }
                    if (!(d2 <= d + coverTreeNode2.max_dist)) continue;
                    if (j > 0 && d2 < d) {
                        this.update(myHeap, d2);
                    }
                    if (coverTreeNode2.num_children > 0) {
                        stack3.push(new d_node(d2, coverTreeNode2));
                        if (this.m_TreeStats == null) continue;
                        this.m_TreeStats.incrIntNodeCount();
                        continue;
                    }
                    if (!(d2 <= d)) continue;
                    stack2.push(new d_node(d2, coverTreeNode2));
                    if (this.m_TreeStats == null) continue;
                    this.m_TreeStats.incrLeafCount();
                }
            }
            stack = stack3;
        }
        NearestNeighbourSearch.NeighborList neighborList = new NearestNeighbourSearch.NeighborList(this, n);
        d = myHeap.peek().distance;
        for (int i = 0; i < stack2.length; ++i) {
            d_node d_node3 = (d_node)stack2.element(i);
            if (!(d_node3.dist <= d)) continue;
            neighborList.insertSorted(d_node3.dist, d_node3.n.p());
        }
        if (neighborList.currentLength() <= 0) {
            throw new Exception("Error: No neighbour found. This cannot happen");
        }
        return neighborList;
    }

    @Override
    public Instances kNearestNeighbours(Instance instance, int n) throws Exception {
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        CoverTree coverTree = new CoverTree();
        Instances instances = new Instances(this.m_Instances, 0);
        instances.add(instance);
        coverTree.setInstances(instances);
        Stack<NearestNeighbourSearch.NeighborList> stack = new Stack<NearestNeighbourSearch.NeighborList>();
        this.batch_nearest_neighbor(n, this.m_Root, coverTree.m_Root, stack);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        instances = new Instances(this.m_Instances, 0);
        NearestNeighbourSearch.NeighborNode neighborNode = stack.element(0).getFirst();
        this.m_DistanceList = new double[stack.element(0).currentLength()];
        int n2 = 0;
        while (neighborNode != null) {
            instances.add(neighborNode.m_Instance);
            this.m_DistanceList[n2] = neighborNode.m_Distance;
            ++n2;
            neighborNode = neighborNode.m_Next;
        }
        return instances;
    }

    @Override
    public Instance nearestNeighbour(Instance instance) throws Exception {
        return this.kNearestNeighbours(instance, 1).instance(0);
    }

    @Override
    public double[] getDistances() throws Exception {
        if (this.m_Instances == null || this.m_DistanceList == null) {
            throw new Exception("The tree has not been supplied with a set of instances or getDistances() has been called before calling kNearestNeighbours().");
        }
        return this.m_DistanceList;
    }

    protected void checkMissing(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instance.numValues(); ++j) {
                if (instance.index(j) == instance.classIndex() || !instance.isMissingSparse(j)) continue;
                throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
            }
        }
    }

    @Override
    public void setInstances(Instances instances) throws Exception {
        super.setInstances(instances);
        this.buildCoverTree(instances);
    }

    @Override
    public void update(Instance instance) throws Exception {
        throw new Exception("BottomUpConstruction method does not allow addition of new Instances.");
    }

    @Override
    public void addInstanceInfo(Instance instance) {
        if (this.m_Instances != null) {
            try {
                this.m_DistanceFunction.update(instance);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.m_Instances == null) {
            throw new IllegalStateException("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
    }

    @Override
    public void setDistanceFunction(DistanceFunction distanceFunction) throws Exception {
        if (!(distanceFunction instanceof EuclideanDistance)) {
            throw new Exception("CoverTree currently only works with EuclideanDistanceFunction.");
        }
        this.m_EuclideanDistance = (EuclideanDistance)distanceFunction;
        this.m_DistanceFunction = this.m_EuclideanDistance;
    }

    public String baseTipText() {
        return "The base for the expansion constant.";
    }

    public double getBase() {
        return this.m_Base;
    }

    public void setBase(double d) {
        this.m_Base = d;
    }

    public double measureTreeSize() {
        return this.m_NumNodes;
    }

    public double measureNumLeaves() {
        return this.m_NumLeaves;
    }

    public double measureMaxDepth() {
        return this.m_MaxDepth;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureMaxDepth");
        if (this.m_Stats != null) {
            Enumeration enumeration = this.m_Stats.enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    @Override
    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureMaxDepth") == 0) {
            return this.measureMaxDepth();
        }
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        if (this.m_Stats != null) {
            return this.m_Stats.getMeasure(string);
        }
        throw new IllegalArgumentException(string + " not supported (KDTree)");
    }

    protected static void print(String string) {
        System.out.print(string);
    }

    protected static void println(String string) {
        System.out.println(string);
    }

    protected static void print(Object object) {
        System.out.print(object);
    }

    protected static void println(Object object) {
        System.out.println(object);
    }

    protected static void print_space(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
    }

    protected static void print(int n, CoverTreeNode coverTreeNode) {
        CoverTree.print_space(n);
        CoverTree.println(coverTreeNode.p());
        if (coverTreeNode.num_children > 0) {
            CoverTree.print_space(n);
            CoverTree.print("scale = " + coverTreeNode.scale + "\n");
            CoverTree.print_space(n);
            CoverTree.print("num children = " + coverTreeNode.num_children + "\n");
            System.out.flush();
            for (int i = 0; i < coverTreeNode.num_children; ++i) {
                CoverTree.print(n + 1, (CoverTreeNode)coverTreeNode.children.element(i));
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: CoverTree <ARFF file>");
            System.exit(-1);
        }
        try {
            Serializable serializable;
            Instances instances = null;
            if (stringArray[0].endsWith(".csv")) {
                serializable = new CSVLoader();
                ((AbstractFileLoader)serializable).setFile(new File(stringArray[0]));
                instances = ((CSVLoader)serializable).getDataSet();
            } else {
                instances = new Instances(new BufferedReader(new FileReader(stringArray[0])));
            }
            serializable = new CoverTree();
            ((CoverTree)serializable).setInstances(instances);
            CoverTree.print("Created data tree:\n");
            CoverTree.print(0, ((CoverTree)serializable).m_Root);
            CoverTree.println("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class d_node {
        double dist;
        CoverTreeNode n;

        public d_node(double d, CoverTreeNode coverTreeNode) {
            this.dist = d;
            this.n = coverTreeNode;
        }
    }

    protected class MyHeapElement {
        public double distance;
        int index = 0;

        public MyHeapElement(double d) {
            this.distance = d;
        }
    }

    protected class MyHeap {
        MyHeapElement[] m_heap = null;
        MyHeapElement[] m_KthNearest = null;
        int m_KthNearestSize = 0;
        int initSize = 10;

        public MyHeap(int n) {
            if (n % 2 == 0) {
                ++n;
            }
            this.m_heap = new MyHeapElement[n + 1];
            this.m_heap[0] = new MyHeapElement(-1.0);
        }

        public int size() {
            return this.m_heap[0].index;
        }

        public MyHeapElement peek() {
            return this.m_heap[1];
        }

        public MyHeapElement get() throws Exception {
            if (this.m_heap[0].index == 0) {
                throw new Exception("No elements present in the heap");
            }
            MyHeapElement myHeapElement = this.m_heap[1];
            this.m_heap[1] = this.m_heap[this.m_heap[0].index];
            --this.m_heap[0].index;
            this.downheap();
            return myHeapElement;
        }

        public void put(double d) throws Exception {
            if (this.m_heap[0].index + 1 > this.m_heap.length - 1) {
                throw new Exception("the number of elements cannot exceed the initially set maximum limit");
            }
            ++this.m_heap[0].index;
            this.m_heap[this.m_heap[0].index] = new MyHeapElement(d);
            this.upheap();
        }

        public void putBySubstitute(double d) throws Exception {
            MyHeapElement myHeapElement = this.get();
            this.put(d);
            if (myHeapElement.distance == this.m_heap[1].distance) {
                this.putKthNearest(myHeapElement.distance);
            } else if (myHeapElement.distance > this.m_heap[1].distance) {
                this.m_KthNearest = null;
                this.m_KthNearestSize = 0;
                this.initSize = 10;
            } else if (myHeapElement.distance < this.m_heap[1].distance) {
                throw new Exception("The substituted element is greater than the head element. put() should have been called in place of putBySubstitute()");
            }
        }

        public int noOfKthNearest() {
            return this.m_KthNearestSize;
        }

        public void putKthNearest(double d) {
            if (this.m_KthNearest == null) {
                this.m_KthNearest = new MyHeapElement[this.initSize];
            }
            if (this.m_KthNearestSize >= this.m_KthNearest.length) {
                this.initSize += this.initSize;
                MyHeapElement[] myHeapElementArray = new MyHeapElement[this.initSize];
                System.arraycopy(this.m_KthNearest, 0, myHeapElementArray, 0, this.m_KthNearest.length);
                this.m_KthNearest = myHeapElementArray;
            }
            this.m_KthNearest[this.m_KthNearestSize++] = new MyHeapElement(d);
        }

        public MyHeapElement getKthNearest() {
            if (this.m_KthNearestSize == 0) {
                return null;
            }
            --this.m_KthNearestSize;
            return this.m_KthNearest[this.m_KthNearestSize];
        }

        protected void upheap() {
            int n = this.m_heap[0].index;
            while (n > 1 && this.m_heap[n].distance > this.m_heap[n / 2].distance) {
                MyHeapElement myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[n / 2];
                this.m_heap[n /= 2] = myHeapElement;
            }
        }

        protected void downheap() {
            int n = 1;
            while (2 * n <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n].distance || 2 * n + 1 <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n + 1].distance) {
                MyHeapElement myHeapElement;
                if (2 * n + 1 <= this.m_heap[0].index) {
                    if (this.m_heap[2 * n].distance > this.m_heap[2 * n + 1].distance) {
                        myHeapElement = this.m_heap[n];
                        this.m_heap[n] = this.m_heap[2 * n];
                        n = 2 * n;
                        this.m_heap[n] = myHeapElement;
                        continue;
                    }
                    myHeapElement = this.m_heap[n];
                    this.m_heap[n] = this.m_heap[2 * n + 1];
                    n = 2 * n + 1;
                    this.m_heap[n] = myHeapElement;
                    continue;
                }
                myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[2 * n];
                n = 2 * n;
                this.m_heap[n] = myHeapElement;
            }
        }

        public int totalSize() {
            return this.size() + this.noOfKthNearest();
        }
    }

    private class DistanceNode {
        Stack<Double> dist;
        Integer idx;

        private DistanceNode() {
        }

        public Instance q() {
            return CoverTree.this.m_Instances.instance(this.idx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CoverTreeNode
    implements Serializable {
        private static final long serialVersionUID = 1808760031169036512L;
        private int nodeid;
        private Integer idx;
        private double max_dist;
        private double parent_dist;
        private Stack<CoverTreeNode> children;
        private int num_children;
        private int scale;

        public CoverTreeNode() {
        }

        public CoverTreeNode(Integer n, double d, double d2, Stack<CoverTreeNode> stack, int n2, int n3) {
            this.idx = n;
            this.max_dist = d;
            this.parent_dist = d2;
            this.children = stack;
            this.num_children = n2;
            this.scale = n3;
        }

        public Instance p() {
            return CoverTree.this.m_Instances.instance(this.idx);
        }

        public boolean isALeaf() {
            return this.num_children == 0;
        }
    }
}

