/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;
import weka.gui.treevisualizer.Colors;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Node;

public class TreeBuild {
    private String m_graphName;
    private Vector m_aNodes;
    private Vector m_aEdges;
    private Vector m_nodes;
    private Vector m_edges;
    private InfoObject m_grObj;
    private InfoObject m_noObj;
    private InfoObject m_edObj;
    private boolean m_digraph;
    private StreamTokenizer m_st;
    private Hashtable m_colorTable = new Hashtable();

    public TreeBuild() {
        Colors colors = new Colors();
        for (int i = 0; i < colors.m_cols.length; ++i) {
            this.m_colorTable.put(colors.m_cols[i].m_name, colors.m_cols[i].m_col);
        }
    }

    public Node create(Reader reader) {
        this.m_nodes = new Vector(50, 50);
        this.m_edges = new Vector(50, 50);
        this.m_grObj = new InfoObject("graph");
        this.m_noObj = new InfoObject("node");
        this.m_edObj = new InfoObject("edge");
        this.m_digraph = false;
        this.m_st = new StreamTokenizer(new BufferedReader(reader));
        this.setSyntax();
        this.graph();
        Node node = this.generateStructures();
        return node;
    }

    private Node generateStructures() {
        int n;
        Color color;
        Color color2;
        int n2;
        Integer n3;
        Integer n4;
        String string;
        String string2;
        InfoObject infoObject;
        int n5;
        this.m_aNodes = new Vector(50, 50);
        this.m_aEdges = new Vector(50, 50);
        for (n5 = 0; n5 < this.m_nodes.size(); ++n5) {
            infoObject = (InfoObject)this.m_nodes.elementAt(n5);
            string2 = infoObject.m_id;
            string = infoObject.m_label == null ? (this.m_noObj.m_label == null ? "" : this.m_noObj.m_label) : infoObject.m_label;
            n4 = infoObject.m_shape == null ? (this.m_noObj.m_shape == null ? new Integer(2) : this.getShape(this.m_noObj.m_shape)) : this.getShape(infoObject.m_shape);
            if (n4 == null) {
                n4 = new Integer(2);
            }
            n3 = infoObject.m_style == null ? (this.m_noObj.m_style == null ? new Integer(1) : this.getStyle(this.m_noObj.m_style)) : this.getStyle(infoObject.m_style);
            if (n3 == null) {
                n3 = new Integer(1);
            }
            n2 = infoObject.m_fontSize == null ? (this.m_noObj.m_fontSize == null ? 12 : Integer.valueOf(this.m_noObj.m_fontSize)) : Integer.valueOf(infoObject.m_fontSize);
            color2 = infoObject.m_fontColor == null ? (this.m_noObj.m_fontColor == null ? Color.black : (Color)this.m_colorTable.get(this.m_noObj.m_fontColor.toLowerCase())) : (Color)this.m_colorTable.get(infoObject.m_fontColor.toLowerCase());
            if (color2 == null) {
                color2 = Color.black;
            }
            color = infoObject.m_color == null ? (this.m_noObj.m_color == null ? Color.gray : (Color)this.m_colorTable.get(this.m_noObj.m_color.toLowerCase())) : (Color)this.m_colorTable.get(infoObject.m_color.toLowerCase());
            if (color == null) {
                color = Color.gray;
            }
            this.m_aNodes.addElement(new Node(string, string2, n3, n4, color, infoObject.m_data));
        }
        for (n5 = 0; n5 < this.m_edges.size(); ++n5) {
            infoObject = (InfoObject)this.m_edges.elementAt(n5);
            string2 = infoObject.m_id;
            string = infoObject.m_label == null ? (this.m_noObj.m_label == null ? "" : this.m_noObj.m_label) : infoObject.m_label;
            n4 = infoObject.m_shape == null ? (this.m_noObj.m_shape == null ? new Integer(2) : this.getShape(this.m_noObj.m_shape)) : this.getShape(infoObject.m_shape);
            if (n4 == null) {
                n4 = new Integer(2);
            }
            n3 = infoObject.m_style == null ? (this.m_noObj.m_style == null ? new Integer(1) : this.getStyle(this.m_noObj.m_style)) : this.getStyle(infoObject.m_style);
            if (n3 == null) {
                n3 = new Integer(1);
            }
            n2 = infoObject.m_fontSize == null ? (this.m_noObj.m_fontSize == null ? 12 : Integer.valueOf(this.m_noObj.m_fontSize)) : Integer.valueOf(infoObject.m_fontSize);
            color2 = infoObject.m_fontColor == null ? (this.m_noObj.m_fontColor == null ? Color.black : (Color)this.m_colorTable.get(this.m_noObj.m_fontColor.toLowerCase())) : (Color)this.m_colorTable.get(infoObject.m_fontColor.toLowerCase());
            if (color2 == null) {
                color2 = Color.black;
            }
            color = infoObject.m_color == null ? (this.m_noObj.m_color == null ? Color.white : (Color)this.m_colorTable.get(this.m_noObj.m_color.toLowerCase())) : (Color)this.m_colorTable.get(infoObject.m_color.toLowerCase());
            if (color == null) {
                color = Color.white;
            }
            this.m_aEdges.addElement(new Edge(string, infoObject.m_source, infoObject.m_target));
        }
        Node node = null;
        Node node2 = null;
        for (n = 0; n < this.m_aEdges.size(); ++n) {
            n5 = 0;
            boolean bl = false;
            Edge edge = (Edge)this.m_aEdges.elementAt(n);
            for (int i = 0; i < this.m_aNodes.size(); ++i) {
                Node node3 = (Node)this.m_aNodes.elementAt(i);
                if (node3.getRefer().equals(edge.getRtarget())) {
                    n5 = 1;
                    node2 = node3;
                }
                if (node3.getRefer().equals(edge.getRsource())) {
                    bl = true;
                    node = node3;
                }
                if (n5 == 1 && bl) break;
            }
            if (node2 != node) {
                edge.setTarget(node2);
                edge.setSource(node);
                continue;
            }
            System.out.println("logic error");
        }
        for (n = 0; n < this.m_aNodes.size(); ++n) {
            if (((Node)this.m_aNodes.elementAt(n)).getParent(0) != null) continue;
            node = (Node)this.m_aNodes.elementAt(n);
        }
        return node;
    }

    private Integer getShape(String string) {
        if (string.equalsIgnoreCase("box") || string.equalsIgnoreCase("rectangle")) {
            return new Integer(1);
        }
        if (string.equalsIgnoreCase("oval")) {
            return new Integer(2);
        }
        if (string.equalsIgnoreCase("diamond")) {
            return new Integer(3);
        }
        return null;
    }

    private Integer getStyle(String string) {
        if (string.equalsIgnoreCase("filled")) {
            return new Integer(1);
        }
        return null;
    }

    private void setSyntax() {
        this.m_st.resetSyntax();
        this.m_st.eolIsSignificant(false);
        this.m_st.slashStarComments(true);
        this.m_st.slashSlashComments(true);
        this.m_st.whitespaceChars(0, 32);
        this.m_st.wordChars(33, 255);
        this.m_st.ordinaryChar(91);
        this.m_st.ordinaryChar(93);
        this.m_st.ordinaryChar(123);
        this.m_st.ordinaryChar(125);
        this.m_st.ordinaryChar(45);
        this.m_st.ordinaryChar(62);
        this.m_st.ordinaryChar(47);
        this.m_st.ordinaryChar(42);
        this.m_st.quoteChar(34);
        this.m_st.whitespaceChars(59, 59);
        this.m_st.ordinaryChar(61);
    }

    private void alterSyntax() {
        this.m_st.resetSyntax();
        this.m_st.wordChars(0, 255);
        this.m_st.slashStarComments(false);
        this.m_st.slashSlashComments(false);
        this.m_st.ordinaryChar(10);
        this.m_st.ordinaryChar(13);
    }

    private void nextToken(String string) {
        int n = 0;
        try {
            n = this.m_st.nextToken();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n == -1) {
            System.out.println("eof , " + string);
        } else if (n == -2) {
            System.out.println("got a number , " + string);
        }
    }

    private void graph() {
        boolean bl = true;
        this.nextToken("expected 'digraph'");
        if (this.m_st.sval.equalsIgnoreCase("digraph")) {
            this.m_digraph = true;
        } else {
            System.out.println("expected 'digraph'");
        }
        this.nextToken("expected a Graph Name");
        if (this.m_st.sval != null) {
            this.m_graphName = this.m_st.sval;
        } else {
            System.out.println("expected a Graph Name");
        }
        this.nextToken("expected '{'");
        if (this.m_st.ttype == 123) {
            this.stmtList();
        } else {
            System.out.println("expected '{'");
        }
    }

    private void stmtList() {
        boolean bl = true;
        while (bl) {
            this.nextToken("expects a STMT_LIST item or '}'");
            if (this.m_st.ttype == 125) {
                bl = false;
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("graph") || this.m_st.sval.equalsIgnoreCase("node") || this.m_st.sval.equalsIgnoreCase("edge")) {
                this.m_st.pushBack();
                this.attrStmt();
                continue;
            }
            if (this.m_st.sval != null) {
                this.nodeId(this.m_st.sval, 0);
                continue;
            }
            System.out.println("expects a STMT_LIST item or '}'");
        }
    }

    private void attrStmt() {
        this.nextToken("expected 'graph' or 'node' or 'edge'");
        if (this.m_st.sval.equalsIgnoreCase("graph")) {
            this.nextToken("expected a '['");
            if (this.m_st.ttype == 91) {
                this.attrList(this.m_grObj);
            } else {
                System.out.println("expected a '['");
            }
        } else if (this.m_st.sval.equalsIgnoreCase("node")) {
            this.nextToken("expected a '['");
            if (this.m_st.ttype == 91) {
                this.attrList(this.m_noObj);
            } else {
                System.out.println("expected a '['");
            }
        } else if (this.m_st.sval.equalsIgnoreCase("edge")) {
            this.nextToken("expected a '['");
            if (this.m_st.ttype == 91) {
                this.attrList(this.m_edObj);
            } else {
                System.out.println("expected a '['");
            }
        } else {
            System.out.println("expected 'graph' or 'node' or 'edge'");
        }
    }

    private void nodeId(String string, int n) {
        this.nextToken("error occurred in node_id");
        if (this.m_st.ttype == 125) {
            if (n == 0) {
                this.m_nodes.addElement(new InfoObject(string));
            }
            this.m_st.pushBack();
        } else if (this.m_st.ttype == 45) {
            this.nextToken("error occurred checking for an edge");
            if (this.m_st.ttype == 62) {
                this.edgeStmt(string);
            } else {
                System.out.println("error occurred checking for an edge");
            }
        } else if (this.m_st.ttype == 91) {
            if (n == 0) {
                this.m_nodes.addElement(new InfoObject(string));
                this.attrList((InfoObject)this.m_nodes.lastElement());
            } else {
                this.attrList((InfoObject)this.m_edges.lastElement());
            }
        } else if (this.m_st.sval != null) {
            if (n == 0) {
                this.m_nodes.addElement(new InfoObject(string));
            }
            this.m_st.pushBack();
        } else {
            System.out.println("error occurred in node_id");
        }
    }

    private void edgeStmt(String string) {
        this.nextToken("error getting target of edge");
        if (this.m_st.sval != null) {
            this.m_edges.addElement(new InfoObject("an edge ,no id"));
            ((InfoObject)this.m_edges.lastElement()).m_source = string;
            ((InfoObject)this.m_edges.lastElement()).m_target = this.m_st.sval;
            this.nodeId(this.m_st.sval, 1);
        } else {
            System.out.println("error getting target of edge");
        }
    }

    private void attrList(InfoObject infoObject) {
        boolean bl = true;
        while (bl) {
            this.nextToken("error in attr_list");
            if (this.m_st.ttype == 93) {
                bl = false;
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("color")) {
                this.nextToken("error getting color");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting color");
                    if (this.m_st.sval != null) {
                        infoObject.m_color = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting color");
                    continue;
                }
                System.out.println("error getting color");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("fontcolor")) {
                this.nextToken("error getting font color");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting font color");
                    if (this.m_st.sval != null) {
                        infoObject.m_fontColor = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting font color");
                    continue;
                }
                System.out.println("error getting font color");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("fontsize")) {
                this.nextToken("error getting font size");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting font size");
                    if (this.m_st.sval != null) {
                        infoObject.m_fontSize = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting font size");
                    continue;
                }
                System.out.println("error getting font size");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("label")) {
                this.nextToken("error getting label");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting label");
                    if (this.m_st.sval != null) {
                        infoObject.m_label = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting label");
                    continue;
                }
                System.out.println("error getting label");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("shape")) {
                this.nextToken("error getting shape");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting shape");
                    if (this.m_st.sval != null) {
                        infoObject.m_shape = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting shape");
                    continue;
                }
                System.out.println("error getting shape");
                continue;
            }
            if (this.m_st.sval.equalsIgnoreCase("style")) {
                this.nextToken("error getting style");
                if (this.m_st.ttype == 61) {
                    this.nextToken("error getting style");
                    if (this.m_st.sval != null) {
                        infoObject.m_style = this.m_st.sval;
                        continue;
                    }
                    System.out.println("error getting style");
                    continue;
                }
                System.out.println("error getting style");
                continue;
            }
            if (!this.m_st.sval.equalsIgnoreCase("data")) continue;
            this.nextToken("error getting data");
            if (this.m_st.ttype == 61) {
                this.alterSyntax();
                infoObject.m_data = new String("");
                while (true) {
                    this.nextToken("error getting data");
                    if (this.m_st.sval != null && infoObject.m_data != null && this.m_st.sval.equals(",")) break;
                    if (this.m_st.sval != null) {
                        infoObject.m_data = infoObject.m_data.concat(this.m_st.sval);
                        continue;
                    }
                    if (this.m_st.ttype == 13) {
                        infoObject.m_data = infoObject.m_data.concat("\r");
                        continue;
                    }
                    if (this.m_st.ttype == 10) {
                        infoObject.m_data = infoObject.m_data.concat("\n");
                        continue;
                    }
                    System.out.println("error getting data");
                }
                this.setSyntax();
                continue;
            }
            System.out.println("error getting data");
        }
    }

    private class InfoObject {
        public String m_id;
        public String m_color;
        public String m_fontColor;
        public String m_fontSize;
        public String m_label;
        public String m_shape;
        public String m_style;
        public String m_source;
        public String m_target;
        public String m_data;

        public InfoObject(String string) {
            this.m_id = string;
            this.m_color = null;
            this.m_fontColor = null;
            this.m_fontSize = null;
            this.m_label = null;
            this.m_shape = null;
            this.m_style = null;
            this.m_source = null;
            this.m_target = null;
            this.m_data = null;
        }
    }
}

