/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.io.File;
import javax.swing.JComponent;

public abstract class JComponentWriter {
    protected static final boolean DEBUG = false;
    private JComponent component;
    private File outputFile;
    protected double m_xScale;
    protected double m_yScale;
    protected boolean m_ScalingEnabled;
    protected boolean m_UseCustomDimensions;
    protected int m_CustomWidth;
    protected int m_CustomHeight;

    public JComponentWriter() {
        this(null);
    }

    public JComponentWriter(JComponent jComponent) {
        this(jComponent, null);
    }

    public JComponentWriter(JComponent jComponent, File file) {
        this.component = jComponent;
        this.outputFile = file;
        this.initialize();
    }

    protected void initialize() {
        this.m_xScale = 1.0;
        this.m_yScale = 1.0;
        this.m_ScalingEnabled = true;
        this.m_UseCustomDimensions = false;
        this.m_CustomWidth = -1;
        this.m_CustomHeight = -1;
    }

    public void setComponent(JComponent jComponent) {
        this.component = jComponent;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setFile(File file) {
        this.outputFile = file;
    }

    public File getFile() {
        return this.outputFile;
    }

    public abstract String getDescription();

    public abstract String getExtension();

    public boolean getScalingEnabled() {
        return this.m_ScalingEnabled;
    }

    public void setScalingEnabled(boolean bl) {
        this.m_ScalingEnabled = bl;
    }

    public void setScale(double d, double d2) {
        if (this.getScalingEnabled()) {
            this.m_xScale = d;
            this.m_yScale = d2;
        } else {
            this.m_xScale = 1.0;
            this.m_yScale = 1.0;
        }
    }

    public double getXScale() {
        return this.m_xScale;
    }

    public double getYScale() {
        return this.m_xScale;
    }

    public boolean getUseCustomDimensions() {
        return this.m_UseCustomDimensions;
    }

    public void setUseCustomDimensions(boolean bl) {
        this.m_UseCustomDimensions = bl;
    }

    public void setCustomWidth(int n) {
        this.m_CustomWidth = n;
    }

    public int getCustomWidth() {
        return this.m_CustomWidth;
    }

    public void setCustomHeight(int n) {
        this.m_CustomHeight = n;
    }

    public int getCustomHeight() {
        return this.m_CustomHeight;
    }

    protected abstract void generateOutput() throws Exception;

    public void toOutput() throws Exception {
        if (this.getFile() == null) {
            throw new Exception("The file is not set!");
        }
        if (this.getComponent() == null) {
            throw new Exception("The component is not set!");
        }
        int n = this.getComponent().getWidth();
        int n2 = this.getComponent().getHeight();
        if (this.getUseCustomDimensions()) {
            this.getComponent().setSize(this.getCustomWidth(), this.getCustomHeight());
        }
        this.generateOutput();
        if (this.getUseCustomDimensions()) {
            this.getComponent().setSize(n, n2);
        }
    }

    public static void toOutput(JComponentWriter jComponentWriter, JComponent jComponent, File file) throws Exception {
        JComponentWriter.toOutput(jComponentWriter, jComponent, file, -1, -1);
    }

    public static void toOutput(JComponentWriter jComponentWriter, JComponent jComponent, File file, int n, int n2) throws Exception {
        jComponentWriter.setComponent(jComponent);
        jComponentWriter.setFile(file);
        if (n != -1 && n2 != -1) {
            jComponentWriter.setUseCustomDimensions(true);
            jComponentWriter.setCustomWidth(n);
            jComponentWriter.setCustomHeight(n2);
        }
        jComponentWriter.toOutput();
    }
}

