/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.RandomTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomForest
extends AbstractClassifier
implements OptionHandler,
Randomizable,
WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 4216839470751428698L;
    protected int m_numTrees = 10;
    protected int m_numFeatures = 0;
    protected int m_randomSeed = 1;
    protected int m_KValue = 0;
    protected Bagging m_bagger = null;
    protected int m_MaxDepth = 0;

    public String globalInfo() {
        return "Class for constructing a forest of random trees.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Random Forests");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "45");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "5-32");
        return result;
    }

    public String numTreesTipText() {
        return "The number of trees to be generated.";
    }

    public int getNumTrees() {
        return this.m_numTrees;
    }

    public void setNumTrees(int newNumTrees) {
        this.m_numTrees = newNumTrees;
    }

    public String numFeaturesTipText() {
        return "The number of attributes to be used in random selection (see RandomTree).";
    }

    public int getNumFeatures() {
        return this.m_numFeatures;
    }

    public void setNumFeatures(int newNumFeatures) {
        this.m_numFeatures = newNumFeatures;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int seed) {
        this.m_randomSeed = seed;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String maxDepthTipText() {
        return "The maximum depth of the trees, 0 for unlimited.";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public void setMaxDepth(int value) {
        this.m_MaxDepth = value;
    }

    public double measureOutOfBagError() {
        if (this.m_bagger != null) {
            return this.m_bagger.measureOutOfBagError();
        }
        return Double.NaN;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureOutOfBagError");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (RandomForest)");
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tNumber of trees to build.", "I", 1, "-I <number of trees>"));
        newVector.addElement(new Option("\tNumber of features to consider (<1=int(logM+1)).", "K", 1, "-K <number of features>"));
        newVector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S"));
        newVector.addElement(new Option("\tThe maximum depth of the trees, 0 for unlimited.\n\t(default 0)", "depth", 1, "-depth <num>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-I");
        result.add("" + this.getNumTrees());
        result.add("-K");
        result.add("" + this.getNumFeatures());
        result.add("-S");
        result.add("" + this.getSeed());
        if (this.getMaxDepth() > 0) {
            result.add("-depth");
            result.add("" + this.getMaxDepth());
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('I', options);
        this.m_numTrees = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 10;
        tmpStr = Utils.getOption('K', options);
        this.m_numFeatures = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 0;
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        tmpStr = Utils.getOption("depth", options);
        if (tmpStr.length() != 0) {
            this.setMaxDepth(Integer.parseInt(tmpStr));
        } else {
            this.setMaxDepth(0);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    public Capabilities getCapabilities() {
        return new RandomTree().getCapabilities();
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_bagger = new Bagging();
        RandomTree rTree = new RandomTree();
        this.m_KValue = this.m_numFeatures;
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2(data.numAttributes()) + 1;
        }
        rTree.setKValue(this.m_KValue);
        rTree.setMaxDepth(this.getMaxDepth());
        this.m_bagger.setClassifier(rTree);
        this.m_bagger.setSeed(this.m_randomSeed);
        this.m_bagger.setNumIterations(this.m_numTrees);
        this.m_bagger.setCalcOutOfBag(true);
        this.m_bagger.buildClassifier(data);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_bagger.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_bagger == null) {
            return "Random forest not built yet";
        }
        return "Random forest of " + this.m_numTrees + " trees, each constructed while considering " + this.m_KValue + " random feature" + (this.m_KValue == 1 ? "" : "s") + ".\n" + "Out of bag error: " + Utils.doubleToString(this.m_bagger.measureOutOfBagError(), 4) + "\n" + (this.getMaxDepth() > 0 ? "Max. depth of trees: " + this.getMaxDepth() + "\n" : "") + "\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] argv) {
        RandomForest.runClassifier(new RandomForest(), argv);
    }
}

