/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.StreamTokenizerUtils;

public class CSVLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter,
OptionHandler {
    private static final long serialVersionUID = -1300595850715808438L;
    public static String FILE_EXTENSION = ".csv";
    protected transient BufferedReader m_sourceReader;
    protected transient StreamTokenizer m_st;
    protected transient File m_tempFile;
    protected transient PrintWriter m_dataDumper;
    protected String m_FieldSeparator = ",";
    protected String m_MissingValue = "?";
    protected Range m_NominalAttributes = new Range();
    protected List<String> m_nominalLabelSpecs = new ArrayList<String>();
    protected Range m_StringAttributes = new Range();
    protected Range m_dateAttributes = new Range();
    protected String m_dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    protected SimpleDateFormat m_formatter;
    protected boolean m_noHeaderRow = false;
    protected String m_Enclosures = "\",'";
    protected List<String> m_rowBuffer;
    protected int m_bufferSize = 100;
    protected Map<Integer, LinkedHashSet<String>> m_nominalVals;
    protected ArffLoader.ArffReader m_incrementalReader;
    private int m_numBufferedRows;
    protected ArrayList<Object> m_current;
    protected TYPE[] m_types;

    public String globalInfo() {
        return "Reads a source that is in comma separated format (the default). One can also change the column separator from comma to tab or another character, specify string enclosures, specify whether aheader row is present or not and specify which attributes are to beforced to be nominal or date. Can operate in batch or incremental mode. In batch mode, a buffer is used to process a fixed number of rows in memory at any one time and the data is dumped to a temporary file. This allows the legal values for nominal attributes to be automatically determined. The final ARFF file is produced in a second pass over the temporary file using the structure determined on the first pass. In incremental mode, the first buffer full of rows is used to determine the structure automatically. Following this all rows are read and output incrementally. An error will occur if a row containing nominal values not seen in the initial buffer is encountered. In this case, the size of the initial buffer can be increased, or the user can explicitly provide the legal values of all nominal attributes using the -L (setNominalLabelSpecs) option.";
    }

    public CSVLoader() {
        this.setRetrieval(0);
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    public String getFileDescription() {
        return "CSV data files";
    }

    public String getRevision() {
        return "$Revisoon: $";
    }

    public String noHeaderRowPresentTipText() {
        return "First row of data does not contain attribute names";
    }

    public void setNoHeaderRowPresent(boolean b) {
        this.m_noHeaderRow = b;
    }

    public boolean getNoHeaderRowPresent() {
        return this.m_noHeaderRow;
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '?'.";
    }

    public void setStringAttributes(String value) {
        this.m_StringAttributes.setRanges(value);
    }

    public String getStringAttributes() {
        return this.m_StringAttributes.getRanges();
    }

    public String stringAttributesTipText() {
        return "The range of attributes to force to be of type STRING, example ranges: 'first-last', '1,4,7-14,50-last'.";
    }

    public void setNominalAttributes(String value) {
        this.m_NominalAttributes.setRanges(value);
    }

    public String getNominalAttributes() {
        return this.m_NominalAttributes.getRanges();
    }

    public String nominalAttributesTipText() {
        return "The range of attributes to force to be of type NOMINAL, example ranges: 'first-last', '1,4,7-14,50-last'.";
    }

    public void setDateFormat(String value) {
        this.m_dateFormat = value;
        this.m_formatter = null;
    }

    public String getDateFormat() {
        return this.m_dateFormat;
    }

    public String dateFormatTipText() {
        return "The format to use for parsing date values.";
    }

    public void setDateAttributes(String value) {
        this.m_dateAttributes.setRanges(value);
    }

    public String getDateAttributes() {
        return this.m_dateAttributes.getRanges();
    }

    public String dateAttributesTipText() {
        return "The range of attributes to force to type DATE, example ranges: 'first-last', '1,4,7-14, 50-last'.";
    }

    public String enclosureCharactersTipText() {
        return "The characters to use as enclosures for strings. E.g. \",'";
    }

    public void setEnclosureCharacters(String enclosure) {
        this.m_Enclosures = enclosure;
    }

    public String getEnclosureCharacters() {
        return this.m_Enclosures;
    }

    public void setFieldSeparator(String value) {
        this.m_FieldSeparator = Utils.unbackQuoteChars(value);
        if (this.m_FieldSeparator.length() != 1) {
            this.m_FieldSeparator = ",";
            System.err.println("Field separator can only be a single character (exception being '\t'), defaulting back to '" + this.m_FieldSeparator + "'!");
        }
    }

    public String getFieldSeparator() {
        return Utils.backQuoteChars(this.m_FieldSeparator);
    }

    public String fieldSeparatorTipText() {
        return "The character to use as separator for the columns/fields (use '\\t' for TAB).";
    }

    public void setBufferSize(int buff) {
        this.m_bufferSize = buff;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public String bufferSizeTipText() {
        return "The number of rows to process in memory at any one time.";
    }

    public void setNominalLabelSpecs(Object[] specs) {
        this.m_nominalLabelSpecs.clear();
        for (Object s : specs) {
            this.m_nominalLabelSpecs.add(s.toString());
        }
    }

    public Object[] getNominalLabelSpecs() {
        return this.m_nominalLabelSpecs.toArray(new String[0]);
    }

    public String nominalLabelSpecsTipText() {
        return "Optional specification of legal labels for nominal attributes. May be specified multiple times. Batch mode can determine this automatically (and so can incremental mode if the first in memory buffer load of instances contains an example of each legal value). The spec contains two parts separated by a \":\". The first part can be a range of attribute indexes or a comma-separated list off attruibute names; the second part is a comma-separated list of labels. E.g \"1,2,4-6:red,green,blue\" or \"att1,att2:red,green,blue\"";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tNo header row present in the data.", "H", 0, "-H"));
        result.add(new Option("\tThe range of attributes to force type to be NOMINAL.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "N", 1, "-N <range>"));
        result.add(new Option("\tOptional specification of legal labels for nominal\n\tattributes. May be specified multiple times.\n\tBatch mode can determine this\n\tautomatically (and so can incremental mode if\n\tthe first in memory buffer load of instances\n\tcontains an example of each legal value). The\n\tspec contains two parts separated by a \":\". The\n\tfirst part can be a range of attribute indexes or\n\ta comma-separated list off attruibute names; the\n\tsecond part is a comma-separated list of labels. E.g\n\t\"1,2,4-6:red,green,blue\" or \"att1,att2:red,green,blue\"", "L", 1, "-L <nominal label spec>"));
        result.add(new Option("\tThe range of attribute to force type to be STRING.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "S", 1, "-S <range>"));
        result.add(new Option("\tThe range of attribute to force type to be DATE.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "D", 1, "-D <range>"));
        result.add(new Option("\tThe date formatting string to use to parse date values.\n\t(default: \"yyyy-MM-dd'T'HH:mm:ss\")", "format", 1, "-format <date format>"));
        result.add(new Option("\tThe string representing a missing value.\n\t(default: ?)", "M", 1, "-M <str>"));
        result.addElement(new Option("\tThe field separator to be used.\n\t'\\t' can be used as well.\n\t(default: ',')", "F", 1, "-F <separator>"));
        result.addElement(new Option("\tThe enclosure character(s) to use for strings.\n\tSpecify as a comma separated list (e.g. \",' (default: \",')", "E", 1, "-E <enclosures>"));
        result.add(new Option("\tThe size of the in memory buffer (in rows).\n\t(default: 100)", "B", 1, "-B <num>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setNoHeaderRowPresent(Utils.getFlag('H', options));
        String tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNominalAttributes(tmpStr);
        } else {
            this.setNominalAttributes("");
        }
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setStringAttributes(tmpStr);
        } else {
            this.setStringAttributes("");
        }
        tmpStr = Utils.getOption('D', options);
        if (tmpStr.length() > 0) {
            this.setDateAttributes(tmpStr);
        }
        if ((tmpStr = Utils.getOption("format", options)).length() > 0) {
            this.setDateFormat(tmpStr);
        }
        if ((tmpStr = Utils.getOption('M', options)).length() != 0) {
            this.setMissingValue(tmpStr);
        } else {
            this.setMissingValue("?");
        }
        tmpStr = Utils.getOption('F', options);
        if (tmpStr.length() != 0) {
            this.setFieldSeparator(tmpStr);
        } else {
            this.setFieldSeparator(",");
        }
        tmpStr = Utils.getOption('B', options);
        if (tmpStr.length() > 0) {
            int buff = Integer.parseInt(tmpStr);
            if (buff < 1) {
                throw new Exception("Buffer size must be >= 1");
            }
            this.setBufferSize(buff);
        }
        if ((tmpStr = Utils.getOption("E", options)).length() > 0) {
            this.setEnclosureCharacters(tmpStr);
        }
        while ((tmpStr = Utils.getOption('L', options)).length() != 0) {
            this.m_nominalLabelSpecs.add(tmpStr);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getNominalAttributes().length() > 0) {
            result.add("-N");
            result.add(this.getNominalAttributes());
        }
        if (this.getStringAttributes().length() > 0) {
            result.add("-S");
            result.add(this.getStringAttributes());
        }
        if (this.getDateAttributes().length() > 0) {
            result.add("-D");
            result.add(this.getDateAttributes());
            result.add("-format");
            result.add(this.getDateFormat());
        }
        result.add("-M");
        result.add(this.getMissingValue());
        result.add("-B");
        result.add("" + this.getBufferSize());
        result.add("-E");
        result.add(this.getEnclosureCharacters());
        result.add("-F");
        result.add(this.getFieldSeparator());
        for (String spec : this.m_nominalLabelSpecs) {
            result.add("-L");
            result.add(spec);
        }
        return result.toArray(new String[result.size()]);
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        this.m_structure = structure;
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting instances in both incremental and batch modes");
        }
        this.setRetrieval(2);
        if (this.m_dataDumper != null) {
            this.m_dataDumper.close();
            this.m_dataDumper = null;
        }
        if (this.m_rowBuffer.size() > 0 && this.m_incrementalReader == null) {
            StringBuilder tempB = new StringBuilder();
            for (String r : this.m_rowBuffer) {
                tempB.append(r).append("\n");
            }
            this.m_numBufferedRows = this.m_rowBuffer.size();
            BufferedReader batchReader = new BufferedReader(new StringReader(tempB.toString()));
            this.m_incrementalReader = new ArffLoader.ArffReader(batchReader, this.m_structure, 0, 0);
            this.m_rowBuffer.clear();
        }
        if (this.m_numBufferedRows == 0) {
            this.m_numBufferedRows = -1;
            this.m_st = new StreamTokenizer(this.m_sourceReader);
            this.initTokenizer(this.m_st);
            this.m_st.ordinaryChar(this.m_FieldSeparator.charAt(0));
            this.m_incrementalReader = null;
        }
        Instance current = null;
        if (this.m_sourceReader != null) {
            if (this.m_incrementalReader != null) {
                current = this.m_incrementalReader.readInstance(this.m_structure);
            } else if (this.getInstance(this.m_st) != null) {
                current = this.makeInstance();
            }
            if (current == null) {
                // empty if block
            }
            if (this.m_numBufferedRows > 0) {
                --this.m_numBufferedRows;
            }
        }
        if (this.m_sourceReader != null && current == null) {
            try {
                this.m_sourceReader.close();
                this.m_sourceReader = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return current;
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        while (this.readData(true)) {
        }
        this.m_dataDumper.flush();
        this.m_dataDumper.close();
        this.makeStructure();
        BufferedReader sr = new BufferedReader(new FileReader(this.m_tempFile));
        ArffLoader.ArffReader initialArff = new ArffLoader.ArffReader((Reader)sr, this.m_structure, 0);
        Instances initialInsts = initialArff.getData();
        ((Reader)sr).close();
        initialArff = null;
        return initialInsts;
    }

    private boolean readData(boolean dump) throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        boolean finished = false;
        boolean moreDataToRead = false;
        do {
            String checked;
            if ((checked = this.getInstance(this.m_st)) == null) {
                return false;
            }
            if (dump) {
                this.dumpRow(checked);
            }
            this.m_rowBuffer.add(checked);
            if (this.m_rowBuffer.size() != this.m_bufferSize) continue;
            finished = true;
            if (this.getRetrieval() != 1) continue;
            this.m_rowBuffer.clear();
        } while (!finished);
        return true;
    }

    public void setSource(InputStream input) throws IOException {
        this.m_structure = null;
        this.m_sourceFile = null;
        this.m_File = null;
        this.m_sourceReader = new BufferedReader(new InputStreamReader(input));
    }

    public void setSource(File file) throws IOException {
        super.setSource(file);
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            this.readHeader();
        }
        return this.m_structure;
    }

    protected Instance makeInstance() throws IOException {
        if (this.m_current == null) {
            return null;
        }
        double[] vals = new double[this.m_structure.numAttributes()];
        for (int i = 0; i < this.m_structure.numAttributes(); ++i) {
            Object val = this.m_current.get(i);
            if (val.toString().equals("?")) {
                vals[i] = Utils.missingValue();
                continue;
            }
            if (this.m_structure.attribute(i).isString()) {
                vals[i] = 0.0;
                this.m_structure.attribute(i).setStringValue(Utils.unquote(val.toString()));
                continue;
            }
            if (this.m_structure.attribute(i).isDate()) {
                String format = this.m_structure.attribute(i).getDateFormat();
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                try {
                    vals[i] = sdf.parse(val.toString()).getTime();
                    continue;
                }
                catch (ParseException e) {
                    throw new IOException("Unable to parse date value " + val.toString() + " using date format " + format + " for date attribute " + this.m_structure.attribute(i));
                }
            }
            if (this.m_structure.attribute(i).isNumeric()) {
                try {
                    Double v = Double.parseDouble(val.toString());
                    vals[i] = v;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Was expecting a number for attribute " + this.m_structure.attribute(i).name() + " but read " + val.toString() + " instead.");
                }
            }
            double index = this.m_structure.attribute(i).indexOfValue(Utils.unquote(val.toString()));
            if (index < 0.0) {
                throw new IOException("Read unknown nominal value " + val.toString() + "for attribute " + this.m_structure.attribute(i).name());
            }
            vals[i] = index;
        }
        DenseInstance inst = new DenseInstance(1.0, vals);
        inst.setDataset(this.m_structure);
        return inst;
    }

    protected void makeStructure() {
        ArrayList<Attribute> attribs = new ArrayList<Attribute>();
        for (int i = 0; i < this.m_types.length; ++i) {
            if (this.m_types[i] == TYPE.STRING || this.m_types[i] == TYPE.UNDETERMINED) {
                attribs.add(new Attribute(this.m_structure.attribute(i).name(), (List<String>)null));
                continue;
            }
            if (this.m_types[i] == TYPE.NUMERIC) {
                attribs.add(new Attribute(this.m_structure.attribute(i).name()));
                continue;
            }
            if (this.m_types[i] == TYPE.NOMINAL) {
                LinkedHashSet<String> vals = this.m_nominalVals.get(i);
                ArrayList<String> theVals = new ArrayList<String>();
                if (vals.size() > 0) {
                    for (String v : vals) {
                        theVals.add(v);
                    }
                } else {
                    theVals.add("*unknown*");
                }
                attribs.add(new Attribute(this.m_structure.attribute(i).name(), theVals));
                continue;
            }
            attribs.add(new Attribute(this.m_structure.attribute(i).name(), this.m_dateFormat));
        }
        this.m_structure = new Instances(this.m_structure.relationName(), attribs, 0);
    }

    private void readHeader() throws IOException {
        this.m_incrementalReader = null;
        this.m_current = new ArrayList();
        this.openTempFiles();
        this.m_rowBuffer = new ArrayList<String>();
        String firstRow = this.m_sourceReader.readLine();
        if (firstRow == null) {
            throw new IOException("No data in the file!");
        }
        if (this.m_noHeaderRow) {
            this.m_rowBuffer.add(firstRow);
        }
        ArrayList<Attribute> attribNames = new ArrayList<Attribute>();
        StringReader sr = new StringReader(firstRow + "\n");
        this.m_st = new StreamTokenizer(sr);
        this.initTokenizer(this.m_st);
        this.m_st.ordinaryChar(this.m_FieldSeparator.charAt(0));
        int attNum = 1;
        StreamTokenizerUtils.getFirstToken(this.m_st);
        if (this.m_st.ttype == -1) {
            StreamTokenizerUtils.errms(this.m_st, "premature end of file");
        }
        boolean first = true;
        while (this.m_st.ttype != 10 && this.m_st.ttype != -1) {
            boolean wasSep;
            if (!first) {
                StreamTokenizerUtils.getToken(this.m_st);
            }
            if (this.m_st.ttype == this.m_FieldSeparator.charAt(0) || this.m_st.ttype == 10) {
                wasSep = true;
            } else {
                wasSep = false;
                String attName = null;
                if (this.m_noHeaderRow) {
                    attName = "att" + attNum;
                    ++attNum;
                } else {
                    attName = this.m_st.sval;
                }
                attribNames.add(new Attribute(attName, (List<String>)null));
            }
            if (!wasSep) {
                StreamTokenizerUtils.getToken(this.m_st);
            }
            first = false;
        }
        String relationName = this.m_sourceFile != null ? this.m_sourceFile.getName().replaceAll("\\.[cC][sS][vV]$", "") : "stream";
        this.m_structure = new Instances(relationName, attribNames, 0);
        this.m_NominalAttributes.setUpper(this.m_structure.numAttributes() - 1);
        this.m_StringAttributes.setUpper(this.m_structure.numAttributes() - 1);
        this.m_dateAttributes.setUpper(this.m_structure.numAttributes() - 1);
        this.m_nominalVals = new HashMap<Integer, LinkedHashSet<String>>();
        this.m_types = new TYPE[this.m_structure.numAttributes()];
        for (int i = 0; i < this.m_structure.numAttributes(); ++i) {
            if (this.m_NominalAttributes.isInRange(i)) {
                this.m_types[i] = TYPE.NOMINAL;
                LinkedHashSet ts = new LinkedHashSet();
                this.m_nominalVals.put(i, ts);
                continue;
            }
            this.m_types[i] = this.m_StringAttributes.isInRange(i) ? TYPE.STRING : (this.m_dateAttributes.isInRange(i) ? TYPE.DATE : TYPE.UNDETERMINED);
        }
        if (this.m_nominalLabelSpecs.size() > 0) {
            for (String spec : this.m_nominalLabelSpecs) {
                String[] attsAndLabels = spec.split(":");
                if (attsAndLabels.length != 2) continue;
                String[] labels = attsAndLabels[1].split(",");
                try {
                    Range tempR = new Range();
                    tempR.setRanges(attsAndLabels[0].trim());
                    tempR.setUpper(this.m_structure.numAttributes() - 1);
                    int[] rangeIndexes = tempR.getSelection();
                    for (int i = 0; i < rangeIndexes.length; ++i) {
                        this.m_types[rangeIndexes[i]] = TYPE.NOMINAL;
                        LinkedHashSet<String> ts = new LinkedHashSet<String>();
                        for (String lab : labels) {
                            ts.add(lab);
                        }
                        this.m_nominalVals.put(rangeIndexes[i], ts);
                    }
                }
                catch (IllegalArgumentException e) {
                    String[] attNames;
                    for (String attN : attNames = attsAndLabels[0].split(",")) {
                        Attribute a = this.m_structure.attribute(attN.trim());
                        if (a == null) continue;
                        int attIndex = a.index();
                        this.m_types[attIndex] = TYPE.NOMINAL;
                        LinkedHashSet<String> ts = new LinkedHashSet<String>();
                        for (String lab : labels) {
                            ts.add(lab);
                        }
                        this.m_nominalVals.put(attIndex, ts);
                    }
                }
            }
        }
        this.m_st = new StreamTokenizer(this.m_sourceReader);
        this.initTokenizer(this.m_st);
        this.m_st.ordinaryChar(this.m_FieldSeparator.charAt(0));
        this.readData(this.getRetrieval() == 1);
        this.makeStructure();
    }

    protected void openTempFiles() throws IOException {
        String tempPrefix = "" + Math.random() + "arffOut";
        this.m_tempFile = File.createTempFile(tempPrefix, null);
        this.m_tempFile.deleteOnExit();
        FileWriter os2 = new FileWriter(this.m_tempFile);
        this.m_dataDumper = new PrintWriter(new BufferedWriter(os2));
    }

    protected void dumpRow(String row) throws IOException {
        this.m_dataDumper.println(row);
    }

    private void initTokenizer(StreamTokenizer tokenizer) {
        String[] parts;
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 31);
        tokenizer.wordChars(32, 255);
        tokenizer.whitespaceChars(this.m_FieldSeparator.charAt(0), this.m_FieldSeparator.charAt(0));
        for (String e : parts = this.m_Enclosures.split(",")) {
            if (e.length() > 1 || e.length() == 0) {
                throw new IllegalArgumentException("Enclosures can only be single characters");
            }
            tokenizer.quoteChar(e.charAt(0));
        }
        tokenizer.eolIsSignificant(true);
    }

    private String getInstance(StreamTokenizer tokenizer) throws IOException {
        StreamTokenizerUtils.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            return null;
        }
        boolean first = true;
        boolean containedMissing = false;
        this.m_current.clear();
        int i = 0;
        while (tokenizer.ttype != 10 && tokenizer.ttype != -1) {
            boolean wasSep;
            block19: {
                if (!first) {
                    StreamTokenizerUtils.getToken(tokenizer);
                }
                if (tokenizer.ttype == this.m_FieldSeparator.charAt(0) || tokenizer.ttype == 10) {
                    this.m_current.add("?");
                    containedMissing = true;
                    wasSep = true;
                } else {
                    wasSep = false;
                    if (tokenizer.sval.equals(this.m_MissingValue)) {
                        this.m_current.add("?");
                        containedMissing = true;
                    } else if (this.m_types[i] == TYPE.NUMERIC || this.m_types[i] == TYPE.UNDETERMINED) {
                        try {
                            double val = Double.parseDouble(tokenizer.sval);
                            this.m_current.add(tokenizer.sval);
                            this.m_types[i] = TYPE.NUMERIC;
                        }
                        catch (NumberFormatException e) {
                            this.m_current.add(Utils.quote(tokenizer.sval));
                            if (this.m_types[i] == TYPE.UNDETERMINED) {
                                this.m_types[i] = TYPE.NOMINAL;
                                LinkedHashSet<String> ts = new LinkedHashSet<String>();
                                ts.add(tokenizer.sval);
                                this.m_nominalVals.put(i, ts);
                                break block19;
                            }
                            this.m_types[i] = TYPE.STRING;
                        }
                    } else if (this.m_types[i] == TYPE.STRING || this.m_types[i] == TYPE.DATE) {
                        this.m_current.add(Utils.quote(tokenizer.sval));
                    } else if (this.m_types[i] == TYPE.NOMINAL) {
                        this.m_current.add(Utils.quote(tokenizer.sval));
                        this.m_nominalVals.get(i).add(tokenizer.sval);
                    }
                }
            }
            if (!wasSep) {
                StreamTokenizerUtils.getToken(tokenizer);
            }
            first = false;
            ++i;
        }
        if (this.m_current.size() != this.m_structure.numAttributes()) {
            for (Object o : this.m_current) {
                System.out.print(o.toString() + "|||");
            }
            System.out.println();
            StreamTokenizerUtils.errms(tokenizer, "wrong number of values. Read " + this.m_current.size() + ", expected " + this.m_structure.numAttributes());
        }
        StringBuilder temp = new StringBuilder();
        for (Object o : this.m_current) {
            temp.append(o.toString()).append(this.m_FieldSeparator);
        }
        return temp.substring(0, temp.length() - 1);
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_rowBuffer = null;
        if (this.m_dataDumper != null) {
            this.m_dataDumper.close();
            this.m_dataDumper = null;
        }
        if (this.m_sourceReader != null) {
            this.m_sourceReader.close();
        }
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        }
    }

    public static void main(String[] args) {
        CSVLoader.runFileLoader(new CSVLoader(), args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TYPE {
        UNDETERMINED,
        NUMERIC,
        NOMINAL,
        STRING,
        DATE;

    }
}

