/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.Ranker;
import weka.core.CheckScheme;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.SerializedObject;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckAttributeSelection
extends CheckScheme {
    protected ASEvaluation m_Evaluator = new CfsSubsetEval();
    protected ASSearch m_Search = new Ranker();
    protected boolean m_TestEvaluator = true;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tFull name and options of the evaluator analyzed.\n\teg: weka.attributeSelection.CfsSubsetEval", "eval", 1, "-eval name [options]"));
        result.add(new Option("\tFull name and options of the search method analyzed.\n\teg: weka.attributeSelection.Ranker", "search", 1, "-search name [options]"));
        result.add(new Option("\tThe scheme to test, either the evaluator or the search method.\n\t(Default: eval)", "test", 1, "-test <eval|search>"));
        result.addAll(Collections.list(super.listOptions()));
        if (this.m_Evaluator != null && this.m_Evaluator instanceof OptionHandler) {
            result.add(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_Evaluator.getClass().getName() + ":"));
            result.addAll(Collections.list(((OptionHandler)((Object)this.m_Evaluator)).listOptions()));
        }
        if (this.m_Search != null && this.m_Search instanceof OptionHandler) {
            result.add(new Option("", "", 0, "\nOptions specific to search method " + this.m_Search.getClass().getName() + ":"));
            result.addAll(Collections.list(((OptionHandler)((Object)this.m_Search)).listOptions()));
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("eval", options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setEvaluator((ASEvaluation)this.forName("weka.attributeSelection", ASEvaluation.class, tmpStr, tmpOptions));
        }
        if ((tmpOptions = Utils.splitOptions(tmpStr = Utils.getOption("search", options))).length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setSearch((ASSearch)this.forName("weka.attributeSelection", ASSearch.class, tmpStr, tmpOptions));
        }
        this.setTestEvaluator(!(tmpStr = Utils.getOption("test", options)).equalsIgnoreCase("search"));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        result.add("-eval");
        if (this.getEvaluator() instanceof OptionHandler) {
            result.add(this.getEvaluator().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getEvaluator())).getOptions()));
        } else {
            result.add(this.getEvaluator().getClass().getName());
        }
        result.add("-search");
        if (this.getSearch() instanceof OptionHandler) {
            result.add(this.getSearch().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getSearch())).getOptions()));
        } else {
            result.add(this.getSearch().getClass().getName());
        }
        result.add("-test");
        if (this.getTestEvaluator()) {
            result.add("eval");
        } else {
            result.add("search");
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void doTests() {
        if (this.getTestObject() == null) {
            this.println("\n=== No scheme set ===");
            return;
        }
        this.println("\n=== Check on scheme: " + this.getTestObject().getClass().getName() + " ===\n");
        this.m_ClasspathProblems = false;
        this.println("--> Checking for interfaces");
        this.canTakeOptions();
        boolean weightedInstancesHandler = this.weightedInstancesHandler()[0];
        boolean multiInstanceHandler = this.multiInstanceHandler()[0];
        this.println("--> Scheme tests");
        this.declaresSerialVersionUID();
        this.testsPerClassType(1, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(0, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(3, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(2, weightedInstancesHandler, multiInstanceHandler);
        this.testsPerClassType(4, weightedInstancesHandler, multiInstanceHandler);
    }

    public void setEvaluator(ASEvaluation value) {
        this.m_Evaluator = value;
    }

    public ASEvaluation getEvaluator() {
        return this.m_Evaluator;
    }

    public void setSearch(ASSearch value) {
        this.m_Search = value;
    }

    public ASSearch getSearch() {
        return this.m_Search;
    }

    public void setTestEvaluator(boolean value) {
        this.m_TestEvaluator = value;
    }

    public boolean getTestEvaluator() {
        return this.m_TestEvaluator;
    }

    protected Object getTestObject() {
        if (this.getTestEvaluator()) {
            return this.getEvaluator();
        }
        return this.getSearch();
    }

    protected Object[] makeCopies(Object obj, int num) throws Exception {
        if (obj == null) {
            throw new Exception("No object set");
        }
        Object[] objs = new Object[num];
        SerializedObject so = new SerializedObject(obj);
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = so.getObject();
        }
        return objs;
    }

    protected AttributeSelection search(ASSearch search, ASEvaluation eval, Instances data) throws Exception {
        AttributeSelection result = new AttributeSelection();
        result.setSeed(42);
        result.setSearch(search);
        result.setEvaluator(eval);
        result.SelectAttributes(data);
        return result;
    }

    protected void testsPerClassType(int classType, boolean weighted, boolean multiInstance) {
        boolean PNom = this.canPredict(true, false, false, false, false, multiInstance, classType)[0];
        boolean PNum = this.canPredict(false, true, false, false, false, multiInstance, classType)[0];
        boolean PStr = this.canPredict(false, false, true, false, false, multiInstance, classType)[0];
        boolean PDat = this.canPredict(false, false, false, true, false, multiInstance, classType)[0];
        boolean PRel = !multiInstance ? this.canPredict(false, false, false, false, true, multiInstance, classType)[0] : false;
        if (PNom || PNum || PStr || PDat || PRel) {
            boolean handleMissingClass;
            if (weighted) {
                this.instanceWeights(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            }
            if (classType == 1) {
                this.canHandleNClasses(PNom, PNum, PStr, PDat, PRel, multiInstance, 4);
            }
            if (!multiInstance) {
                this.canHandleClassAsNthAttribute(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, 0);
                this.canHandleClassAsNthAttribute(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, 1);
            }
            this.canHandleZeroTraining(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            boolean handleMissingPredictors = this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, true, false, 20)[0];
            if (handleMissingPredictors) {
                this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, true, false, 100);
            }
            if (handleMissingClass = this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, false, true, 20)[0]) {
                this.canHandleMissing(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, false, true, 100);
            }
            this.correctSearchInitialisation(PNom, PNum, PStr, PDat, PRel, multiInstance, classType);
            this.datasetIntegrity(PNom, PNum, PStr, PDat, PRel, multiInstance, classType, handleMissingPredictors, handleMissingClass);
        }
    }

    protected boolean[] canTakeOptions() {
        boolean[] result = new boolean[2];
        this.print("options...");
        if (this.getTestObject() instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration<Option> enu = ((OptionHandler)this.getTestObject()).listOptions();
                while (enu.hasMoreElements()) {
                    Option option = enu.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] result = new boolean[2];
        this.print("weighted instances scheme...");
        if (this.getTestObject() instanceof WeightedInstancesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] result = new boolean[2];
        this.print("multi-instance scheme...");
        if (this.getTestObject() instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            result[0] = true;
        } else {
            this.println("no");
            result[0] = false;
        }
        return result;
    }

    protected boolean[] declaresSerialVersionUID() {
        boolean[] result = new boolean[2];
        this.print("serialVersionUID...");
        boolean eval = !SerializationHelper.needsUID(this.m_Evaluator.getClass());
        boolean search = !SerializationHelper.needsUID(this.m_Search.getClass());
        boolean bl = result[0] = eval && search;
        if (result[0]) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return result;
    }

    protected boolean[] canPredict(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        this.print("basic predict");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("unary");
        accepts.add("binary");
        accepts.add("nominal");
        accepts.add("numeric");
        accepts.add("string");
        accepts.add("date");
        accepts.add("relational");
        accepts.add("multi-instance");
        accepts.add("not in classpath");
        int numTrain = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] canHandleNClasses(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int numClasses) {
        this.print("more than two class problems");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, 1);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("number");
        accepts.add("class");
        int numTrain = this.getNumInstances();
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, 1, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] canHandleClassAsNthAttribute(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int classIndex) {
        if (classIndex == -1) {
            this.print("class attribute as last attribute");
        } else {
            this.print("class attribute as " + (classIndex + 1) + ". attribute");
        }
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        int numTrain = this.getNumInstances();
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, classIndex, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] canHandleZeroTraining(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        this.print("handle zero training instances");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("train");
        accepts.add("value");
        int numTrain = 0;
        int numClasses = 2;
        int missingLevel = 0;
        boolean predictorMissing = false;
        boolean classMissing = false;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] correctSearchInitialisation(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        boolean[] result;
        block13: {
            result = new boolean[2];
            this.print("correct initialisation during search");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean predictorMissing = false;
            boolean classMissing = false;
            Instances train1 = null;
            Instances train2 = null;
            ASSearch search = null;
            ASEvaluation evaluation1A = null;
            ASEvaluation evaluation1B = null;
            ASEvaluation evaluation2 = null;
            AttributeSelection attsel1A = null;
            AttributeSelection attsel1B = null;
            int stage = 0;
            try {
                train1 = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                train2 = this.makeTestDataset(84, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train1, missingLevel, predictorMissing, classMissing);
                    this.addMissing(train2, missingLevel, predictorMissing, classMissing);
                }
                search = ASSearch.makeCopies(this.getSearch(), 1)[0];
                evaluation1A = ASEvaluation.makeCopies(this.getEvaluator(), 1)[0];
                evaluation1B = ASEvaluation.makeCopies(this.getEvaluator(), 1)[0];
                evaluation2 = ASEvaluation.makeCopies(this.getEvaluator(), 1)[0];
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                stage = 0;
                attsel1A = this.search(search, evaluation1A, train1);
                stage = 1;
                this.search(search, evaluation2, train2);
                stage = 2;
                attsel1B = this.search(search, evaluation1B, train1);
                stage = 3;
                if (!attsel1A.toResultsString().equals(attsel1B.toResultsString())) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n\nFirst search\n" + attsel1A.toResultsString() + "\n\n");
                        this.println("\nSecond search\n" + attsel1B.toResultsString() + "\n\n");
                    }
                    throw new Exception("Results differ between search calls");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block13;
                this.println("\n=== Full Report ===");
                this.print("Problem during  training");
                switch (stage) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + ex.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + train1.toString() + "\n");
                this.println("=== Train2 Dataset ===\n" + train2.toString() + "\n");
            }
        }
        return result;
    }

    protected boolean[] canHandleMissing(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, boolean predictorMissing, boolean classMissing, int missingLevel) {
        if (missingLevel == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (predictorMissing) {
            this.print(" predictor");
            if (classMissing) {
                this.print(" and");
            }
        }
        if (classMissing) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
        this.print("...");
        ArrayList<String> accepts = new ArrayList<String>();
        accepts.add("missing");
        accepts.add("value");
        accepts.add("train");
        accepts.add("no attributes");
        int numTrain = this.getNumInstances();
        int numClasses = 2;
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] instanceWeights(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        boolean[] result;
        block11: {
            this.print("scheme uses instance weights");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = 2 * this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 0;
            boolean predictorMissing = false;
            boolean classMissing = false;
            result = new boolean[2];
            Instances train = null;
            ASSearch[] search = null;
            ASEvaluation evaluationB = null;
            ASEvaluation evaluationI = null;
            AttributeSelection attselB = null;
            AttributeSelection attselI = null;
            boolean evalFail = false;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() + 1 : 0, numericPredictor ? this.getNumNumeric() + 1 : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                }
                search = ASSearch.makeCopies(this.getSearch(), 2);
                evaluationB = ASEvaluation.makeCopies(this.getEvaluator(), 1)[0];
                evaluationI = ASEvaluation.makeCopies(this.getEvaluator(), 1)[0];
                attselB = this.search(search[0], evaluationB, train);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                for (int i = 0; i < train.numInstances(); ++i) {
                    train.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < train.numInstances() / 2; ++i) {
                    int inst = Math.abs(random.nextInt()) % train.numInstances();
                    int weight = Math.abs(random.nextInt()) % 10 + 1;
                    train.instance(inst).setWeight(weight);
                }
                attselI = this.search(search[1], evaluationI, train);
                if (attselB.toResultsString().equals(attselI.toResultsString())) {
                    evalFail = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block11;
                this.println("\n=== Full Report ===");
                if (evalFail) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println("\nboth methods\n");
                    this.println(evaluationB.toString());
                } else {
                    this.print("Problem during training");
                    this.println(": " + ex.getMessage() + "\n");
                }
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < train.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + train.instance(i).weight());
                }
            }
        }
        return result;
    }

    protected boolean[] datasetIntegrity(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, boolean predictorMissing, boolean classMissing) {
        boolean[] result;
        block5: {
            this.print("scheme doesn't alter original datasets");
            this.printAttributeSummary(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType);
            this.print("...");
            int numTrain = this.getNumInstances();
            int numClasses = 2;
            int missingLevel = 20;
            result = new boolean[2];
            Instances train = null;
            Instances trainCopy = null;
            ASSearch search = null;
            ASEvaluation evaluation = null;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                }
                search = ASSearch.makeCopies(this.getSearch(), 1)[0];
                evaluation = ASEvaluation.makeCopies(this.getEvaluator(), 1)[0];
                trainCopy = new Instances(train);
            }
            catch (Exception ex) {
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                this.search(search, evaluation, trainCopy);
                this.compareDatasets(train, trainCopy);
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                this.println("no");
                result[0] = false;
                if (!this.m_Debug) break block5;
                this.println("\n=== Full Report ===");
                this.print("Problem during training");
                this.println(": " + ex.getMessage() + "\n");
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset (original) ===\n" + trainCopy.toString() + "\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
            }
        }
        return result;
    }

    protected boolean[] runBasicTest(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int missingLevel, boolean predictorMissing, boolean classMissing, int numTrain, int numClasses, ArrayList<String> accepts) {
        return this.runBasicTest(nominalPredictor, numericPredictor, stringPredictor, datePredictor, relationalPredictor, multiInstance, classType, -1, missingLevel, predictorMissing, classMissing, numTrain, numClasses, accepts);
    }

    protected boolean[] runBasicTest(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType, int classIndex, int missingLevel, boolean predictorMissing, boolean classMissing, int numTrain, int numClasses, ArrayList<String> accepts) {
        boolean[] result;
        block10: {
            result = new boolean[2];
            Instances train = null;
            ASSearch search = null;
            ASEvaluation evaluation = null;
            try {
                train = this.makeTestDataset(42, numTrain, nominalPredictor ? this.getNumNominal() : 0, numericPredictor ? this.getNumNumeric() : 0, stringPredictor ? this.getNumString() : 0, datePredictor ? this.getNumDate() : 0, relationalPredictor ? this.getNumRelational() : 0, numClasses, classType, classIndex, multiInstance);
                if (missingLevel > 0) {
                    this.addMissing(train, missingLevel, predictorMissing, classMissing);
                }
                search = ASSearch.makeCopies(this.getSearch(), 1)[0];
                evaluation = ASEvaluation.makeCopies(this.getEvaluator(), 1)[0];
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Error("Error setting up for tests: " + ex.getMessage());
            }
            try {
                this.search(search, evaluation, train);
                this.println("yes");
                result[0] = true;
            }
            catch (Exception ex) {
                int i;
                boolean acceptable = false;
                String msg = ex.getMessage() == null ? "" : ex.getMessage().toLowerCase();
                if (msg.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                for (i = 0; i < accepts.size(); ++i) {
                    if (msg.indexOf(accepts.get(i)) < 0) continue;
                    acceptable = true;
                }
                this.println("no" + (acceptable ? " (OK error message)" : ""));
                result[1] = acceptable;
                if (!this.m_Debug) break block10;
                this.println("\n=== Full Report ===");
                this.print("Problem during training");
                this.println(": " + ex.getMessage() + "\n");
                if (acceptable) break block10;
                if (accepts.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (i = 0; i < accepts.size(); ++i) {
                        if (i != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + accepts.get(i) + '\"');
                    }
                }
                this.println("here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + train.toString() + "\n");
            }
        }
        return result;
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numString, int numDate, int numRelational, int numClasses, int classType, boolean multiInstance) throws Exception {
        return this.makeTestDataset(seed, numInstances, numNominal, numNumeric, numString, numDate, numRelational, numClasses, classType, -1, multiInstance);
    }

    protected Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numString, int numDate, int numRelational, int numClasses, int classType, int classIndex, boolean multiInstance) throws Exception {
        TestInstances dataset = new TestInstances();
        dataset.setSeed(seed);
        dataset.setNumInstances(numInstances);
        dataset.setNumNominal(numNominal);
        dataset.setNumNumeric(numNumeric);
        dataset.setNumString(numString);
        dataset.setNumDate(numDate);
        dataset.setNumRelational(numRelational);
        dataset.setNumClasses(numClasses);
        dataset.setClassType(classType);
        dataset.setClassIndex(classIndex);
        dataset.setNumClasses(numClasses);
        dataset.setMultiInstance(multiInstance);
        dataset.setWords(this.getWords());
        dataset.setWordSeparators(this.getWordSeparators());
        return this.process(dataset.generate());
    }

    protected void printAttributeSummary(boolean nominalPredictor, boolean numericPredictor, boolean stringPredictor, boolean datePredictor, boolean relationalPredictor, boolean multiInstance, int classType) {
        String str = "";
        if (numericPredictor) {
            str = str + " numeric";
        }
        if (nominalPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " nominal";
        }
        if (stringPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " string";
        }
        if (datePredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " date";
        }
        if (relationalPredictor) {
            if (str.length() > 0) {
                str = str + " &";
            }
            str = str + " relational";
        }
        str = str + " predictors)";
        switch (classType) {
            case 0: {
                str = " (numeric class," + str;
                break;
            }
            case 1: {
                str = " (nominal class," + str;
                break;
            }
            case 2: {
                str = " (string class," + str;
                break;
            }
            case 3: {
                str = " (date class," + str;
                break;
            }
            case 4: {
                str = " (relational class," + str;
            }
        }
        this.print(str);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10172 $");
    }

    public static void main(String[] args) {
        CheckAttributeSelection.runCheck(new CheckAttributeSelection(), args);
    }
}

