/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.packageManagement.DefaultPackageManager;
import org.pentaho.packageManagement.Dependency;
import org.pentaho.packageManagement.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageManager {
    protected File m_packageHome;
    protected URL m_packageRepository;
    protected String m_baseSystemName;
    protected Object m_baseSystemVersion;
    protected Proxy m_httpProxy;
    protected String m_proxyUsername;
    protected String m_proxyPassword;

    public static PackageManager create() {
        PackageManager packageManager = new DefaultPackageManager();
        packageManager.establishProxy();
        try {
            String string = System.getProperty("org.pentaho.packageManagement.manager");
            if (string != null && string.length() > 0) {
                Object object = Beans.instantiate(packageManager.getClass().getClassLoader(), string);
                if (object instanceof PackageManager) {
                    packageManager = (PackageManager)object;
                }
            } else {
                File file = new File(System.getProperty("user.home") + File.separator + "PackageManager.props");
                if (file.exists()) {
                    Object object;
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(file));
                    string = properties.getProperty("org.pentaho.packageManager.manager");
                    if (string != null && string.length() > 0 && (object = Beans.instantiate(packageManager.getClass().getClassLoader(), string)) instanceof PackageManager) {
                        packageManager = (PackageManager)object;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Problem instantiating package manager. Using DefaultPackageManager.");
        }
        return packageManager;
    }

    public void establishProxy() {
        Object object;
        String string = System.getProperty("http.proxyHost");
        String string2 = System.getProperty("http.proxyPort");
        if (string != null && string.length() > 0) {
            int n = 80;
            if (string2 != null && string2.length() > 0) {
                n = Integer.parseInt(string2);
            }
            object = new InetSocketAddress(string, n);
            this.setProxy(new Proxy(Proxy.Type.HTTP, (SocketAddress)object));
        }
        String string3 = System.getProperty("http.proxyUser");
        object = System.getProperty("http.proxyPassword");
        if (string3 != null && string3.length() > 0 && object != null && ((String)object).length() > 0) {
            this.setProxyUsername(string3);
            this.setProxyPassword((String)object);
        }
    }

    public boolean setProxyAuthentication() {
        if (this.m_httpProxy != null && this.m_proxyUsername != null && this.m_proxyPassword != null) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(PackageManager.this.m_proxyUsername, PackageManager.this.m_proxyPassword.toCharArray());
                }
            });
            return true;
        }
        return false;
    }

    public void setPackageHome(File file) {
        this.m_packageHome = file;
    }

    public File getPackageHome() {
        return this.m_packageHome;
    }

    public void setBaseSystemName(String string) {
        this.m_baseSystemName = string;
    }

    public String getBaseSystemName() {
        return this.m_baseSystemName;
    }

    public void setBaseSystemVersion(Object object) {
        this.m_baseSystemVersion = object;
    }

    public Object getBaseSystemVersion() {
        return this.m_baseSystemVersion;
    }

    public void setPackageRepositoryURL(URL uRL) {
        this.m_packageRepository = uRL;
    }

    public URL getPackageRepositoryURL() {
        return this.m_packageRepository;
    }

    public void setProxy(Proxy proxy) {
        this.m_httpProxy = proxy;
    }

    public Proxy getProxy() {
        return this.m_httpProxy;
    }

    public void setProxyUsername(String string) {
        this.m_proxyUsername = string;
    }

    public void setProxyPassword(String string) {
        this.m_proxyPassword = string;
    }

    public abstract byte[] getRepositoryPackageMetaDataOnlyAsZip(PrintStream ... var1) throws Exception;

    public abstract Package getPackageArchiveInfo(String var1) throws Exception;

    public abstract Package getInstalledPackageInfo(String var1) throws Exception;

    public abstract Package getRepositoryPackageInfo(String var1) throws Exception;

    public abstract Package getRepositoryPackageInfo(String var1, Object var2) throws Exception;

    public abstract List<Object> getRepositoryPackageVersions(String var1) throws Exception;

    public abstract Package getURLPackageInfo(URL var1) throws Exception;

    public abstract String installPackageFromArchive(String var1, PrintStream ... var2) throws Exception;

    public abstract void installPackageFromRepository(String var1, Object var2, PrintStream ... var3) throws Exception;

    public abstract String installPackageFromURL(URL var1, PrintStream ... var2) throws Exception;

    public abstract void installPackages(List<Package> var1, PrintStream ... var2) throws Exception;

    public abstract void uninstallPackage(String var1, PrintStream ... var2) throws Exception;

    public abstract List<Package> getInstalledPackages() throws Exception;

    public abstract List<Package> getAllPackages(PrintStream ... var1) throws Exception;

    public abstract List<Package> getAvailablePackages() throws Exception;

    public abstract List<Dependency> getAllDependenciesForPackage(Package var1, Map<String, List<Dependency>> var2) throws Exception;
}

