/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class NumericToBinary
extends PotentialClassIgnorer
implements UnsupervisedFilter,
StreamableFilter {
    static final long serialVersionUID = 2616879323359470802L;

    public String globalInfo() {
        return "Converts all numeric attributes into binary attributes (apart from the class attribute, if set): if the value of the numeric attribute is exactly zero, the value of the new attribute will be zero. If the value of the numeric attribute is missing, the value of the new attribute will be missing. Otherwise, the value of the new attribute will be one. The new attributes will be nominal.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    private void setOutputFormat() {
        int newClassIndex = this.getInputFormat().classIndex();
        FastVector<Attribute> newAtts = new FastVector<Attribute>();
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j == newClassIndex || !att.isNumeric()) {
                newAtts.addElement((Attribute)att.copy());
                continue;
            }
            StringBuffer attributeName = new StringBuffer(att.name() + "_binarized");
            FastVector<String> vals = new FastVector<String>(2);
            vals.addElement("0");
            vals.addElement("1");
            newAtts.addElement(new Attribute(attributeName.toString(), vals));
        }
        Instances outputFormat = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        this.setOutputFormat(outputFormat);
    }

    private void convertInstance(Instance instance) {
        AbstractInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] vals = new double[instance.numValues()];
            int[] newIndices = new int[instance.numValues()];
            for (int j = 0; j < instance.numValues(); ++j) {
                Attribute att = this.getInputFormat().attribute(instance.index(j));
                vals[j] = !att.isNumeric() || instance.index(j) == this.getInputFormat().classIndex() ? instance.valueSparse(j) : (instance.isMissingSparse(j) ? instance.valueSparse(j) : 1.0);
                newIndices[j] = instance.index(j);
            }
            inst = new SparseInstance(instance.weight(), vals, newIndices, this.outputFormatPeek().numAttributes());
        } else {
            double[] vals = new double[this.outputFormatPeek().numAttributes()];
            for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
                Attribute att = this.getInputFormat().attribute(j);
                vals[j] = !att.isNumeric() || j == this.getInputFormat().classIndex() ? instance.value(j) : (instance.isMissing(j) || instance.value(j) == 0.0 ? instance.value(j) : 1.0);
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        NumericToBinary.runFilter(new NumericToBinary(), argv);
    }
}

