/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import weka.core.Attribute;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.Visible;

@KFStep(category="Flow", toolTipText="Route instances according to a boolean expression")
public class FlowByExpression
extends JPanel
implements BeanCommon,
Visible,
Serializable,
InstanceListener,
TrainingSetListener,
TestSetListener,
DataSourceListener,
EventConstraints,
EnvironmentHandler,
DataSource,
StructureProducer {
    private static final long serialVersionUID = 2492050246494259885L;
    protected ExpressionNode m_root;
    protected String m_expressionString = "";
    protected Object[] m_downstream;
    protected String m_customNameOfTrueStep = "";
    protected String m_customNameOfFalseStep = "";
    protected int m_indexOfTrueStep;
    protected int m_indexOfFalseStep;
    protected transient Logger m_log;
    protected transient boolean m_busy;
    protected Object m_listenee;
    protected String m_connectionType;
    private Instances m_connectedFormat;
    protected transient Environment m_env;
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected BeanVisual m_visual = new BeanVisual("FlowByExpression", "weka/gui/beans/icons/FlowByExpression.png", "weka/gui/beans/icons/FlowByExpression.png");

    public FlowByExpression() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
    }

    public String globalInfo() {
        return "Splits incoming instances (or instance stream) according to the evaluation of a logical expression. The expression can test the values of one or more incoming attributes. The test can involve constants or comparing one attribute's values to another. Inequalities along with string operations such as contains, starts-with, ends-with and regular expressions may be used as operators. \"True\" instances can be sent to one downstream step and \"False\" instances sent to another.";
    }

    public void setExpressionString(String expressionString) {
        this.m_expressionString = expressionString;
    }

    public String getExpressionString() {
        return this.m_expressionString;
    }

    public void setTrueStepName(String trueStep) {
        this.m_customNameOfTrueStep = trueStep;
    }

    public String getTrueStepName() {
        return this.m_customNameOfTrueStep;
    }

    public void setFalseStepName(String falseStep) {
        this.m_customNameOfFalseStep = falseStep;
    }

    public String getFalseStepName() {
        return this.m_customNameOfFalseStep;
    }

    @Override
    public void addDataSourceListener(DataSourceListener dsl) {
        if (this.m_downstream == null) {
            this.m_downstream = new Object[2];
        }
        if (this.m_downstream[0] == null && this.m_downstream[1] == null) {
            this.m_downstream[0] = dsl;
            return;
        }
        if (this.m_downstream[0] == null || this.m_downstream[1] == null) {
            if (this.m_downstream[0] == null && this.m_downstream[1] instanceof DataSourceListener) {
                this.m_downstream[0] = dsl;
                return;
            }
            if (this.m_downstream[1] == null && this.m_downstream[0] instanceof DataSourceListener) {
                this.m_downstream[1] = dsl;
                return;
            }
        }
    }

    protected void remove(Object dsl) {
        if (this.m_downstream[0] == dsl) {
            this.m_downstream[0] = null;
            return;
        }
        if (this.m_downstream[1] == dsl) {
            this.m_downstream[1] = null;
        }
    }

    @Override
    public void removeDataSourceListener(DataSourceListener dsl) {
        if (this.m_downstream == null) {
            this.m_downstream = new Object[2];
        }
        this.remove(dsl);
    }

    @Override
    public void addInstanceListener(InstanceListener dsl) {
        if (this.m_downstream == null) {
            this.m_downstream = new Object[2];
        }
        if (this.m_downstream[0] == null && this.m_downstream[1] == null) {
            this.m_downstream[0] = dsl;
            return;
        }
        if (this.m_downstream[0] == null || this.m_downstream[1] == null) {
            if (this.m_downstream[0] == null && this.m_downstream[1] instanceof InstanceListener) {
                this.m_downstream[0] = dsl;
                return;
            }
            if (this.m_downstream[1] == null && this.m_downstream[0] instanceof InstanceListener) {
                this.m_downstream[1] = dsl;
                return;
            }
        }
    }

    @Override
    public void removeInstanceListener(InstanceListener dsl) {
        if (this.m_downstream == null) {
            this.m_downstream = new Object[2];
        }
        this.remove(dsl);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            if (eventName.equals("dataSet")) {
                return ((EventConstraints)this.m_listenee).eventGeneratable(eventName) || ((EventConstraints)this.m_listenee).eventGeneratable("trainingSet") || ((EventConstraints)this.m_listenee).eventGeneratable("testSet");
            }
            return ((EventConstraints)this.m_listenee).eventGeneratable(eventName);
        }
        return true;
    }

    protected void init(Instances data) {
        this.m_indexOfTrueStep = -1;
        this.m_indexOfFalseStep = -1;
        this.m_connectedFormat = data;
        if (this.m_downstream == null) {
            return;
        }
        if (this.m_downstream[0] != null && ((BeanCommon)this.m_downstream[0]).getCustomName().equals(this.m_customNameOfTrueStep)) {
            this.m_indexOfTrueStep = 0;
        }
        if (this.m_downstream[0] != null && ((BeanCommon)this.m_downstream[0]).getCustomName().equals(this.m_customNameOfFalseStep)) {
            this.m_indexOfFalseStep = 0;
        }
        if (this.m_downstream[1] != null && ((BeanCommon)this.m_downstream[1]).getCustomName().equals(this.m_customNameOfTrueStep)) {
            this.m_indexOfTrueStep = 1;
        }
        if (this.m_downstream[1] != null && ((BeanCommon)this.m_downstream[1]).getCustomName().equals(this.m_customNameOfFalseStep)) {
            this.m_indexOfFalseStep = 1;
        }
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        try {
            if (this.m_expressionString != null && this.m_expressionString.length() > 0) {
                this.m_root = new BracketNode();
                this.m_root.parseFromInternal(this.m_expressionString);
            }
            if (this.m_root != null) {
                this.m_root.init(data, this.m_env);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.stop();
            this.m_busy = false;
        }
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        this.m_busy = true;
        if (this.m_log != null && !e.isStructureOnly()) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Processing batch...");
        }
        this.init(new Instances(e.getDataSet(), 0));
        if (this.m_root != null) {
            Instances trueBatch = new Instances(e.getDataSet(), 0);
            Instances falseBatch = new Instances(e.getDataSet(), 0);
            for (int i = 0; i < e.getDataSet().numInstances(); ++i) {
                Instance current = e.getDataSet().instance(i);
                boolean result = this.m_root.evaluate(current, true);
                if (result) {
                    if (this.m_indexOfTrueStep < 0) continue;
                    trueBatch.add(current);
                    continue;
                }
                if (this.m_indexOfFalseStep < 0) continue;
                falseBatch.add(current);
            }
            if (this.m_indexOfTrueStep >= 0) {
                DataSetEvent d = new DataSetEvent(this, trueBatch);
                ((DataSourceListener)this.m_downstream[this.m_indexOfTrueStep]).acceptDataSet(d);
            }
            if (this.m_indexOfFalseStep >= 0) {
                DataSetEvent d = new DataSetEvent(this, falseBatch);
                ((DataSourceListener)this.m_downstream[this.m_indexOfFalseStep]).acceptDataSet(d);
            }
        } else if (this.m_indexOfTrueStep >= 0) {
            DataSetEvent d = new DataSetEvent(this, e.getDataSet());
            ((DataSourceListener)this.m_downstream[this.m_indexOfTrueStep]).acceptDataSet(d);
        }
        if (this.m_log != null && !e.isStructureOnly()) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Finished");
        }
        this.m_busy = false;
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances test = e.getTestSet();
        DataSetEvent d = new DataSetEvent(this, test);
        this.acceptDataSet(d);
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances train = e.getTrainingSet();
        DataSetEvent d = new DataSetEvent(this, train);
        this.acceptDataSet(d);
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        this.m_busy = true;
        if (e.getStatus() == 0) {
            Instances structure = e.getStructure();
            this.init(structure);
            if (this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Processing stream...");
            }
            this.m_ie.setStructure(structure);
            if (this.m_indexOfTrueStep >= 0) {
                ((InstanceListener)this.m_downstream[this.m_indexOfTrueStep]).acceptInstance(this.m_ie);
            }
            if (this.m_indexOfFalseStep >= 0) {
                ((InstanceListener)this.m_downstream[this.m_indexOfFalseStep]).acceptInstance(this.m_ie);
            }
        } else {
            Instance inst = e.getInstance();
            this.m_ie.setStatus(e.getStatus());
            if (inst == null || e.getStatus() == 2) {
                if (inst != null) {
                    boolean result = true;
                    if (this.m_root != null) {
                        result = this.m_root.evaluate(inst, true);
                    }
                    if (result) {
                        if (this.m_indexOfTrueStep >= 0) {
                            this.m_ie.setInstance(inst);
                            ((InstanceListener)this.m_downstream[this.m_indexOfTrueStep]).acceptInstance(this.m_ie);
                        }
                        if (this.m_indexOfFalseStep >= 0) {
                            this.m_ie.setInstance(null);
                            ((InstanceListener)this.m_downstream[this.m_indexOfFalseStep]).acceptInstance(this.m_ie);
                        }
                    } else {
                        if (this.m_indexOfFalseStep >= 0) {
                            this.m_ie.setInstance(inst);
                            ((InstanceListener)this.m_downstream[this.m_indexOfFalseStep]).acceptInstance(this.m_ie);
                        }
                        if (this.m_indexOfTrueStep >= 0) {
                            this.m_ie.setInstance(null);
                            ((InstanceListener)this.m_downstream[this.m_indexOfTrueStep]).acceptInstance(this.m_ie);
                        }
                    }
                } else {
                    this.m_ie.setInstance(null);
                    if (this.m_indexOfTrueStep >= 0) {
                        ((InstanceListener)this.m_downstream[this.m_indexOfTrueStep]).acceptInstance(this.m_ie);
                    }
                    if (this.m_indexOfFalseStep >= 0) {
                        ((InstanceListener)this.m_downstream[this.m_indexOfFalseStep]).acceptInstance(this.m_ie);
                    }
                }
                if (this.m_log != null) {
                    this.m_log.statusMessage(this.statusMessagePrefix() + "Finished");
                }
            } else {
                boolean result = true;
                if (this.m_root != null) {
                    result = this.m_root.evaluate(inst, true);
                }
                this.m_ie.setInstance(inst);
                if (result) {
                    if (this.m_indexOfTrueStep >= 0) {
                        ((InstanceListener)this.m_downstream[this.m_indexOfTrueStep]).acceptInstance(this.m_ie);
                    }
                } else if (this.m_indexOfFalseStep >= 0) {
                    ((InstanceListener)this.m_downstream[this.m_indexOfFalseStep]).acceptInstance(this.m_ie);
                }
            }
        }
        this.m_busy = false;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/FlowByExpression.png", "weka/gui/beans/icons/FlowByExpression.png");
        this.m_visual.setText("FlowByExpression");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
        if (this.m_listenee != null && this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Stopped");
        }
        this.m_busy = false;
    }

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return this.m_listenee == null;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
            this.m_connectionType = eventName;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (source == this.m_listenee) {
            this.m_listenee = null;
        }
    }

    protected String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    private Instances getUpstreamStructure() {
        if (this.m_listenee != null && this.m_listenee instanceof StructureProducer) {
            return ((StructureProducer)this.m_listenee).getStructure(this.m_connectionType);
        }
        return null;
    }

    @Override
    public Instances getStructure(String eventName) {
        if (!eventName.equals("dataSet") && !eventName.equals("instance")) {
            return null;
        }
        if (eventName.equals("dataSet") && (this.m_downstream == null || this.m_downstream.length == 0)) {
            return null;
        }
        if (eventName.equals("instance") && (this.m_downstream == null || this.m_downstream.length == 0)) {
            return null;
        }
        if (this.m_connectedFormat == null) {
            this.m_connectedFormat = this.getUpstreamStructure();
        }
        return this.m_connectedFormat;
    }

    public Instances getConnectedFormat() {
        if (this.m_connectedFormat == null) {
            this.m_connectedFormat = this.getUpstreamStructure();
        }
        return this.m_connectedFormat;
    }

    protected static class ExpressionClause
    extends ExpressionNode
    implements Serializable {
        private static final long serialVersionUID = 2754006654981248325L;
        protected ExpressionType m_operator;
        protected String m_lhsAttributeName;
        protected int m_lhsAttIndex = -1;
        protected String m_rhsOperand;
        protected boolean m_rhsIsAttribute;
        protected int m_rhsAttIndex = -1;
        protected String m_resolvedLhsName;
        protected String m_resolvedRhsOperand;
        protected Pattern m_regexPattern;
        protected double m_numericOperand;

        public ExpressionClause() {
        }

        public ExpressionClause(ExpressionType operator, String lhsAttributeName, String rhsOperand, boolean rhsIsAttribute, boolean isAnOr) {
            this.m_operator = operator;
            this.m_lhsAttributeName = lhsAttributeName;
            this.m_rhsOperand = rhsOperand;
            this.m_rhsIsAttribute = rhsIsAttribute;
            this.m_isAnOr = isAnOr;
        }

        @Override
        public void init(Instances structure, Environment env) {
            super.init(structure, env);
            this.m_resolvedLhsName = this.m_lhsAttributeName;
            this.m_resolvedRhsOperand = this.m_rhsOperand;
            try {
                this.m_resolvedLhsName = this.m_env.substitute(this.m_resolvedLhsName);
                this.m_resolvedRhsOperand = this.m_env.substitute(this.m_resolvedRhsOperand);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Attribute lhs = null;
            if (this.m_resolvedLhsName.toLowerCase().startsWith("/first")) {
                lhs = structure.attribute(0);
            } else if (this.m_resolvedLhsName.toLowerCase().startsWith("/last")) {
                lhs = structure.attribute(structure.numAttributes() - 1);
            } else {
                try {
                    int indx = Integer.parseInt(this.m_resolvedLhsName);
                    lhs = structure.attribute(--indx);
                }
                catch (NumberFormatException indx) {
                    // empty catch block
                }
            }
            if (lhs == null) {
                lhs = structure.attribute(this.m_resolvedLhsName);
            }
            if (lhs == null) {
                throw new IllegalArgumentException("Data does not contain attribute \"" + this.m_resolvedLhsName + "\"");
            }
            this.m_lhsAttIndex = lhs.index();
            if (this.m_rhsIsAttribute) {
                Attribute rhs = null;
                if (this.m_resolvedRhsOperand.toLowerCase().equals("/first")) {
                    rhs = structure.attribute(0);
                } else if (this.m_resolvedRhsOperand.toLowerCase().equals("/last")) {
                    rhs = structure.attribute(structure.numAttributes() - 1);
                } else {
                    try {
                        int indx = Integer.parseInt(this.m_resolvedRhsOperand);
                        rhs = structure.attribute(--indx);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (rhs == null) {
                    rhs = structure.attribute(this.m_resolvedRhsOperand);
                }
                if (rhs == null) {
                    throw new IllegalArgumentException("Data does not contain attribute \"" + this.m_resolvedRhsOperand + "\"");
                }
                this.m_rhsAttIndex = rhs.index();
            } else if (this.m_operator != ExpressionType.CONTAINS && this.m_operator != ExpressionType.STARTSWITH && this.m_operator != ExpressionType.ENDSWITH && this.m_operator != ExpressionType.REGEX && this.m_operator != ExpressionType.ISMISSING) {
                if (lhs.isNominal()) {
                    this.m_numericOperand = lhs.indexOfValue(this.m_resolvedRhsOperand);
                    if (this.m_numericOperand < 0.0) {
                        throw new IllegalArgumentException("Unknown nominal value '" + this.m_resolvedRhsOperand + "' for attribute '" + lhs.name() + "'");
                    }
                } else {
                    try {
                        this.m_numericOperand = Double.parseDouble(this.m_resolvedRhsOperand);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("\"" + this.m_resolvedRhsOperand + "\" is not parseable as a number!");
                    }
                }
            }
            if (this.m_operator == ExpressionType.REGEX) {
                this.m_regexPattern = Pattern.compile(this.m_resolvedRhsOperand);
            }
        }

        @Override
        public boolean evaluate(Instance inst, boolean result) {
            boolean thisNode = this.m_operator.evaluate(inst, this.m_lhsAttIndex, this.m_rhsOperand, this.m_numericOperand, this.m_regexPattern, this.m_rhsIsAttribute, this.m_rhsAttIndex);
            if (this.isNegated()) {
                boolean bl = thisNode = !thisNode;
            }
            return this.isOr() ? result || thisNode : result && thisNode;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            this.toStringDisplay(buff);
            return buff.toString();
        }

        @Override
        public void toStringDisplay(StringBuffer buff) {
            this.toString(buff, false);
        }

        @Override
        protected void toStringInternal(StringBuffer buff) {
            this.toString(buff, true);
        }

        @Override
        public DefaultMutableTreeNode toJTree(DefaultMutableTreeNode parent) {
            parent.add(new DefaultMutableTreeNode(this));
            return parent;
        }

        private void toString(StringBuffer buff, boolean internal) {
            if (internal || this.m_showAndOr) {
                if (this.m_isAnOr) {
                    buff.append("|| ");
                } else {
                    buff.append("&& ");
                }
            }
            if (this.isNegated()) {
                buff.append("!");
            }
            buff.append("[");
            buff.append(this.m_lhsAttributeName);
            if (internal) {
                buff.append("@EC@" + this.m_operator.toString());
            } else {
                buff.append(" " + this.m_operator.toString());
            }
            if (this.m_operator != ExpressionType.ISMISSING) {
                if (internal) {
                    buff.append("@EC@" + (this.m_rhsIsAttribute ? "@@" : "") + this.m_rhsOperand);
                } else {
                    buff.append(" " + (this.m_rhsIsAttribute ? "ATT: " : "") + this.m_rhsOperand);
                }
            } else if (internal) {
                buff.append("@EC@");
            } else {
                buff.append(" ");
            }
            buff.append("]");
        }

        @Override
        protected String parseFromInternal(String expression) {
            if (expression.startsWith("|| ")) {
                this.m_isAnOr = true;
            }
            if (expression.startsWith("|| ") || expression.startsWith("&& ")) {
                expression = expression.substring(3, expression.length());
            }
            if (expression.charAt(0) == '!') {
                this.setNegated(true);
                expression = expression.substring(1, expression.length());
            }
            if (expression.charAt(0) != '[') {
                throw new IllegalArgumentException("Was expecting a \"[\" to start this ExpressionClause!");
            }
            expression = expression.substring(1, expression.length());
            this.m_lhsAttributeName = expression.substring(0, expression.indexOf("@EC@"));
            expression = expression.substring(expression.indexOf("@EC@") + 4, expression.length());
            String oppName = expression.substring(0, expression.indexOf("@EC@"));
            expression = expression.substring(expression.indexOf("@EC@") + 4, expression.length());
            for (ExpressionType n : ExpressionType.values()) {
                if (!n.toString().equals(oppName)) continue;
                this.m_operator = n;
                break;
            }
            if (expression.startsWith("@@")) {
                expression = expression.substring(2, expression.length());
                this.m_rhsIsAttribute = true;
            }
            this.m_rhsOperand = expression.substring(0, expression.indexOf(93));
            if ((expression = expression.substring(expression.indexOf(93) + 1, expression.length())).charAt(0) == ' ') {
                expression = expression.substring(1, expression.length());
            }
            return expression;
        }

        public static enum ExpressionType {
            EQUALS(" = "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (rhsIsAttribute) {
                        if (inst.isMissing(lhsAttIndex) && inst.isMissing(rhsAttIndex)) {
                            return true;
                        }
                        if (inst.isMissing(lhsAttIndex) || inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        return Utils.eq(inst.value(lhsAttIndex), inst.value(rhsAttIndex));
                    }
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    return Utils.eq(inst.value(lhsAttIndex), numericOperand);
                }
            }
            ,
            NOTEQUAL(" != "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return !EQUALS.evaluate(inst, lhsAttIndex, rhsOperand, numericOperand, regexPattern, rhsIsAttribute, rhsAttIndex);
                }
            }
            ,
            LESSTHAN(" < "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (rhsIsAttribute) {
                        if (inst.isMissing(lhsAttIndex) || inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        return inst.value(lhsAttIndex) < inst.value(rhsAttIndex);
                    }
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    return inst.value(lhsAttIndex) < numericOperand;
                }
            }
            ,
            LESSTHANEQUAL(" <= "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (rhsIsAttribute) {
                        if (inst.isMissing(lhsAttIndex) || inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        return inst.value(lhsAttIndex) <= inst.value(rhsAttIndex);
                    }
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    return inst.value(lhsAttIndex) <= numericOperand;
                }
            }
            ,
            GREATERTHAN(" > "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return !LESSTHANEQUAL.evaluate(inst, lhsAttIndex, rhsOperand, numericOperand, regexPattern, rhsIsAttribute, rhsAttIndex);
                }
            }
            ,
            GREATERTHANEQUAL(" >= "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return !LESSTHAN.evaluate(inst, lhsAttIndex, rhsOperand, numericOperand, regexPattern, rhsIsAttribute, rhsAttIndex);
                }
            }
            ,
            ISMISSING(" isMissing "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return inst.isMissing(lhsAttIndex);
                }
            }
            ,
            CONTAINS(" contains "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    if (rhsIsAttribute) {
                        if (inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        try {
                            String rhsString = inst.stringValue(rhsAttIndex);
                            return lhsString.contains(rhsString);
                        }
                        catch (IllegalArgumentException ex) {
                            return false;
                        }
                    }
                    return lhsString.contains(rhsOperand);
                }
            }
            ,
            STARTSWITH(" startsWith "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    if (rhsIsAttribute) {
                        if (inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        try {
                            String rhsString = inst.stringValue(rhsAttIndex);
                            return lhsString.startsWith(rhsString);
                        }
                        catch (IllegalArgumentException ex) {
                            return false;
                        }
                    }
                    return lhsString.startsWith(rhsOperand);
                }
            }
            ,
            ENDSWITH(" endsWith "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    if (rhsIsAttribute) {
                        if (inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        try {
                            String rhsString = inst.stringValue(rhsAttIndex);
                            return lhsString.endsWith(rhsString);
                        }
                        catch (IllegalArgumentException ex) {
                            return false;
                        }
                    }
                    return lhsString.endsWith(rhsOperand);
                }
            }
            ,
            REGEX(" regex "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    if (regexPattern == null) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    return regexPattern.matcher(lhsString).matches();
                }
            };

            private final String m_stringVal;

            abstract boolean evaluate(Instance var1, int var2, String var3, double var4, Pattern var6, boolean var7, int var8);

            private ExpressionType(String name) {
                this.m_stringVal = name;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }

    protected static class BracketNode
    extends ExpressionNode
    implements Serializable {
        private static final long serialVersionUID = 8732159083173001115L;
        protected List<ExpressionNode> m_children = new ArrayList<ExpressionNode>();

        protected BracketNode() {
        }

        @Override
        public void init(Instances structure, Environment env) {
            super.init(structure, env);
            for (ExpressionNode n : this.m_children) {
                n.init(structure, env);
            }
        }

        @Override
        public boolean evaluate(Instance inst, boolean result) {
            boolean thisNode = true;
            if (this.m_children.size() > 0) {
                for (ExpressionNode n : this.m_children) {
                    thisNode = n.evaluate(inst, thisNode);
                }
                if (this.isNegated()) {
                    boolean bl = thisNode = !thisNode;
                }
            }
            return this.isOr() ? result || thisNode : result && thisNode;
        }

        public void addChild(ExpressionNode child) {
            this.m_children.add(child);
            if (this.m_children.size() > 0) {
                this.m_children.get(0).setShowAndOr(false);
            }
        }

        public void removeChild(ExpressionNode child) {
            this.m_children.remove(child);
            if (this.m_children.size() > 0) {
                this.m_children.get(0).setShowAndOr(false);
            }
        }

        public String toString() {
            String result = "( )";
            if (this.isNegated()) {
                result = "!" + result;
            }
            if (this.m_showAndOr) {
                result = this.m_isAnOr ? "|| " + result : "&& " + result;
            }
            return result;
        }

        @Override
        public DefaultMutableTreeNode toJTree(DefaultMutableTreeNode parent) {
            DefaultMutableTreeNode current = new DefaultMutableTreeNode(this);
            if (parent != null) {
                parent.add(current);
            }
            for (ExpressionNode child : this.m_children) {
                child.toJTree(current);
            }
            return current;
        }

        private void toString(StringBuffer buff, boolean internal) {
            if (this.m_children.size() >= 0) {
                if (internal || this.m_showAndOr) {
                    if (this.m_isAnOr) {
                        buff.append("|| ");
                    } else {
                        buff.append("&& ");
                    }
                }
                if (this.isNegated()) {
                    buff.append("!");
                }
                buff.append("(");
                int count = 0;
                for (ExpressionNode child : this.m_children) {
                    if (internal) {
                        child.toStringInternal(buff);
                    } else {
                        child.toStringDisplay(buff);
                    }
                    if (++count == this.m_children.size()) continue;
                    buff.append(" ");
                }
                buff.append(")");
            }
        }

        @Override
        public void toStringDisplay(StringBuffer buff) {
            this.toString(buff, false);
        }

        @Override
        protected void toStringInternal(StringBuffer buff) {
            this.toString(buff, true);
        }

        @Override
        protected String parseFromInternal(String expression) {
            if (expression.startsWith("|| ")) {
                this.m_isAnOr = true;
            }
            if (expression.startsWith("|| ") || expression.startsWith("&& ")) {
                expression = expression.substring(3, expression.length());
            }
            if (expression.charAt(0) == '!') {
                this.setNegated(true);
                expression = expression.substring(1, expression.length());
            }
            if (expression.charAt(0) != '(') {
                throw new IllegalArgumentException("Malformed expression! Was expecting a \"(\"");
            }
            expression = expression.substring(1, expression.length());
            while (expression.charAt(0) != ')') {
                ExpressionNode child;
                int offset = 3;
                if (expression.charAt(offset) == '(') {
                    child = new BracketNode();
                    expression = child.parseFromInternal(expression);
                    this.m_children.add(child);
                    continue;
                }
                child = new ExpressionClause();
                expression = child.parseFromInternal(expression);
                this.m_children.add(child);
            }
            if (this.m_children.size() > 0) {
                this.m_children.get(0).setShowAndOr(false);
            }
            return expression;
        }
    }

    protected static abstract class ExpressionNode
    implements Serializable {
        private static final long serialVersionUID = -8427857202322768762L;
        protected boolean m_isAnOr;
        protected boolean m_isNegated;
        protected transient Environment m_env;
        protected boolean m_showAndOr = true;

        protected ExpressionNode() {
        }

        public void setIsOr(boolean isOr) {
            this.m_isAnOr = isOr;
        }

        public boolean isOr() {
            return this.m_isAnOr;
        }

        public boolean isNegated() {
            return this.m_isNegated;
        }

        public void setNegated(boolean negated) {
            this.m_isNegated = negated;
        }

        public void setShowAndOr(boolean show) {
            this.m_showAndOr = show;
        }

        public void init(Instances structure, Environment env) {
            this.m_env = env;
        }

        public abstract boolean evaluate(Instance var1, boolean var2);

        protected abstract void toStringInternal(StringBuffer var1);

        public abstract void toStringDisplay(StringBuffer var1);

        protected abstract String parseFromInternal(String var1);

        public abstract DefaultMutableTreeNode toJTree(DefaultMutableTreeNode var1);
    }
}

