% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotQuantMap}
\alias{plotQuantMap}
\title{Plotting noise-related quantaties of local pruned k-nearest neighbourhoods}
\usage{
plotQuantMap(
  x,
  n,
  object,
  box = FALSE,
  cluster = NULL,
  set = NULL,
  logsc = FALSE,
  cex = 0.5,
  ...
)
}
\arguments{
\item{x}{List object returned by \code{quantKnn} function.}

\item{n}{Component name of \code{x}. One of "noise.av", "noise.ratio", "local.corr", "umi".}

\item{object}{\code{SCseq} class object.}

\item{box}{Logical. If \code{TRUE}, then data are shown as boxplot across clusers. Default is \code{FALSE} and a dimensional reduction representation is shown.}

\item{cluster}{Valid cluster number or vector of cluster numbers, contained in \code{object@cpart}. If given and \code{box=TRUE} then the median of the feature values across clusters in \code{cluster} is indicated as a black solid line in the boxplot. Default is \code{NULL}.}

\item{set}{Ordered set of valid cluster numbers. If \code{box} equals \code{TRUE} than data will only be plotted for these clusters in the given order. Default is \code{NULL} and data for all clutsers will be shown.}

\item{logsc}{logical. If \code{TRUE}, then feature values are log2-transformed. Default is \code{FALSE}.}

\item{cex}{Real positive number. Size of data points. Default is 0.5.}

\item{...}{Additional parameters of \code{plotfeatmap} if \code{box=FALSE} (e.g., \code{um} or \code{fr} to select dimensional reduction representation, see \code{help(plotfeatmap)}), or of \code{plotB} (e.g., \code{ylim}, see \code{help(plotB)}).}
}
\value{
None
}
\description{
Plotting noise-related quantaties of local pruned k-nearest neighbourhoods in the dimensional reduction representation chosen for \code{quantKnn} or as boxplot across clusters.
}
