% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-discrete-walk.R
\name{discrete_walk}
\alias{discrete_walk}
\title{Discrete Sampled Walk}
\usage{
discrete_walk(
  .num_walks = 25,
  .n = 100,
  .upper_bound = 1,
  .lower_bound = -1,
  .upper_probability = 0.5,
  .initial_value = 100
)
}
\arguments{
\item{.num_walks}{Total number of simulations.}

\item{.n}{Total time of the simulation.}

\item{.upper_bound}{The upper bound of the random walk.}

\item{.lower_bound}{The lower bound of the random walk.}

\item{.upper_probability}{The probability of the upper bound. Default is 0.5.
The lower bound is calculated as 1 - .upper_probability.}

\item{.initial_value}{The initial value of the random walk. Default is 100.}
}
\value{
A tibble containing the simulated walks, with columns for the walk number,
time period, and various cumulative metrics (sum, product, min, max).
}
\description{
The \code{discrete_walk} function generates multiple random walks over discrete time periods.
Each step in the walk is determined by a probabilistic sample from specified upper and lower bounds.
This function is useful for simulating stochastic processes, such as stock price movements or
other scenarios where outcomes are determined by a random process.
}
\details{
The function \code{discrete_walk} simulates random walks for a specified number of simulations
(\code{.num_walks}) over a given total time (\code{.n}). Each step in the walk is either the upper
bound or the lower bound, determined by a probability (\code{.upper_probability}). The initial
value of the walk is set by the user (\code{.initial_value}), and the cumulative sum, product,
minimum, and maximum of the steps are calculated for each walk. The results are returned
in a tibble with detailed attributes, including the parameters used for the simulation.
}
\examples{
library(ggplot2)

set.seed(123)
discrete_walk()

set.seed(123)
discrete_walk(.num_walks = 30, .n = 250, .upper_probability = 0.55) |>
ggplot(aes(x = x, y = cum_sum)) +
 geom_line(aes(group = walk_number), alpha = .618, color = "steelblue") +
 theme_minimal() +
 theme(legend.position = "none") +
 geom_smooth(method = "lm", se = FALSE)

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Generator Functions}
