% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_annual_peak_event.R
\name{rvn_annual_peak_event}
\alias{rvn_annual_peak_event}
\title{Annual Peak Event Comparison}
\usage{
rvn_annual_peak_event(
  sim,
  obs,
  mm = 9,
  dd = 30,
  add_line = TRUE,
  add_r2 = FALSE,
  add_eqn = FALSE
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{mm}{month of water year (default 9)}

\item{dd}{day of water year (default 30)}

\item{add_line}{optionally adds a 1:1 line to the plot for reference
(default TRUE)}

\item{add_r2}{optionally computes the R2 and adds to plot (default FALSE)}

\item{add_eqn}{optionally adds the equation for a linear regression line through the origin (default FALSE)}
}
\value{
returns a list with peak data in a data frame, and a ggplot object
 \item{df_peak_event}{data frame of the calculated peak events}
 \item{p1}{ggplot object with plotted annual peaks}
}
\description{
rvn_annual_peak_event creates a plot of the annual observed and simulated peaks,
based on the water year.
}
\details{
This function creates a scatterplot of the annual observed and simulated
peaks, calculated for each available water year of data
within the two series provided; note that the difference between this and
the annual.peak function is that here the peak event simulated for the same
day as the peak event in observed data is used, instead of the largest
recorded simulated event. In some sense this captures the timing of the
event, i.e. the peak event must be simulated on the same day as the observed
peak to be captured well.

The sim and obs should be of time series (xts) format and are assumed to be
of the same length and time period. The flow series are assumed to be daily
flows with units of m3/s.

The R2 diagnostic is calculated for a fit with no intercept (in a perfect
fit the points are identical, and intercept is automatically zero).

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{

# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)
sim <- rvn_hydrograph_data$hyd$Sub36
obs <- rvn_hydrograph_data$hyd$Sub36_obs

# create a plot of annual peak events with default options
peak1 <- rvn_annual_peak_event(sim, obs)
peak1$df_peak_event
peak1$p1

}
\seealso{
\code{\link{rvn_annual_peak}} to create a scatterplot of annual peaks
(consider the magnitude of peaks only)
}
