% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvi_process_plot.R
\name{rvn_rvi_process_plot}
\alias{rvn_rvi_process_plot}
\title{Plot Raven hydrologic process network}
\usage{
rvn_rvi_process_plot(connections, pdfout = NULL)
}
\arguments{
\item{connections}{a dataframe of from-to connections generated using rvn_rvi_connections()}

\item{pdfout}{name of pdf file to save the network plot to, if null no PDF is generated}
}
\value{
{p1}{returns ggplot object. Also generates a .pdf file in working directory if pdfplot argument is not NULL.}
}
\description{
This routine takes a connections data from generated using rvn_rvi_connections()
and returns the connections information as a network graph ggplot object.
}
\details{
This function uses the output from the \code{\link{rvn_rvi_connections}} function to generate the plot.
}
\note{
tries to follow basic network structure, accomodates unrecognized state variables on LHS of plot
}
\examples{
rvi <- rvn_rvi_read(system.file("extdata","Nith.rvi", package="RavenR"))
conn <- rvn_rvi_connections(rvi)

rvn_rvi_process_plot(conn)

}
\seealso{
\code{\link{rvn_rvi_connections}} to generate connections table from an rvi object

See also the \href{http://raven.uwaterloo.ca/}{Raven page}
}
\author{
James R. Craig, University of Waterloo
}
