\name{load.cellX.data}
\alias{load.cellX.data}
\title{Load CellX Data}
\description{
This function loads datasets generated by cellX. 

}
\usage{
load.cellX.data(pattern=glob2rx("Position*.txt"),path=getwd())
}


\arguments{
   \item{pattern}{regular expression (see \link{regexp}) pattern of the files to be loaded}
   \item{path}{character containing path from where to search for the files}
  		
}

\details{

This function searches for output files in the \code{path} folder that match the specified 
\code{pattern} (regular expression). The files are expected to have a numeric value in their file name
that is taken as the position index (for example Position34-data.txt is given the index 34, and all the 
registers of this position will have pos=34). 
All the data files are expected to have the same variables. 

For compatibility with Rcell functions, some variables are renamed as follows
track.index -> cellID
cell.frame -> t.frame

}

\value{
  a cell.data object
}
\author{ Alan Bush }
\seealso{
   \code{\link{load.cellID.data}}
}
\examples{
\dontrun{
setwd(".")  #set the working directory to the folder with your data files
X<-load.cellX.data()  #load the dataset to R

}
}
\keyword{IO}
\keyword{manip}
