% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Rchoice.methods.R
\name{effect.Rchoice}
\alias{effect.Rchoice}
\title{Get the conditional individual coefficients}
\usage{
effect.Rchoice(x, par = NULL, effect = c("cv", "ce"), wrt = NULL, ...)
}
\arguments{
\item{x}{a object of class \code{Rchoice},}

\item{par}{a string giving the name of the variable with random parameter,}

\item{effect}{a string indicating what should be computed: the conditional expectation of the individual coefficients "\code{ce}", or the conditional expectation of the individual compensating variations "\code{cv}",}

\item{wrt}{a string indicating repect to which variable the compensating variation should be computed,}

\item{...}{further arguments. Ignored.}
}
\value{
A named list where ``mean'' contains the individuals' conditional mean for the random parameter or compensating variation, and where `sd.est' contains their standard errors.
}
\description{
This a helper function to obtain the individuals' conditional estimate of the random parameters or compensating variations.
}
\examples{
\dontrun{
## Probit Model with Random Effects and Random Parameters
data('Unions', package = 'pglm')
Unions$lwage <- log(Unions$wage)
union.ran <- Rchoice(union ~ age + exper + rural + lwage,
                     data = Unions[1:2000, ],
                     family = binomial('probit'),
                     ranp = c(constant = "n", lwage = "t"),
                     R = 10,
                     panel = TRUE,
                     index = "id",
                     print.init = TRUE)

## Get the individuals' conditional mean and their standard errors for lwage
bi.wage <- effect.Rchoice(union.ran, par = "lwage", effect = "ce")
summary(bi.wage$mean)
summary(bi.wage$sd.est)
}
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric Analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge university press.
}
}
\seealso{
\code{\link[Rchoice]{Rchoice}} for the estimation of different discrete choice models with individual parameters.
}

