# last modified 24 June 1010 by J. Fox

survregModel <-
	function(){
	## notes: robust=TRUE causes errors 
	## counting-process form of Surv() doesn't seem to work
	require(survival)
	if (!activeDataSetP()) return()
	initializeDialog(title=gettext("Survival Regression Model", domain="R-RcmdrPlugin.survival"))
	.activeModel <- ActiveModel()
	currentModel <- if (!is.null(.activeModel))
			class(get(.activeModel, envir=.GlobalEnv))[1] == "survreg"
		else FALSE
	if (currentModel) {
		currentFields <- formulaFields(get(.activeModel, envir=.GlobalEnv), hasLhs=TRUE)
		if (currentFields$data != ActiveDataSet()) currentModel <- FALSE
	}
	UpdateModelNumber()
	modelName <- tclVar(paste("SurvregModel.", getRcmdr("modelNumber"), sep=""))
	modelFrame <- tkframe(top)
	model <- ttkentry(modelFrame, width="20", textvariable=modelName)
	onOK <- function(){
		time <- getSelection(timeBox)
		if (length(time) == 1){
			time1 <- time
			time2 <- numeric(0)
		}
		else if (length(time) == 2){
			ss <- startStop(time)
			if (ss$error) errorCondition(recall=survregModel, 
					message=gettext("Start and stop times must be ordered.", 
						domain="R-RcmdrPlugin.survival"), model=TRUE)
			time1 <- ss$start
			time2 <- ss$stop
		}
		else {
			errorCondition(recall=survregModel, message=gettext("You must select one or two time variables.", 
					domain="R-RcmdrPlugin.survival"), model=TRUE)
			return()
		}
		event <- getSelection(eventBox)
#		if (length(event) == 0) {
#			errorCondition(recall=survregModel, message=gettext("You must select an event indicator.", 
#					domain="R-RcmdrPlugin.survival"), model=TRUE)
#			return()
#		}
		strata <- getSelection(strataBox)
		cluster <- getSelection(clusterBox)
		survtype <- as.character(tclvalue(survtypeVariable))
		modelValue <- trim.blanks(tclvalue(modelName))
		robust <- as.character(tclvalue(robustVariable))
		dist <- as.character(tclvalue(distributionVariable))
		closeDialog()
		if (survtype == "interval" && length(event) == 0){
			errorCondition(recall=survregModel, 
					message=gettext("You must select an event indicator if censoring is 'interval'.", 
							domain="R-RcmdrPlugin.survival"))
			return()
		}
		if (survtype == "interval2" && length(event) != 0){
			errorCondition(recall=survregModel, 
					message=gettext("You should not select an event indicator if censoring is 'interval2'.", 
							domain="R-RcmdrPlugin.survival"))
			return()
		}
		if (length(time) == 2 && (! survtype %in% c("counting", "interval", "interval2"))){
			errorCondition(recall=survregModel,
					message=gettext("start-end times only for counting-process or interval censoring.",
							domain="R-RcmdrPlugin.survival"))
			return()
		}
		if (length(time) == 1 && survtype %in% c("counting", "interval", "interval2")){
			errorCondition(recall=survregModel,
					message=gettext("start-end times required for counting-process or interval censoring.",
							domain="R-RcmdrPlugin.survival"))
			return()
		}
		if (!is.valid.name(modelValue)){
			errorCondition(recall=survregModel, message=sprintf(gettext('"%s" is not a valid name.', 
						domain="R-RcmdrPlugin.survival"), modelValue), model=TRUE)
			return()
		}
		subset <- tclvalue(subsetVariable)
		if (trim.blanks(subset) == gettext("<all valid cases>", domain="R-RcmdrPlugin.survival") 
			|| trim.blanks(subset) == ""){
			subset <- ""
			putRcmdr("modelWithSubset", FALSE)
		}
		else{
			subset <- paste(", subset=", subset, sep="")
			putRcmdr("modelWithSubset", TRUE)
		}
		check.empty <- gsub(" ", "", tclvalue(rhsVariable))
		if ("" == check.empty) {
			errorCondition(recall=survregModel, message=gettext("Right-hand side of model empty.", 
					domain="R-RcmdrPlugin.survival"), model=TRUE)
			return()
		}
		if (is.element(modelValue, listSurvregModels())) {
			if ("no" == tclvalue(checkReplace(modelValue, type=gettext("Model", 
						domain="R-RcmdrPlugin.survival")))){
				UpdateModelNumber(-1)
				survregModel()
				return()
			}
		}
		formula <- paste("Surv(", time1,
				if (length(time2) != 0) paste(",", time2),
				if (length(event) != 0) paste(",", event),
				if (survtype != "default") paste(', type="', survtype, '"', sep=""),
				")", sep="")
#		formula <- paste("Surv(", time1, ",",
#			if(length(time2) != 0) paste(time2, ",", sep=""),
#			event, ") ~ ", tclvalue(rhsVariable), sep="")
		formula <- paste(formula, "~", tclvalue(rhsVariable))
		if (length(strata) > 0 && length(grep("strata\\(", formula)) == 0) 
			formula <- paste(formula, " + strata(", paste(strata, collapse=","), ")", sep="")
		if (length(cluster) > 0 && length(grep("cluster\\(", formula)) == 0) 
			formula <- paste(formula, " + cluster(", cluster, ")", sep="")
		command <- paste("survreg(", formula, ', dist="', dist, '"',
			if (robust != "default") paste(", robust=", robust, sep=""),
			", data=", ActiveDataSet(), subset, ")", sep="")
		logger(paste(modelValue, " <- ", command, sep=""))
		assign(modelValue, justDoIt(command), envir=.GlobalEnv)
		doItAndPrint(paste("summary(", modelValue, ")", sep=""))
		activeModel(modelValue)
		tkfocus(CommanderWindow())
	}
	OKCancelHelp(helpSubject="survreg", model=TRUE)
	tkgrid(labelRcmdr(modelFrame, text=gettext("Enter name for model:", domain="R-RcmdrPlugin.survival")), model, sticky="w")
	tkgrid(modelFrame, sticky="w")
	survFrame <- tkframe(top)
	.activeDataSet <- ActiveDataSet()
	.numeric <- NumericOrDate()
	.factors <- Factors()
	.variables <- Variables()
	time1 <- eval(parse(text=paste('attr(', .activeDataSet, ', "time1")', sep="")))
	time1 <- if (!is.null(time1)) which(time1 == .numeric) - 1 
	time2 <- eval(parse(text=paste('attr(', .activeDataSet, ', "time2")', sep="")))
	time2 <- if (!is.null(time2)) which(time2 == .numeric) - 1 
	event <- eval(parse(text=paste('attr(', .activeDataSet, ', "event")', sep="")))
	event <- if (!is.null(event)) which(event == Numeric()) - 1 
	strata <- eval(parse(text=paste('attr(', .activeDataSet, ', "strata")', sep="")))
	strata <- if (!is.null(strata)) which(is.element(.factors, strata)) - 1 else -1
	cluster <- eval(parse(text=paste('attr(', .activeDataSet, ', "cluster")', sep="")))
	cluster <- if (!is.null(cluster)) which(cluster == if (allVarsClusters()) .variables else .factors) - 1 else -1
	timeBox <- variableListBox(survFrame, NumericOrDate(), 
		title=gettext("Time or start/end times\n(select one or two)", domain="R-RcmdrPlugin.survival"),
		selectmode="multiple", initialSelection=if(is.null(time1)) NULL else c(time1, time2))
	eventBox <- variableListBox(survFrame, Numeric(), 
		title=gettext("Event indicator\n(select one or none)", domain="R-RcmdrPlugin.survival"),
		initialSelection=event)
	strataBox <- variableListBox(survFrame, Factors(), 
		title=gettext("Strata\n(select zero or more)", domain="R-RcmdrPlugin.survival"), 
		selectmode="multiple", initialSelection=strata)
	clusterBox <- variableListBox(survFrame, if (allVarsClusters()) Variables() else Factors(), 
		title=gettext("Clusters\n(optional)", domain="R-RcmdrPlugin.survival"), initialSelection=cluster)
	optionsFrame <- tkframe(top)
	radioButtons(optionsFrame, name="survtype",
		buttons=c("default", "right", "left", "interval", "counting", "interval2"),
		labels=gettext(c("Default", "Right", "Left", "Interval", "Counting", "Interval type 2")),
		initialValue="default", title=gettext("Type of Censoring", domain="R-RcmdrPlugin.survival"))
	radioButtons(optionsFrame, name="distribution",
		buttons=c("weibull", "exponential", "gaussian", "logistic", "lognormal", "loglogistic"), initialValue="weibull",
		labels=gettext(c("Weibull", "Exponential", "Gaussian", "Logistic", "Log-normal", "Log-logistic"), 
			domain="R-RcmdrPlugin.survival"), title=gettext("Distribution", domain="R-RcmdrPlugin.survival"))
	radioButtons(optionsFrame, name="robust",
		buttons=c("default", "TRUE", "FALSE"), initialValue="default",
		labels=gettext(c("Default", "Yes", "No"), domain="R-RcmdrPlugin.survival"), 
		title=gettext("Robust Standard Errors", domain="R-RcmdrPlugin.survival"))
	modelFormula(hasLhs=FALSE)
	subsetBox(model=TRUE)
	tkgrid(getFrame(timeBox), labelRcmdr(survFrame, text="  "), getFrame(eventBox), sticky="nw")
	tkgrid(labelRcmdr(survFrame, text=""))
	tkgrid(getFrame(strataBox), labelRcmdr(survFrame, text="  "), getFrame(clusterBox), 
			labelRcmdr(survFrame, text="  "), sticky="nw")
	tkgrid(survFrame, sticky="w")
	tkgrid(distributionFrame, labelRcmdr(optionsFrame, text="  "), robustFrame, 
			labelRcmdr(optionsFrame, text="  "), survtypeFrame, sticky="nw")
	tkgrid(labelRcmdr(top, text=""))
	tkgrid(optionsFrame, sticky="w")
	tkgrid(labelRcmdr(top, text=""))
	tkgrid(getFrame(xBox), sticky="w", columnspan=2)
	tkgrid(labelRcmdr(outerOperatorsFrame, text="         "), operatorsFrame, sticky="w")
	tkgrid(outerOperatorsFrame, sticky="ew")
	tkgrid(formulaFrame, sticky="w")
	tkgrid(labelRcmdr(top, text=""))
	tkgrid(subsetFrame, sticky="w")
	tkgrid(labelRcmdr(top, text=""))
	tkgrid(buttonsFrame, sticky="w")
	dialogSuffix(rows=13, columns=1, focus=rhsEntry, preventDoubleClick=TRUE)
}

