% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry.R
\name{registry file}
\alias{registry file}
\alias{registry_file_make}
\alias{registry_file_write}
\title{Generate and Write Registry File.}
\usage{
registry_file_make(registry_dir, corpus, description = "", data_dir,
  info_file = NULL, corpus_properties = c(language = "en", charset =
  "latin-1"), p_attributes = "word", s_attributes = NULL)

registry_file_write(registry_dir, corpus, ...)
}
\arguments{
\item{registry_dir}{the registry directory}

\item{corpus}{name of the corpus, will be used as ID (using tolower)}

\item{description}{long descriptive name for the corpus}

\item{data_dir}{path to binary data files}

\item{info_file}{optional info file, if NULL, we assume that file ".info.md" is in \code{data_dir}}

\item{corpus_properties}{named vector of corpus properties; properties
\code{language} and \code{charset} need to be present}

\item{p_attributes}{positional attributes to be declared}

\item{s_attributes}{structural attributes to be declared}

\item{...}{parameters that are passed into \code{registry_file_write}}
}
\value{
the character vector of the registry file is returned invisibly
}
\description{
Generate a registry file describing a CWB indexed corpus.
\code{registry_file_make} will create a character vector with the content of
the registry file. \code{registry_file_write} will write also write this 
content as a registry file to directors \code{registry_dir}.
}
\details{
A CWB indexed corpus needs to be described in a registry file. See the CWB
Corpus Encoding Tutorial, Appendix A (pp. 21f) for an example registry file
(\url{http://cwb.sourceforge.net/files/CWB_Encoding_Tutorial.pdf}).

In addition to the corpus properties explicitly declared, the corpus property
"drive_letter" will be added on Windows machines to handle the case that the 
data directory may be on another drive than the drive of the current working 
directory.
}
\examples{
dir.create(temp_regdir <- tempfile())
temp_data_dir <- tempfile()
if (.Platform$OS.type == "windows"){
  temp_data_dir <- normalizePath(temp_data_dir, winslash = "/")
}

reuters_regfile <- registry_file_make(
  corpus = "REUTERS", description = "Reuters Example Corpus",
  data_dir = temp_data_dir, info_file = NULL,
  corpus_properties = c(language = "en", charset = "latin-1"),
  p_attributes = "word", s_attributes = c("places", "id")
  )
registry_file_write(
  registry_dir = temp_regdir, corpus = "REUTERS", description = "Reuters Example Corpus",
  data_dir = temp_data_dir, info_file = NULL,
  corpus_properties = c(language = "en", charset = "latin-1"),
  p_attributes = "word", s_attributes = c("places", "id")
  )
regfile <- readLines(file.path(temp_regdir, "reuters"))
}
