% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{get_count_vector}
\alias{get_count_vector}
\title{Get Vector with Counts for Positional Attribute.}
\usage{
get_count_vector(corpus, p_attribute,
  registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{corpus}{a CWB corpus}

\item{p_attribute}{a positional attribute}

\item{registry}{registry directory}
}
\value{
an integer vector
}
\description{
The return value is an integer vector. The length of the vector is the number of 
unique tokens in the corpus / the number of unique ids. The order of the counts
corresponds to the number of ids.
}
\examples{
registry <- if (!check_pkg_registry_files()) use_tmp_registry() else get_pkg_registry()
y <- get_count_vector(
  corpus = "REUTERS", p_attribute = "word",
  registry = registry
  )
df <- data.frame(token_id = 0:(length(y) - 1), count = y)
df[["token"]] <- cl_id2str(
  "REUTERS", p_attribute = "word",
  id = df[["token_id"]], registry = registry
  )
df <- df[,c("token", "token_id", "count")] # reorder columns
df <- df[order(df[["count"]], decreasing = TRUE),]
head(df)
}
