% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.R, R/RcppExports.R
\name{cl_rework}
\alias{cl_rework}
\alias{s_attr}
\alias{p_attr}
\alias{p_attr_size}
\alias{s_attr_size}
\alias{p_attr_lexicon_size}
\alias{cpos_to_struc}
\alias{cpos_to_str}
\alias{cpos_to_id}
\alias{struc_to_cpos}
\alias{struc_to_str}
\alias{regex_to_id}
\alias{str_to_id}
\alias{id_to_freq}
\alias{id_to_cpos}
\alias{cpos_to_lbound}
\alias{cpos_to_rbound}
\title{Low-level CL access.}
\usage{
s_attr(corpus, s_attribute, registry)

p_attr(corpus, p_attribute, registry)

p_attr_size(p_attr)

s_attr_size(s_attr)

p_attr_lexicon_size(p_attr)

cpos_to_struc(s_attr, cpos)

cpos_to_str(p_attr, cpos)

cpos_to_id(p_attr, cpos)

struc_to_cpos(s_attr, struc)

struc_to_str(s_attr, struc)

regex_to_id(p_attr, regex)

str_to_id(p_attr, str)

id_to_freq(p_attr, id)

id_to_cpos(p_attr, id)

cpos_to_lbound(s_attr, cpos)

cpos_to_rbound(s_attr, cpos)
}
\arguments{
\item{corpus}{ID of a CWB corpus (length-one \code{character} vector).}

\item{s_attribute}{A structural attribute (length-one \code{character} vector).}

\item{registry}{Registry directory.}

\item{p_attribute}{A positional attribute (length-one \code{character} vector).}

\item{p_attr}{A \code{externalptr} referencing a p-attribute.}

\item{s_attr}{A \code{externalptr} referencing a p-attribute.}

\item{cpos}{An \code{integer} vector of corpus positions.}

\item{struc}{A length-one \code{integer} vector with a struc.}

\item{regex}{A regular expression.}

\item{str}{A \code{character} vector.}

\item{id}{An \code{integer} vector with token ids.}
}
\description{
Wrappers for CWB Corpus Library functions suited for writing performance
code.
}
\details{
The default cl_* R wrappers for the functions of the CWB Corpus Library
involve a lookup of a corpus and its p- or s-attributes (using the corpus ID,
registry and attribute indicated by length-one character vectors) every time
one of these functions is called. It is more efficient looking up an
attribute only once. This set of functions passes "externalptr" classes to
reference attributes that have been looked up. A relevant scenario is writing
functions with a C++ implementation that are compiled and linked using
\code{Rcpp::cppFunction()} or \code{Rcpp::sourceCpp()}
}
\examples{
library(Rcpp)

cppFunction(
  'Rcpp::StringVector get_str(
     SEXP corpus,
     SEXP p_attribute,
     SEXP registry,
     Rcpp::IntegerVector cpos
   ){
     SEXP attr;
     Rcpp::StringVector result;
     attr = RcppCWB::p_attr(corpus, p_attribute, registry);
     result = RcppCWB::cpos_to_str(attr, cpos);
     return(result);
  }',
  depends = "RcppCWB"
)

result <- get_str("REUTERS", "word", RcppCWB::get_tmp_registry(), 0:50)
}
