% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movCountUE}
\alias{movCountUE}
\alias{movCountUEr}
\title{Weighted Simple Moving Count for Unevenly Spaced Time Series}
\usage{
movCountUE(vec, pos, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE,
  align = "left")

movCountUEr(vec, pos, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{pos}{A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
N.B. We use integers to represent the (relative) positions of every point.}

\item{n}{An integer: moving window size, with 1 as default}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
(when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
original vector, and the third column the moving average.
}
\description{
This function returns A matrix: the first column is the position, the second column 
the input vector, and third column Moving Count of the given vector. The weight 
argument is optional.
}
\details{
This function counts the number of non-missing values for each moving window. It is 
especially designed for \emph{vec} vector with missing values. Otherwise, it will return a trivial 
vector with all elements \emph{n}. \cr
This function is more helpful than \code{movCount}, as we would have missing values for an Unevenly 
Spaced Time Series. \cr
For matrix details, please refer to details of \code{movMeanUE}.
}
\section{Functions}{
\itemize{
\item \code{movCountUEr}: An function equivalent to \code{movCountUE(..., align = "right")}
}}

\examples{
movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), 2)
movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE)
movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
sizeD = TRUE)
movCountUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, 
ss = 3, na_rm = TRUE, align = "right")
movCountUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, 
na_rm = TRUE, sizeD = TRUE, align = "right")
movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9),  n = 2, ss = 3, 
na_rm = TRUE)
movCountUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
sizeD = TRUE)
}
