% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcssWatch.R
\name{RcssWatch}
\alias{RcssWatch}
\title{development tool for adjusting Rcss and R graphics code}
\usage{
RcssWatch(f, files = NULL, ...)
}
\arguments{
\item{f}{function or character of function name, executed at each iteration}

\item{files}{character, paths to R and Rcss files}

\item{...}{other arguments, passed to function f}
}
\description{
This is a macro script that loads R code and a default Rcss style,
and then executes a function. This process is repeated indefinitely.
}
\examples{

# Note: the examples below draw a charat once and exit.
# To enable quick re-drawing, RcssWatch must be provided with file paths

# draw and redraw a bar plot
RcssWatch(plot, x=1:4, y=1:4)

# alternative syntax, using a function name as a string
custom.barplot <- function(x=1:4, main="") { barplot(x, main=main) }
RcssWatch("custom.barplot", main="Custom")

# for more interesting behavior, specify a files with styles and R source

}
