% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curveclass2_base.R
\name{fit_cc2_modl}
\alias{fit_cc2_modl}
\title{Fit concentration-response data using Curve Class2 approach}
\usage{
fit_cc2_modl(Conc, Resp, classSD = 5, minYrange = 20, ...)
}
\arguments{
\item{Conc}{A vector of log10 concentrations.}

\item{Resp}{A vector of numeric responses.}

\item{classSD}{A standard deviation (SD) derived from the responses in the vehicle control.
it is used for classification of the curves. Default = 5\%.}

\item{minYrange}{A minimum response range (max activity - min activity) required to apply curve fitting.
Curve fitting will not be attempted if the response range is less than the cutoff.
Default = 20\%.}

\item{...}{for additional curve class2 parameters (currently none)}
}
\value{
A list of output parameters from Curve Class2 model fit.
If the data are fit or not fittable (fit = 0), the default value for tp, ga, gw, bt pvalue, masks, nmasks is NA.
For cc2 = 4, it is still possible to have fit parameters.

\itemize{
\item modl: model type, i.e., cc2
\item fit: fittable, 1 (yes) or 0 (no)
\item aic: NA, it is not calculated for this model. The parameter is kept for compatability.
\item cc2: curve class2, default = 4
\item tp: model top, <0 means the fit for decreasing direction is preferred
\item ga: ac50 (log10 scale)
\item gw: Hill coefficient
\item bt: model bottom
\item pvalue: from F-test, for fit quality
\item r2: fitness
\item masks: a string to indicate at which positions of response are masked
\item nmasks: number of masked responses
}
}
\description{
Curve Class2 uses 4-parameter Hill model to fit the data.
The algorithm assumes the responses are in percentile.
Curve Class2 classifies the curves based on fit quality and response magnitude.
}
\details{
\describe{
\item{cc2 = 1.1}{2-asymptote curve, pvalue < 0.05, emax > 6\*classSD}
\item{cc2 = 1.2}{2-asymptote curve, pvalue < 0.05, emax <= 6\*classSD & emax > 3\*classSD}
\item{cc2 = 1.3}{2-asymptote curve, pvalue >= 0.05, emax > 6\*classSD}
\item{cc2 = 1.4}{2-asymptote curve, pvalue >= 0.05, emax <= 6\*classSD & emax > 3\*classSD}
\item{cc2 = 2.1}{1-asymptote curve, pvalue < 0.05, emax > 6\*classSD}
\item{cc2 = 2.2}{1-asymptote curve, pvalue < 0.05, emax <= 6\*classSD & emax > 3\*classSD}
\item{cc2 = 2.3}{1-asymptote curve, pvalue >= 0.05, emax > 6\*classSD}
\item{cc2 = 2.4}{1-asymptote curve, pvalue >= 0.05, emax <= 6\*classSD & emax > 3\*classSD}
\item{cc2 = 3}{single point activity, pvalue = NA, emax > 3\*classSD}
\item{cc2 = 4}{inactive, pvalue  >= 0.05, emax <= 3\*classSD}
\item{cc2 = 5}{inconclusive, high bt, further investigation is needed}
}
}
\examples{

fit_cc2_modl(c(-9, -8, -7, -6, -5, -4), c(0, 2, 30, 40, 50, 60))



}
\references{
{
\insertRef{PMID:35294762}{Rcurvep}
}
}
\seealso{
\code{\link[=fit_modls]{fit_modls()}}
}
