\name{roxygen_and_build}
\alias{roxygen_and_build}
\title{Roxygenize a package, clean up and build/check the package}
\usage{roxygen_and_build(pkg, roxygen.dir, install = FALSE, check = FALSE, check.opts = "", 
    remove.check = TRUE, escape = TRUE, reformat = TRUE, use.Rd2 = TRUE, ...)
rab(...)}
\description{Roxygenize a package, clean up and build/check the package.}
\details{\code{roxygen_and_build}: After the source package is roxygenized, this function first removes the
unnecessary Rd files, and build the package. Optionally
it also installs or checks the package, reformats the code in the usage and
examples section, and replaces `\%' with `\\\%'.

}
\alias{roxygen_and_build}
\alias{rab}
\note{This function also tries to remove directories \file{pkg/inst/doc} and
\file{pkg/inst} if they are empty; this is due to the fact that roxygen
will generate these directories no matter if they are needed.

This function also has a short name \code{rab} to avoid typing efforts.}
\value{\code{roxygen_and_build}: NULL

}
\author{Yihui Xie <\url{http://yihui.name}>}
\arguments{\item{pkg}{the root directory of the source package}
\item{roxygen.dir}{the directory for the roxygenized package (by
default it is \code{pkg.roxygen})}
\item{install}{whether to install the package}
\item{check}{whether to check the package}
\item{check.opts}{options to check the package
(e.g. \code{"--no-examples"})}
\item{remove.check}{whether to remove the directory generated by
\command{R CMD check}}
\item{escape}{whether to escape \code{"\%"}}
\item{reformat}{whether to reformat the examples and usage and
escape the percent symbol sections; see
\code{\link{reformat_code}}. Note roxygen will also write the
title in the description by default unless the user specifies a
@title tag, and this \code{reformat} option can also remove the
redundant title string in the description as well as the period in
the end of the title}
\item{use.Rd2}{passed to \code{\link[roxygen]{roxygenize}}; see
\code{\link[roxygen]{make.Rd2.roclet}}}
\item{...}{other arguments passed to
\code{\link[roxygen]{roxygenize}}}
}
\examples{\dontrun{
    
    roxygen_and_build("Rd2roxygen", install = TRUE)
    ## or simply
    rab("Rd2roxygen", install = TRUE)
}}
\alias{rab}

