% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_CSCOREG.R
\name{do.cscoreg}
\alias{do.cscoreg}
\title{Constraint Score using Spectral Graph}
\usage{
do.cscoreg(
  X,
  label,
  ndim = 2,
  score = c("ratio", "difference"),
  lambda = 0.5,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{score}{type of score measures from two score vectors of same- and different-class pairwise constraints; \code{"ratio"} and \code{"difference"} method. See the paper from the reference for more details.}

\item{lambda}{a penalty value for different-class pairwise constraints. Only valid for \code{"difference"} scoring method.}

\item{preprocess}{an additional option for preprocessing the data. Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{cscore}{a length-\eqn{p} vector of constraint scores. Indices with smallest values are selected.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Constraint Score is a filter-type algorithm for feature selection using pairwise constraints.
It first marks all pairwise constraints as same- and different-cluster and
construct a feature score for both constraints. It takes ratio or difference of
feature score vectors and selects the indices with smallest values. Graph laplacian is constructed
for approximated nonlinear manifold structure.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
iris.dat = as.matrix(iris[,1:4])
iris.lab = as.factor(iris[,5])

## try different strategy
out1 = do.cscoreg(iris.dat, iris.lab, score="ratio")
out2 = do.cscoreg(iris.dat, iris.lab, score="difference", lambda=0)
out3 = do.cscoreg(iris.dat, iris.lab, score="difference", lambda=0.5)
out4 = do.cscoreg(iris.dat, iris.lab, score="difference", lambda=1)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2))
plot(out1$Y, col=iris.lab, main="ratio")
plot(out2$Y, col=iris.lab, main="diff/lambda=0")
plot(out3$Y, col=iris.lab, main="diff/lambda=0.5")
plot(out4$Y, col=iris.lab, main="diff/lambda=1")
par(opar)
}

}
\references{
\insertRef{zhang_constraint_2008a}{Rdimtools}
}
\seealso{
\code{\link{do.cscore}}
}
\author{
Kisung You
}
